/*
 * Decompiled with CFR 0.152.
 */
package io.fotoapparat.facedetector;

import io.fotoapparat.facedetector.Rectangle;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class FaceDetectorWrapper {
    public abstract ArrayList<Rectangle> detectFaces(byte[] var1, int var2, int var3, int var4);

    public static native FaceDetectorWrapper create(String var0);

    private static final class CppProxy
    extends FaceDetectorWrapper {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public ArrayList<Rectangle> detectFaces(byte[] image, int frameWidth, int frameHeight, int rotationDegrees) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_detectFaces(this.nativeRef, image, frameWidth, frameHeight, rotationDegrees);
        }

        private native ArrayList<Rectangle> native_detectFaces(long var1, byte[] var3, int var4, int var5, int var6);
    }
}

