/*
 * Decompiled with CFR 0.152.
 */
package io.fotoapparat.facedetector;

import android.content.Context;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

class AssetsExtractor {
    private final Context context;
    private final String assetFileName;

    AssetsExtractor(Context context, String assetFileName) {
        this.context = context;
        this.assetFileName = assetFileName;
    }

    public File extractIfNeeded() {
        File extractedFile = this.extractedFile();
        if (extractedFile.exists()) {
            return extractedFile;
        }
        this.extractFileUnsafe(extractedFile);
        return extractedFile;
    }

    private void extractFileUnsafe(File extractedFile) {
        try {
            this.extractFile(extractedFile);
        }
        catch (IOException e) {
            throw new ExtractionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFile(File extractedFile) throws IOException {
        InputStream assetsStream = this.context.getAssets().open(this.assetFileName);
        FileOutputStream outputStream = new FileOutputStream(extractedFile);
        try {
            int r;
            byte[] buffer = new byte[8192];
            while ((r = assetsStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, r);
            }
        }
        finally {
            outputStream.flush();
            outputStream.close();
            assetsStream.close();
        }
    }

    private File extractedFile() {
        File directory = this.context.getExternalFilesDir(null);
        this.ensureValidDirectory(directory);
        return new File(directory, this.assetFileName);
    }

    private void ensureValidDirectory(File directory) {
        if (directory == null || !directory.exists()) {
            throw new ExtractionException("Not a valid external directory: " + directory);
        }
        if (!directory.isDirectory()) {
            throw new ExtractionException("Not a directory: " + directory);
        }
    }

    static class ExtractionException
    extends RuntimeException {
        ExtractionException(Throwable cause) {
            super(cause);
        }

        ExtractionException(String message) {
            super(message);
        }
    }
}

