package com.caysn.autoreplyprint;

import android.graphics.Bitmap;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.ptr.IntByReference;

public interface NZBarcode extends Library {

    // static interface method need jdk1.8. here we use inner class to avoid this porblem.
    class GetLibraryPath_Helper {
        // can replaced by absolute path
        public static String GetLibraryPath() {
            // force call JNI_OnLoad
            if (Platform.isAndroid())
                System.loadLibrary("autoreplyprint");
            return "autoreplyprint";
        }
    }

    public static final NZBarcode INSTANCE = (NZBarcode) Native.loadLibrary(NZBarcode.GetLibraryPath_Helper.GetLibraryPath(), NZBarcode.class);

    public int CP_Barcode_GetBarcodeWidth(int barcodeType, int barcodeUnitWidth, String barcodeData);

    public boolean CP_Barcode_GetBarcodeRGBAData(int barcodeType, int barcodeUnitWidth, int barcodeHeight, int backgroundColor, int barcodeColor, String barcodeData, int[] bitmap_buffer, int bitmap_buffer_bytesize, IntByReference bitmap_width, IntByReference bitmap_height);

    public class NZBarcodeHelper {
        public static Bitmap GetBarcodeBitmap(int barcodeType, int barcodeUnitWidth, int barcodeHeight, int backgroundColor, int barcodeColor, String barcodeData) {
            Bitmap bitmap = null;
            try {
                int barcodeWidth = NZBarcode.INSTANCE.CP_Barcode_GetBarcodeWidth(barcodeType, barcodeUnitWidth, barcodeData);
                if (barcodeWidth > 0) {
                    int bitmap_buffer_bytesize = barcodeWidth * barcodeHeight * 4;
                    int[] bitmap_buffer = new int[barcodeWidth * barcodeHeight];
                    if (bitmap_buffer != null) {
                        IntByReference bitmap_width = new IntByReference();
                        IntByReference bitmap_height = new IntByReference();
                        if (NZBarcode.INSTANCE.CP_Barcode_GetBarcodeRGBAData(barcodeType, barcodeUnitWidth, barcodeHeight, backgroundColor, barcodeColor, barcodeData, bitmap_buffer, bitmap_buffer_bytesize, bitmap_width, bitmap_height)) {
                            int width = bitmap_width.getValue();
                            int height = bitmap_height.getValue();
                            int[] pixels = bitmap_buffer;
                            bitmap = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
                            bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
                        }
                    }
                }
            } catch (Throwable tr) {
                tr.printStackTrace();
            }
            return bitmap;
        }
    }

}
