/*
 * Decompiled with CFR 0.152.
 */
package com.lvrenyang.nzio;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.LocationManager;
import android.os.Build;
import android.util.Log;
import com.lvrenyang.nzio.NZNative;
import java.util.List;

public class NZBtDeviceEnumerator {
    private static final String TAG = "NZBtDeviceEnumerator";
    private long function_ptr = 0L;
    private long private_data = 0L;
    private BroadcastReceiver broadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.bluetooth.device.action.FOUND".equals(action)) {
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (device != null) {
                    int device_type;
                    String device_name = device.getName();
                    String device_address = device.getAddress();
                    if (Build.VERSION.SDK_INT >= 18 && (device_type = device.getType()) != 1 && device_type != 3) {
                        Log.i((String)NZBtDeviceEnumerator.TAG, (String)("onBtScan Ignored " + device_type + " " + device_name + " " + device_address));
                        return;
                    }
                    Log.i((String)NZBtDeviceEnumerator.TAG, (String)("onBtScan " + device_name + " " + device_address));
                    if (NZBtDeviceEnumerator.this.function_ptr != 0L) {
                        NZNative.OnBluetoothDeviceScan(NZBtDeviceEnumerator.this.function_ptr, NZBtDeviceEnumerator.this.private_data, "" + device_name, "" + device_address);
                    }
                }
            } else if ("android.bluetooth.adapter.action.DISCOVERY_STARTED".equals(action)) {
                Log.i((String)NZBtDeviceEnumerator.TAG, (String)"BluetoothAdapter.ACTION_DISCOVERY_STARTED");
            } else if ("android.bluetooth.adapter.action.DISCOVERY_FINISHED".equals(action)) {
                Log.i((String)NZBtDeviceEnumerator.TAG, (String)"BluetoothAdapter.ACTION_DISCOVERY_FINISHED");
            }
        }
    };
    private IntentFilter intentFilter = new IntentFilter();

    public void initBroadcast(Context ctx) {
        if (!this.intentFilter.hasAction("android.bluetooth.device.action.FOUND")) {
            this.intentFilter.addAction("android.bluetooth.device.action.FOUND");
        }
        if (!this.intentFilter.hasAction("android.bluetooth.adapter.action.DISCOVERY_STARTED")) {
            this.intentFilter.addAction("android.bluetooth.adapter.action.DISCOVERY_STARTED");
        }
        if (!this.intentFilter.hasAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED")) {
            this.intentFilter.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
        }
        ctx.registerReceiver(this.broadcastReceiver, this.intentFilter);
        this.checkPermission(ctx);
    }

    public void uninitBroadcast(Context ctx) {
        ctx.unregisterReceiver(this.broadcastReceiver);
    }

    public boolean StartScan(long function_ptr, long private_data) {
        Log.i((String)TAG, (String)"StartScan");
        boolean started = false;
        this.function_ptr = function_ptr;
        this.private_data = private_data;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (null != adapter) {
            long beginTime;
            if (!adapter.isEnabled() && adapter.enable()) {
                beginTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - beginTime < 10000L && !adapter.isEnabled()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (adapter.isEnabled()) {
                if (adapter.isDiscovering()) {
                    Log.i((String)TAG, (String)"StartScan Find adapter.isDiscovering, Set adapter.cancelDiscovery.");
                    adapter.cancelDiscovery();
                    beginTime = System.currentTimeMillis();
                    while (System.currentTimeMillis() - beginTime < 2000L && adapter.isDiscovering() && adapter.isEnabled()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    Log.i((String)TAG, (String)"StartScan Set adapter.cancelDiscovery Finished");
                }
                Log.i((String)TAG, (String)"StartScan adapter.startDiscovery");
                started = adapter.startDiscovery();
                if (started) {
                    beginTime = System.currentTimeMillis();
                    while (System.currentTimeMillis() - beginTime < 2000L && !adapter.isDiscovering() && adapter.isEnabled()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        Log.i((String)TAG, (String)("StartScan " + (started ? "Success" : "Failed")));
        return started;
    }

    public boolean IsScanning() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (null != adapter) {
            return adapter.isDiscovering();
        }
        return false;
    }

    public void StopScan() {
        Log.i((String)TAG, (String)"StopScan");
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (null != adapter && adapter.isEnabled()) {
            adapter.cancelDiscovery();
            long beginTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - beginTime < 2000L && adapter.isDiscovering()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Log.i((String)TAG, (String)"StopScan Finished");
        }
    }

    private void checkPermission(Context ctx) {
        try {
            LocationManager locationManager = (LocationManager)ctx.getSystemService("location");
            List providers = locationManager.getProviders(true);
            if (providers.contains("gps")) {
                locationManager.getLastKnownLocation("gps");
            } else if (providers.contains("network")) {
                locationManager.getLastKnownLocation("network");
            }
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (Throwable tr) {
            tr.printStackTrace();
        }
    }
}

