/*
 * Decompiled with CFR 0.152.
 */
package com.lvrenyang.io;

import android.util.Log;
import com.lvrenyang.io.IO;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Locale;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class UDPPrinting
extends IO {
    private static final String TAG = "UDPPrinting";
    private DatagramSocket mmClientSocket = null;
    private String IPAddress;
    private int PortNumber;
    private AtomicBoolean isOpened = new AtomicBoolean(false);
    private Vector<Byte> rxBuffer = new Vector();
    private final ReentrantLock mOpenLocker = new ReentrantLock();
    private final ReentrantLock mCloseLocker = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Open(String IPAddress, int PortNumber) {
        try {
            this.mOpenLocker.lock();
            this.mmClientSocket = new DatagramSocket();
            this.mmClientSocket.setSoTimeout(5000);
            this.IPAddress = IPAddress;
            this.PortNumber = PortNumber;
            this.isOpened.set(true);
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        finally {
            this.mOpenLocker.unlock();
        }
        return this.isOpened.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Open(String local_address, int local_port, String dest_address, int dest_port) {
        try {
            this.mOpenLocker.lock();
            this.mmClientSocket = new DatagramSocket(dest_port, InetAddress.getByName(local_address));
            this.IPAddress = dest_address;
            this.PortNumber = dest_port;
            this.isOpened.set(true);
            if (this.isOpened.get()) {
                this.StartReadThread();
            }
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        finally {
            this.mOpenLocker.unlock();
        }
        return this.isOpened.get();
    }

    public boolean SetReuseAddress(boolean reuse) {
        try {
            this.mmClientSocket.setReuseAddress(reuse);
            return true;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
            return false;
        }
    }

    public boolean SetBroadcast(boolean broadcast) {
        try {
            this.mmClientSocket.setBroadcast(broadcast);
            return true;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
            return false;
        }
    }

    @Override
    public void BaseClose() {
        try {
            this.mmClientSocket.close();
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        this.isOpened.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int Write(byte[] buffer, int offset, int count) {
        if (!this.isOpened.get()) {
            return -1;
        }
        int nBytesWritten = 0;
        try {
            byte[] cmd = new byte[count];
            System.arraycopy(buffer, offset, cmd, 0, count);
            this.mmClientSocket.send(new DatagramPacket(cmd, cmd.length, InetAddress.getByName(this.IPAddress), this.PortNumber));
            nBytesWritten = count;
        }
        catch (Exception ex) {
            nBytesWritten = -1;
            Log.i((String)TAG, (String)ex.toString());
        }
        return nBytesWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int BaseRead(byte[] buffer, int offset, int count, int timeout) {
        if (!this.isOpened.get()) {
            return -1;
        }
        int nBytesReaded = 0;
        try {
            long time = System.currentTimeMillis();
            while (System.currentTimeMillis() - time < (long)timeout && nBytesReaded != count) {
                if (this.rxBuffer.size() > 0) {
                    buffer[offset + nBytesReaded] = this.rxBuffer.get(0);
                    this.rxBuffer.remove(0);
                    ++nBytesReaded;
                    continue;
                }
                byte[] data = new byte[1024];
                DatagramPacket recvPacket = new DatagramPacket(data, data.length);
                this.mmClientSocket.setSoTimeout(timeout);
                this.mmClientSocket.receive(recvPacket);
                int nReceived = recvPacket.getLength();
                if (nReceived <= 0) continue;
                String str = "Recv: ";
                for (int i = 0; i < nReceived; ++i) {
                    this.rxBuffer.add(data[i]);
                    str = str + String.format(Locale.CHINA, "%02X ", (long)data[i] & 0xFFL);
                }
                Log.i((String)TAG, (String)str);
            }
        }
        catch (Exception ex) {
            nBytesReaded = -1;
            Log.e((String)TAG, (String)ex.toString());
        }
        return nBytesReaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int RecvDirect(byte[] buffer, int offset, int count, int timeout) {
        if (!this.isOpened.get()) {
            return -1;
        }
        int nBytesReaded = 0;
        try {
            byte[] data = new byte[count];
            DatagramPacket recvPacket = new DatagramPacket(data, data.length);
            this.mmClientSocket.setSoTimeout(timeout);
            this.mmClientSocket.receive(recvPacket);
            nBytesReaded = recvPacket.getLength();
            if (nBytesReaded > 0) {
                System.arraycopy(data, 0, buffer, offset, nBytesReaded);
            }
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)ex.toString());
        }
        return nBytesReaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramPacket RecvPacketDirect(int max_count, int timeout) {
        if (!this.isOpened.get()) {
            return null;
        }
        byte[] data = new byte[max_count];
        DatagramPacket packet = new DatagramPacket(data, data.length);
        try {
            this.mmClientSocket.setSoTimeout(timeout);
            this.mmClientSocket.receive(packet);
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)ex.toString());
        }
        return packet;
    }

    @Override
    public boolean IsOpened() {
        return this.isOpened.get();
    }
}

