/*
 * Decompiled with CFR 0.152.
 */
package com.lvrenyang.io;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import com.lvrenyang.io.ByteUtils;
import com.lvrenyang.io.IO;
import com.lvrenyang.io.ImageProcessing;
import java.util.ArrayList;
import java.util.List;

public class Setting {
    private static final String TAG = "Setting";
    private IO IO = new IO();

    public void Set(IO io) {
        if (null != io) {
            this.IO = io;
        }
    }

    public IO GetIO() {
        return this.IO;
    }

    public byte[] WrapUSSICmd(byte[] src_cmd) {
        int src_cmd_length = src_cmd.length;
        int datalen = src_cmd_length + 1;
        int totallen = 5 + datalen;
        byte[] dst_cmd = new byte[totallen];
        dst_cmd[0] = 31;
        dst_cmd[1] = 40;
        dst_cmd[2] = 15;
        dst_cmd[3] = (byte)((long)datalen & 0xFFL);
        dst_cmd[4] = (byte)(((long)datalen & 0xFF00L) >> 8);
        System.arraycopy(src_cmd, 0, dst_cmd, 5, src_cmd_length);
        dst_cmd[totallen - 1] = 0;
        for (int i = 5; i < totallen - 1; ++i) {
            int n = totallen - 1;
            dst_cmd[n] = (byte)(dst_cmd[n] ^ dst_cmd[i]);
        }
        return dst_cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Setting_Ethernet_IPAddress(String ipAddress) {
        if (!this.IO.IsOpened()) {
            return false;
        }
        boolean result = false;
        try {
            byte[] ipbytes = this.IsIPValid(ipAddress);
            if (null == ipbytes) {
                throw new Exception("Invalid ip address: " + ipAddress);
            }
            byte[] cmd = new byte[]{31, 105, 0, 0, 0, 0};
            System.arraycopy(ipbytes, 0, cmd, 2, 4);
            cmd = this.WrapUSSICmd(cmd);
            int nBytesWritten = this.IO.Write(cmd, 0, cmd.length);
            result = nBytesWritten == cmd.length;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Setting_Ethernet_MACAddress(String macAddress) {
        if (!this.IO.IsOpened()) {
            return false;
        }
        boolean result = false;
        try {
            byte[] macbytes = this.IsMACValid(macAddress);
            if (null == macbytes) {
                throw new Exception("Invalid mac address: " + macAddress);
            }
            byte[] cmd = new byte[]{31, 109, 0, 0, 0, 0, 0, 0};
            System.arraycopy(macbytes, 0, cmd, 2, 6);
            cmd = this.WrapUSSICmd(cmd);
            int nBytesWritten = this.IO.Write(cmd, 0, cmd.length);
            result = nBytesWritten == cmd.length;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Setting_Ethernet_Speed(int index) {
        if (!this.IO.IsOpened()) {
            return false;
        }
        boolean result = false;
        try {
            byte[] cmdAutoNegotiation = new byte[]{31, 112, 0, 0, -124};
            byte[] cmd100MFullDuplex = new byte[]{31, 112, 1, 1, 1};
            byte[] cmd100MHalfDuplex = new byte[]{31, 112, 1, 1, 0};
            byte[] cmd10MFullDuplex = new byte[]{31, 112, 1, 0, 1};
            byte[] cmd10MHalfDuplex = new byte[]{31, 112, 1, 0, 0};
            byte[][] cmdSpeeds = new byte[][]{cmdAutoNegotiation, cmd100MFullDuplex, cmd100MHalfDuplex, cmd10MFullDuplex, cmd10MHalfDuplex};
            if (index < 0 || index > 4) {
                throw new Exception("Invalid Parameter index:" + index);
            }
            byte[] cmd = cmdSpeeds[index];
            int nBytesWritten = this.IO.Write(cmd = this.WrapUSSICmd(cmd), 0, cmd.length);
            result = nBytesWritten == cmd.length;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Setting_Basic_Common(int language, int combaudrate, int comparity, int fonttype, int density, int charsperline, boolean autoreprintlastreceipt, boolean beeper, boolean drawer, boolean cutter) {
        if (!this.IO.IsOpened()) {
            return false;
        }
        boolean result = false;
        try {
            byte[] cmd1 = new byte[]{31, 115, 2, 0, 0, 0, 0, 0, -1, 0, 0};
            cmd1[2] = (byte)combaudrate;
            cmd1[3] = (byte)(!cutter ? 1 : 0);
            cmd1[4] = (byte)(!beeper ? 1 : 0);
            cmd1[5] = (byte)(!drawer ? 1 : 0);
            cmd1[6] = (byte)charsperline;
            cmd1[7] = (byte)density;
            cmd1[8] = (byte)language;
            cmd1[9] = (byte)comparity;
            cmd1[10] = (byte)fonttype;
            byte[] cmd2 = new byte[]{31, 114, 0};
            cmd2[2] = (byte)(autoreprintlastreceipt ? 1 : 0);
            byte[] cmd = ByteUtils.byteArraysToBytes(new byte[][]{this.WrapUSSICmd(cmd1), this.WrapUSSICmd(cmd2)});
            int nBytesWritten = this.IO.Write(cmd, 0, cmd.length);
            result = nBytesWritten == cmd.length;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Setting_Wifi_SsidAndPassword(String ssid, String password) {
        if (!this.IO.IsOpened()) {
            return false;
        }
        boolean result = false;
        try {
            byte[] ssidBytes = ssid.getBytes();
            byte[] ssidHead = new byte[]{31, 119, (byte)ssidBytes.length};
            byte[] passwordBytes = password.getBytes();
            byte[] passwordHead = new byte[]{0, 0, 0};
            if (passwordBytes.length > 0) {
                passwordHead[0] = 3;
                passwordHead[1] = 1;
                passwordHead[2] = (byte)passwordBytes.length;
            }
            int len = ssidHead.length + ssidBytes.length + passwordHead.length + passwordBytes.length;
            byte[] cmd = new byte[len];
            int offset = 0;
            System.arraycopy(ssidHead, 0, cmd, offset, ssidHead.length);
            System.arraycopy(ssidBytes, 0, cmd, offset += ssidHead.length, ssidBytes.length);
            System.arraycopy(passwordHead, 0, cmd, offset += ssidBytes.length, passwordHead.length);
            System.arraycopy(passwordBytes, 0, cmd, offset += passwordHead.length, passwordBytes.length);
            offset += passwordBytes.length;
            cmd = this.WrapUSSICmd(cmd);
            int nBytesWritten = this.IO.Write(cmd, 0, cmd.length);
            result = nBytesWritten == cmd.length;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Setting_Wifi_IPAddress(String ipAddress) {
        if (!this.IO.IsOpened()) {
            return false;
        }
        boolean result = false;
        try {
            byte[] ipbytes = this.IsIPValid(ipAddress);
            if (null == ipbytes) {
                throw new Exception("Invalid ip address: " + ipAddress);
            }
            byte[] cmd = new byte[]{31, 87, 73, 0, 0, 0, 0};
            System.arraycopy(ipbytes, 0, cmd, 3, 4);
            cmd = this.WrapUSSICmd(cmd);
            int nBytesWritten = this.IO.Write(cmd, 0, cmd.length);
            result = nBytesWritten == cmd.length;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Setting_Bluetooth_NameAndPassword(String name, String password) {
        if (!this.IO.IsOpened()) {
            return false;
        }
        boolean result = false;
        try {
            byte[] cmdHead = new byte[]{31, 66};
            byte[] nameBytes = name.getBytes();
            byte[] passwordBytes = password.getBytes();
            int len = 2 + nameBytes.length + 1 + passwordBytes.length + 1;
            byte[] cmd = new byte[len];
            int offset = 0;
            System.arraycopy(cmdHead, 0, cmd, offset, cmdHead.length);
            System.arraycopy(nameBytes, 0, cmd, offset += cmdHead.length, nameBytes.length);
            System.arraycopy(passwordBytes, 0, cmd, offset += nameBytes.length + 1, passwordBytes.length);
            offset += passwordBytes.length + 1;
            cmd = this.WrapUSSICmd(cmd);
            int nBytesWritten = this.IO.Write(cmd, 0, cmd.length);
            result = nBytesWritten == cmd.length;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Setting_BlackMark_Enable() {
        if (!this.IO.IsOpened()) {
            return false;
        }
        boolean result = false;
        try {
            byte[] cmd = new byte[]{31, 27, 31, -128, 4, 5, 6, 68};
            int nBytesWritten = this.IO.Write(cmd, 0, cmd.length);
            result = nBytesWritten == cmd.length;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Setting_BlackMark_Disable() {
        if (!this.IO.IsOpened()) {
            return false;
        }
        boolean result = false;
        try {
            byte[] cmd = new byte[]{31, 27, 31, -128, 4, 5, 6, 102};
            int nBytesWritten = this.IO.Write(cmd, 0, cmd.length);
            result = nBytesWritten == cmd.length;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Setting_BlackMark_Set(int length, int width, int feedcut, int feedprint) {
        if (!this.IO.IsOpened()) {
            return false;
        }
        boolean result = false;
        try {
            byte[] cmdDistance = new byte[]{31, 27, 31, -127, 4, 5, 6, 9, 96};
            int n = length * 8;
            cmdDistance[8] = (byte)(n >> 8);
            cmdDistance[7] = (byte)n;
            byte[] cmdWidth = new byte[]{31, 27, 31, -126, 4, 5, 6, 0, 80};
            n = width * 8;
            cmdWidth[8] = (byte)(n >> 8);
            cmdWidth[7] = (byte)n;
            byte[] cmdFeedCut = new byte[]{29, 40, 70, 4, 0, 2, 0, 0, 0};
            n = feedcut * 8;
            cmdFeedCut[8] = (byte)(n >> 8);
            cmdFeedCut[7] = (byte)n;
            byte[] cmdFeedPrint = new byte[]{29, 40, 70, 4, 0, 1, 0, 0, 0};
            n = feedprint * 8;
            cmdFeedPrint[8] = (byte)(n >> 8);
            cmdFeedPrint[7] = (byte)n;
            byte[] cmd = ByteUtils.byteArraysToBytes(new byte[][]{cmdDistance, cmdWidth, cmdFeedCut, cmdFeedPrint});
            int nBytesWritten = this.IO.Write(cmd, 0, cmd.length);
            result = nBytesWritten == cmd.length;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Setting_Firmware_Update(byte[] firmware, OnProgressCallBack onProgress) {
        if (!this.IO.IsOpened()) {
            return false;
        }
        boolean result = false;
        try {
            long chksumlen = ((long)firmware[7] & 0xFFL) << 24 | ((long)firmware[6] & 0xFFL) << 16 | ((long)firmware[5] & 0xFFL) << 8 | (long)firmware[4] & 0xFFL;
            if (chksumlen != (long)firmware.length) {
                throw new Exception("File Check Length Error");
            }
            byte[] cmd = new byte[6 + firmware.length];
            cmd[0] = 31;
            cmd[1] = 117;
            cmd[2] = firmware[7];
            cmd[3] = firmware[6];
            cmd[4] = firmware[5];
            cmd[5] = firmware[4];
            System.arraycopy(firmware, 0, cmd, 6, firmware.length);
            int nBytesWritten = 0;
            onProgress.OnProgress(nBytesWritten, cmd.length);
            while (nBytesWritten < cmd.length) {
                int nPackageSize = Math.min(256, cmd.length - nBytesWritten);
                int nSended = this.IO.Write(cmd, nBytesWritten, nPackageSize);
                if (nSended < 0) {
                    throw new Exception("Write Failed");
                }
                onProgress.OnProgress(nBytesWritten += nSended, cmd.length);
                Thread.sleep(10L);
            }
            result = nBytesWritten == cmd.length;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Setting_Logo_Download(List<String> files, OnProgressCallBack onProgress) {
        if (!this.IO.IsOpened()) {
            return false;
        }
        boolean result = false;
        try {
            ArrayList<byte[]> datas = new ArrayList<byte[]>();
            byte[] head = new byte[]{28, 113, 0};
            datas.add(head);
            for (int i = 0; i < files.size(); ++i) {
                Bitmap mBitmap = BitmapFactory.decodeFile((String)files.get(i));
                int dstw = mBitmap.getWidth();
                int dsth = mBitmap.getHeight();
                int[] dst = new int[dstw * dsth];
                mBitmap.getPixels(dst, 0, dstw, 0, 0, dstw, dsth);
                byte[] gray = ImageProcessing.GrayImage(dst);
                boolean[] dithered = new boolean[dstw * dsth];
                ImageProcessing.format_K_threshold(dstw, dsth, gray, dithered);
                byte[] nv = ImageProcessing.Image1ToNVData(dstw, dsth, dithered);
                datas.add(nv);
                head[2] = (byte)(head[2] + 1);
            }
            byte[] cmd = ByteUtils.ByteArrayListToBytes(datas);
            int nBytesWritten = 0;
            onProgress.OnProgress(nBytesWritten, cmd.length);
            while (nBytesWritten < cmd.length) {
                int nPackageSize = Math.min(256, cmd.length - nBytesWritten);
                int nSended = this.IO.Write(cmd, nBytesWritten, nPackageSize);
                if (nSended < 0) {
                    throw new Exception("Write Failed");
                }
                onProgress.OnProgress(nBytesWritten += nSended, cmd.length);
                Thread.sleep(10L);
            }
            result = nBytesWritten == cmd.length;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Setting_Logo_Print() {
        if (!this.IO.IsOpened()) {
            return false;
        }
        boolean result = false;
        try {
            byte[] cmd = new byte[1020];
            int idx = 0;
            for (int i = 1; i <= 255; ++i) {
                cmd[idx++] = 28;
                cmd[idx++] = 112;
                cmd[idx++] = (byte)i;
                cmd[idx++] = 0;
            }
            int nBytesWritten = this.IO.Write(cmd, 0, cmd.length);
            result = nBytesWritten == cmd.length;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Setting_Hardware_Set(boolean bSetBluetooth, int nSetBluetoothValue, boolean bSetCutter, int nSetCutterValue, boolean bSetHeatDot, int nSetHeatDotValue, boolean bSetHeatOnTime, int nSetHeatOnTimeValue, boolean bSetHeatOffTime, int nSetHeatOffTimeValue, boolean bSetSensor, int nSetSensorValue, boolean bSetUsb, int nSetUsbValue, boolean bSetCutBeep, int nBeepCount, int nBeepOn, int nBeepOff, boolean bSetSpeed, int nSetSpeedValue) {
        if (!this.IO.IsOpened()) {
            return false;
        }
        boolean result = false;
        try {
            byte[] cmd = new byte[26];
            cmd[0] = 31;
            cmd[1] = 83;
            int maskbit = 0;
            boolean[] bmasklst = new boolean[]{bSetBluetooth, bSetCutter, bSetHeatDot, bSetHeatOnTime, bSetHeatOffTime, bSetSensor, bSetUsb, bSetCutBeep, bSetSpeed};
            for (int i = 0; i < bmasklst.length; ++i) {
                if (!bmasklst[i]) continue;
                maskbit |= 1 << i;
            }
            cmd[2] = (byte)((long)(maskbit >> 24) & 0xFFL);
            cmd[3] = (byte)((long)(maskbit >> 16) & 0xFFL);
            cmd[4] = (byte)((long)(maskbit >> 8) & 0xFFL);
            cmd[5] = (byte)((long)(maskbit >> 0) & 0xFFL);
            cmd[9] = 0;
            cmd[8] = 0;
            cmd[7] = 0;
            cmd[6] = 0;
            cmd[10] = (byte)(cmd.length - 12);
            cmd[11] = (byte)nSetBluetoothValue;
            cmd[12] = (byte)nSetCutterValue;
            cmd[13] = (byte)(nSetHeatDotValue / 8);
            cmd[14] = (byte)((long)(nSetHeatOnTimeValue >> 8) & 0xFFL);
            cmd[15] = (byte)((long)(nSetHeatOnTimeValue >> 0) & 0xFFL);
            cmd[16] = (byte)((long)(nSetHeatOffTimeValue >> 8) & 0xFFL);
            cmd[17] = (byte)((long)(nSetHeatOffTimeValue >> 0) & 0xFFL);
            cmd[18] = (byte)nSetSensorValue;
            cmd[19] = (byte)nSetUsbValue;
            long snd = (((long)nBeepCount & 0x7FL) * 2L << 24) + (((long)nBeepOn & 0xFFFL) << 12) + ((long)nBeepOff & 0xFFFL);
            cmd[20] = (byte)(snd >> 24 & 0xFFL);
            cmd[21] = (byte)(snd >> 16 & 0xFFL);
            cmd[22] = (byte)(snd >> 8 & 0xFFL);
            cmd[23] = (byte)(snd >> 0 & 0xFFL);
            cmd[24] = (byte)nSetSpeedValue;
            cmd[cmd.length - 1] = 0;
            for (int i = 11; i <= cmd.length - 2; ++i) {
                int n = cmd.length - 1;
                cmd[n] = (byte)(cmd[n] ^ cmd[i]);
            }
            int nBytesWritten = this.IO.Write(cmd, 0, cmd.length);
            result = nBytesWritten == cmd.length;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Setting_Mqtt_ServerIPPort(String szip, String szport) {
        if (!this.IO.IsOpened()) {
            return false;
        }
        boolean result = false;
        try {
            byte[] ipbytes = this.IsIPValid(szip);
            if (null == ipbytes) {
                throw new Exception("Invalid ip address: " + szip);
            }
            int port = Integer.parseInt(szport);
            byte[] cmd = new byte[]{31, 40, 84, 6, 0, 0, 0, 0, 0, (byte)((long)(port >> 8) & 0xFFL), (byte)((long)port & 0xFFL)};
            System.arraycopy(ipbytes, 0, cmd, 5, 4);
            int nBytesWritten = this.IO.Write(cmd, 0, cmd.length);
            result = nBytesWritten == cmd.length;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Setting_Mqtt_UserNamePassword(String user, String password) {
        if (!this.IO.IsOpened()) {
            return false;
        }
        boolean result = false;
        try {
            int data_len = user.length() + 1 + password.length();
            byte[] cmd = new byte[5 + data_len];
            int idx = 0;
            cmd[idx++] = 31;
            cmd[idx++] = 40;
            cmd[idx++] = 81;
            cmd[idx++] = (byte)((long)data_len & 0xFFL);
            cmd[idx++] = (byte)((long)(data_len >> 8) & 0xFFL);
            byte[] user_bytes = user.getBytes();
            System.arraycopy(user_bytes, 0, cmd, idx, user_bytes.length);
            byte[] password_bytes = password.getBytes();
            System.arraycopy(password_bytes, 0, cmd, idx += user_bytes.length + 1, password_bytes.length);
            ++idx;
            int nBytesWritten = this.IO.Write(cmd, 0, cmd.length);
            result = nBytesWritten == cmd.length;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        return result;
    }

    private byte[] IsIPValid(String ip) {
        byte[] ipbytes = new byte[4];
        int valid = 0;
        String ipstr = ip + ".";
        int s = 0;
        for (int e = 0; e < ipstr.length(); ++e) {
            if ('.' != ipstr.charAt(e)) continue;
            if (e - s > 3 || e - s <= 0) {
                return null;
            }
            int ipbyte = -1;
            try {
                ipbyte = Integer.parseInt(ipstr.substring(s, e));
                if (ipbyte < 0 || ipbyte > 255) {
                    return null;
                }
                ipbytes[valid] = (byte)ipbyte;
            }
            catch (NumberFormatException exce) {
                return null;
            }
            s = e + 1;
            ++valid;
        }
        if (valid == 4) {
            return ipbytes;
        }
        return null;
    }

    private byte[] IsMACValid(String mac) {
        byte[] macbytes = new byte[6];
        int valid = 0;
        String macstr = mac + ":";
        int s = 0;
        for (int e = 0; e < macstr.length(); ++e) {
            if (':' != macstr.charAt(e)) continue;
            if (e - s != 2) {
                return null;
            }
            int ipbyte = -1;
            try {
                ipbyte = Integer.parseInt(macstr.substring(s, e), 16);
                if (ipbyte < 0 || ipbyte > 255) {
                    return null;
                }
                macbytes[valid] = (byte)ipbyte;
            }
            catch (NumberFormatException exce) {
                return null;
            }
            s = e + 1;
            ++valid;
        }
        if (valid == 6) {
            return macbytes;
        }
        return null;
    }

    public static interface OnProgressCallBack {
        public void OnProgress(double var1, double var3);
    }
}

