/*
 * Decompiled with CFR 0.152.
 */
package com.lvrenyang.io;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import com.lvrenyang.io.IO;
import com.lvrenyang.io.IOCallBack;
import java.io.IOException;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

@TargetApi(value=12)
public class CP2102Printing
extends IO {
    private static final String TAG = "CP2102Printing";
    private UsbEndpoint mUsbEndpointOut = null;
    private UsbEndpoint mUsbEndpointIn = null;
    private UsbDeviceConnection mUsbDeviceConnection = null;
    private AtomicBoolean isOpened = new AtomicBoolean(false);
    private AtomicBoolean isReadyRW = new AtomicBoolean(false);
    private IOCallBack cb = null;
    private Vector<Byte> rxBuffer = new Vector();
    private AtomicLong nIdleTime = new AtomicLong(0L);
    private final ReentrantLock mOpenLocker = new ReentrantLock();
    private final ReentrantLock mCloseLocker = new ReentrantLock();
    private String name;
    private String address;
    private BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
            if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
                if (device == null) {
                    return;
                }
                if (!device.getDeviceName().equalsIgnoreCase(CP2102Printing.this.address)) {
                    return;
                }
                CP2102Printing.this.Close();
            }
        }
    };
    private IntentFilter filter = new IntentFilter();
    private Context context;
    public static final int DATABITS_5 = 5;
    public static final int DATABITS_6 = 6;
    public static final int DATABITS_7 = 7;
    public static final int DATABITS_8 = 8;
    public static final int FLOWCONTROL_NONE = 0;
    public static final int FLOWCONTROL_RTSCTS_IN = 1;
    public static final int FLOWCONTROL_RTSCTS_OUT = 2;
    public static final int FLOWCONTROL_XONXOFF_IN = 4;
    public static final int FLOWCONTROL_XONXOFF_OUT = 8;
    public static final int PARITY_NONE = 0;
    public static final int PARITY_ODD = 1;
    public static final int PARITY_EVEN = 2;
    public static final int PARITY_MARK = 3;
    public static final int PARITY_SPACE = 4;
    public static final int STOPBITS_1 = 1;
    public static final int STOPBITS_1_5 = 3;
    public static final int STOPBITS_2 = 2;
    private static final int DEFAULT_BAUD_RATE = 9600;
    private static final int USB_WRITE_TIMEOUT_MILLIS = 5000;
    private static final int REQTYPE_HOST_TO_DEVICE = 65;
    private static final int SILABSER_IFC_ENABLE_REQUEST_CODE = 0;
    private static final int SILABSER_SET_BAUDDIV_REQUEST_CODE = 1;
    private static final int SILABSER_SET_LINE_CTL_REQUEST_CODE = 3;
    private static final int SILABSER_SET_MHS_REQUEST_CODE = 7;
    private static final int SILABSER_SET_BAUDRATE = 30;
    private static final int CP210X_SET_FLOW = 19;
    private static final int CP210X_SET_CHARS = 25;
    private static final int UART_ENABLE = 1;
    private static final int UART_DISABLE = 0;
    private static final int BAUD_RATE_GEN_FREQ = 3686400;
    private static final int MCR_DTR = 1;
    private static final int MCR_RTS = 2;
    private static final int MCR_ALL = 3;
    private static final int CONTROL_WRITE_DTR = 256;
    private static final int CONTROL_WRITE_RTS = 512;

    private void RegisterReceiver() {
        if (!this.filter.hasAction("android.hardware.usb.action.USB_DEVICE_DETACHED")) {
            this.filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        }
        this.context.registerReceiver(this.receiver, this.filter);
        Log.i((String)TAG, (String)"RegisterReceiver");
    }

    private void UnregisterReceiver() {
        try {
            this.context.unregisterReceiver(this.receiver);
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        Log.i((String)TAG, (String)"UnregisterReceiver");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Open(UsbManager manager, UsbDevice device, int baudrate, Context mContext) {
        try {
            this.mOpenLocker.lock();
            if (this.isOpened.get()) {
                throw new Exception("Already open");
            }
            if (null == mContext) {
                throw new Exception("Null Pointer mContext");
            }
            this.context = mContext;
            if (null == device) {
                throw new Exception("Null Pointer device");
            }
            this.address = device.getDeviceName();
            this.name = "VID" + device.getVendorId() + "PID" + device.getProductId();
            this.isReadyRW.set(false);
            try {
                if (!manager.hasPermission(device)) {
                    throw new Exception("No Permission");
                }
                UsbInterface usbInterface = null;
                UsbEndpoint usbEndpointOut = null;
                UsbEndpoint usbEndpointIn = null;
                for (int k = 0; k < device.getInterfaceCount(); ++k) {
                    usbInterface = device.getInterface(k);
                    usbEndpointOut = null;
                    usbEndpointIn = null;
                    for (int j = 0; j < usbInterface.getEndpointCount(); ++j) {
                        UsbEndpoint endpoint = usbInterface.getEndpoint(j);
                        if (endpoint.getDirection() == 0 && endpoint.getType() == 2) {
                            usbEndpointOut = endpoint;
                        } else if (endpoint.getDirection() == 128 && endpoint.getType() == 2) {
                            usbEndpointIn = endpoint;
                        }
                        if (null != usbEndpointOut && null != usbEndpointIn) break;
                    }
                    if (null != usbEndpointOut && null != usbEndpointIn) break;
                }
                if (null == usbInterface || null == usbEndpointOut || null == usbEndpointIn) {
                    throw new Exception("No Endpoint");
                }
                UsbDeviceConnection usbDeviceConnection = manager.openDevice(device);
                if (null == usbDeviceConnection) {
                    throw new Exception("Open Device Failed");
                }
                if (!usbDeviceConnection.claimInterface(usbInterface, true)) {
                    usbDeviceConnection.close();
                    throw new Exception("ClaimInterface Failed");
                }
                this.mUsbEndpointOut = usbEndpointOut;
                this.mUsbEndpointIn = usbEndpointIn;
                this.mUsbDeviceConnection = usbDeviceConnection;
                this.setConfigSingle(0, 1);
                this.setConfigSingle(7, 771);
                this.setConfigSingle(1, 384);
                this.setParameters(8, 1, 0);
                this.setChars();
                this.setFlow();
                this.setBaudRate(baudrate);
                this.isReadyRW.set(true);
            }
            catch (Exception ex) {
                Log.i((String)TAG, (String)ex.toString());
            }
            if (this.isReadyRW.get()) {
                Log.v((String)TAG, (String)"Connected to CP2102 Device");
                this.rxBuffer.clear();
                this.RegisterReceiver();
            }
            this.isOpened.set(this.isReadyRW.get());
            if (this.isOpened.get()) {
                this.StartReadThread();
            }
            if (null != this.cb) {
                if (this.isOpened.get()) {
                    this.cb.OnOpen();
                } else {
                    this.cb.OnOpenFailed();
                }
            }
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        finally {
            this.mOpenLocker.unlock();
        }
        return this.isOpened.get();
    }

    @Override
    public void BaseClose() {
        this.mCloseLocker.lock();
        try {
            try {
                this.setConfigSingle(0, 0);
                if (null != this.mUsbDeviceConnection) {
                    this.mUsbDeviceConnection.close();
                }
            }
            catch (Exception ex) {
                Log.i((String)TAG, (String)ex.toString());
            }
            if (!this.isReadyRW.get()) {
                throw new Exception();
            }
            this.mUsbEndpointOut = null;
            this.mUsbEndpointIn = null;
            this.mUsbDeviceConnection = null;
            this.UnregisterReceiver();
            this.isReadyRW.set(false);
            if (!this.isOpened.get()) {
                throw new Exception();
            }
            this.isOpened.set(false);
            if (null != this.cb) {
                this.cb.OnClose();
            }
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        finally {
            this.mCloseLocker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int Write(byte[] buffer, int offset, int count) {
        int nBytesWritten;
        if (!this.isReadyRW.get()) {
            return -1;
        }
        try {
            int nSended;
            this.nIdleTime.set(0L);
            for (nBytesWritten = 0; nBytesWritten < count; nBytesWritten += nSended) {
                if (!this.isReadyRW.get()) {
                    throw new Exception("Not Ready For Read Write");
                }
                int nPackageSize = Math.min(this.mUsbEndpointOut.getMaxPacketSize(), count - nBytesWritten);
                byte[] data = new byte[nPackageSize];
                System.arraycopy(buffer, offset + nBytesWritten, data, 0, data.length);
                nSended = this.mUsbDeviceConnection.bulkTransfer(this.mUsbEndpointOut, data, data.length, Integer.MAX_VALUE);
                if (nSended >= 0) continue;
                throw new Exception("Write Failed");
            }
            this.nIdleTime.set(System.currentTimeMillis());
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)ex.toString());
            this.Close();
            nBytesWritten = -1;
        }
        return nBytesWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int BaseRead(byte[] buffer, int offset, int count, int timeout) {
        if (!this.isReadyRW.get()) {
            return -1;
        }
        int nBytesReaded = 0;
        try {
            this.nIdleTime.set(0L);
            long time = System.currentTimeMillis();
            while (System.currentTimeMillis() - time < (long)timeout) {
                if (!this.isReadyRW.get()) {
                    throw new Exception("Not Ready For Read Write");
                }
                if (nBytesReaded == count) break;
                if (this.rxBuffer.size() > 0) {
                    buffer[offset + nBytesReaded] = this.rxBuffer.get(0);
                    this.rxBuffer.remove(0);
                    ++nBytesReaded;
                    continue;
                }
                int nPackageSize = this.mUsbEndpointIn.getMaxPacketSize();
                byte[] receive = new byte[nPackageSize];
                int nReceived = this.mUsbDeviceConnection.bulkTransfer(this.mUsbEndpointIn, receive, receive.length, 100);
                if (nReceived <= 0) continue;
                for (int i = 0; i < nReceived; ++i) {
                    this.rxBuffer.add(receive[i]);
                }
            }
            this.nIdleTime.set(System.currentTimeMillis());
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)ex.toString());
            this.Close();
            nBytesReaded = -1;
        }
        return nBytesReaded;
    }

    @Override
    public boolean IsOpened() {
        return this.isOpened.get();
    }

    public void SetCallBack(IOCallBack callBack) {
        try {
            this.cb = callBack;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }

    private int setConfigSingle(int request, int value) {
        return this.mUsbDeviceConnection.controlTransfer(65, request, value, 0, null, 0, 5000);
    }

    private void setFlow() throws IOException {
        byte[] data = new byte[]{0, 0, 0, 0, 3, 0, 0, 0, -128, 0, 0, 0, -128, 0, 0, 0};
        int ret = this.mUsbDeviceConnection.controlTransfer(65, 19, 0, 0, data, 16, 5000);
        if (ret < 0) {
            throw new IOException("Error setting flow control.");
        }
    }

    private void setChars() throws IOException {
        byte[] data = new byte[]{26, 0, 0, 26, 17, 19};
        int ret = this.mUsbDeviceConnection.controlTransfer(65, 25, 0, 0, data, data.length, 5000);
        if (ret < 0) {
            throw new IOException("Error setting flow control.");
        }
    }

    private void setBaudRate(int baudRate) throws IOException {
        byte[] data = new byte[]{(byte)(baudRate & 0xFF), (byte)(baudRate >> 8 & 0xFF), (byte)(baudRate >> 16 & 0xFF), (byte)(baudRate >> 24 & 0xFF)};
        int ret = this.mUsbDeviceConnection.controlTransfer(65, 30, 0, 0, data, 4, 5000);
        if (ret < 0) {
            throw new IOException("Error setting baud rate.");
        }
    }

    private void setParameters(int dataBits, int stopBits, int parity) throws IOException {
        int configBits = 0;
        switch (dataBits) {
            case 5: {
                configBits |= 0x500;
                break;
            }
            case 6: {
                configBits |= 0x600;
                break;
            }
            case 7: {
                configBits |= 0x700;
                break;
            }
            case 8: {
                configBits |= 0x800;
                break;
            }
            default: {
                configBits |= 0x800;
            }
        }
        switch (parity) {
            case 1: {
                configBits |= 0x10;
                break;
            }
            case 2: {
                configBits |= 0x20;
            }
        }
        switch (stopBits) {
            case 1: {
                configBits |= 0;
                break;
            }
            case 2: {
                configBits |= 2;
            }
        }
        this.setConfigSingle(3, configBits);
    }
}

