/*
 * Decompiled with CFR 0.152.
 */
package com.lvrenyang.io;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.lvrenyang.io.IO;
import com.lvrenyang.io.IOCallBack;
import java.util.UUID;
import java.util.Vector;

@TargetApi(value=18)
public class BLEPrinting
extends IO {
    private static final String TAG = "BLEPrinting";
    private static final UUID service_uuid = UUID.fromString("e7810a71-73ae-499d-8c15-faa9aef0c3f2");
    private static final UUID read_characteristic_uuid = UUID.fromString("bef8d6c9-9c21-4c9e-b632-bd58c1009f9f");
    private static final UUID write_characteristic_uuid = UUID.fromString("bef8d6c9-9c21-4c9e-b632-bd58c1009f9f");
    BluetoothAdapter mAdapter = BluetoothAdapter.getDefaultAdapter();
    private BluetoothGatt mGatt = null;
    private BluetoothGattCharacteristic mReadCharacteristic = null;
    private BluetoothGattCharacteristic mWriteCharacteristic = null;
    private boolean isConnected = false;
    private boolean isOpening = false;
    private boolean isOpened = false;
    private IOCallBack cb = null;
    private Vector<Byte> rxBuffer = new Vector();
    private int mCharacteristicWriteResult;
    private final BluetoothGattCallback mGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            Log.i((String)BLEPrinting.TAG, (String)("onConnectionStateChange  status:" + status + " newState:" + newState));
            if (newState == 2) {
                BLEPrinting.this.isConnected = true;
                if (gatt.discoverServices()) {
                    Log.i((String)BLEPrinting.TAG, (String)"discoverServices started");
                } else {
                    Log.i((String)BLEPrinting.TAG, (String)"discoverServices failed");
                }
            } else if (newState == 0) {
                BLEPrinting.this.isConnected = false;
                BLEPrinting.this.isOpening = false;
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            Log.i((String)BLEPrinting.TAG, (String)("onServicesDiscovered  status:" + status));
            BluetoothGattService svc = gatt.getService(service_uuid);
            if (null != svc) {
                BluetoothGattCharacteristic writeCharacteristic = svc.getCharacteristic(write_characteristic_uuid);
                BluetoothGattCharacteristic readCharacteristic = svc.getCharacteristic(read_characteristic_uuid);
                if (writeCharacteristic != null) {
                    writeCharacteristic.setWriteType(2);
                }
                if (readCharacteristic != null) {
                    gatt.setCharacteristicNotification(readCharacteristic, true);
                }
                if (writeCharacteristic != null && readCharacteristic != null) {
                    BLEPrinting.this.mWriteCharacteristic = writeCharacteristic;
                    BLEPrinting.this.mReadCharacteristic = readCharacteristic;
                }
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (status != 0) {
                Log.i((String)BLEPrinting.TAG, (String)("onCharacteristicRead  status:" + status));
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (status != 0) {
                Log.i((String)BLEPrinting.TAG, (String)("onCharacteristicWrite  status:" + status));
            }
            if (status == 0) {
                BLEPrinting.this.mCharacteristicWriteResult = 1;
            } else {
                BLEPrinting.this.mCharacteristicWriteResult = -1;
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            byte[] buffer = characteristic.getValue();
            int bytesRead = buffer.length;
            for (int i = 0; i < bytesRead; ++i) {
                BLEPrinting.this.rxBuffer.add(buffer[i]);
            }
            String s = "Recv " + bytesRead + " Bytes: ";
            for (int i = 0; i < bytesRead; ++i) {
                s = s + String.format("%02X ", buffer[i]);
            }
            Log.i((String)BLEPrinting.TAG, (String)s);
        }

        public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            Log.i((String)BLEPrinting.TAG, (String)("onDescriptorRead  status:" + status));
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            Log.i((String)BLEPrinting.TAG, (String)("onDescriptorWrite  status:" + status));
        }

        public void onReliableWriteCompleted(BluetoothGatt gatt, int status) {
            Log.i((String)BLEPrinting.TAG, (String)("onReliableWriteCompleted  status:" + status));
        }

        public void onReadRemoteRssi(BluetoothGatt gatt, int rssi, int status) {
            Log.i((String)BLEPrinting.TAG, (String)("onReadRemoteRssi  rssi:" + rssi + " status:" + status));
        }
    };

    @SuppressLint(value={"NewApi"})
    private synchronized boolean BaseOpen(String address, Context mContext) {
        try {
            long beginTime;
            this.isOpening = true;
            BluetoothDevice device = this.mAdapter.getRemoteDevice(address);
            this.mGatt = Build.VERSION.SDK_INT >= 23 ? device.connectGatt(null, false, this.mGattCallback, 2) : device.connectGatt(null, false, this.mGattCallback);
            if (this.mGatt != null) {
                beginTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - beginTime < 10000L && this.mAdapter.isEnabled() && this.isOpening && (this.mWriteCharacteristic == null || this.mReadCharacteristic == null)) {
                    Thread.sleep(1L);
                }
            }
            if (this.mWriteCharacteristic != null && this.mReadCharacteristic != null) {
                beginTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - beginTime < 100L && this.mAdapter.isEnabled()) {
                    if (!this.isConnected) {
                        this.mWriteCharacteristic = null;
                        this.mReadCharacteristic = null;
                        break;
                    }
                    Thread.sleep(1L);
                }
            }
            if (this.mWriteCharacteristic == null || this.mReadCharacteristic == null) {
                this.mGatt.disconnect();
                beginTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - beginTime < 10000L && this.mAdapter.isEnabled() && this.isConnected) {
                    Thread.sleep(1L);
                }
                this.mGatt.close();
                this.mGatt = null;
                this.mReadCharacteristic = null;
                this.mWriteCharacteristic = null;
            } else {
                this.isOpened = true;
            }
        }
        catch (Throwable tr) {
            Log.e((String)TAG, (String)tr.toString());
        }
        return this.IsOpened();
    }

    public synchronized boolean Open(String address, Context mContext) {
        try {
            if (!this.mAdapter.isEnabled()) {
                throw new Exception("BluetoothAdapter not enabled");
            }
            this.mAdapter.cancelDiscovery();
            Log.i((String)TAG, (String)("Connecting to " + address));
            long beginTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - beginTime < 20000L && this.mAdapter.isEnabled() && !this.BaseOpen(address, mContext)) {
                Thread.sleep(1L);
            }
            if (this.IsOpened()) {
                this.StartReadThread();
            }
            if (null != this.cb) {
                if (this.IsOpened()) {
                    this.cb.OnOpen();
                } else {
                    this.cb.OnOpenFailed();
                }
            }
            if (this.IsOpened()) {
                Log.i((String)TAG, (String)("Connected  to " + address));
            } else {
                Log.i((String)TAG, (String)("Failed Connect to " + address));
            }
        }
        catch (Throwable tr) {
            Log.e((String)TAG, (String)tr.toString());
        }
        return this.IsOpened();
    }

    @Override
    protected synchronized void BaseClose() {
        this.isOpened = false;
        if (null != this.mGatt) {
            try {
                this.mGatt.disconnect();
                long beginTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - beginTime < 10000L && this.mAdapter.isEnabled() && this.isConnected) {
                }
                this.mGatt.close();
            }
            catch (Throwable tr) {
                Log.i((String)TAG, (String)tr.toString());
            }
            this.mGatt = null;
            this.mReadCharacteristic = null;
            this.mWriteCharacteristic = null;
            Log.i((String)TAG, (String)"Closed");
            if (null != this.cb) {
                this.cb.OnClose();
            }
        }
    }

    @Override
    public boolean IsOpened() {
        return this.isOpened;
    }

    private boolean IsConnected() {
        return this.isConnected;
    }

    private int WritePackWithResponse(byte[] pack, int timeout) {
        if (!this.IsOpened()) {
            return -1;
        }
        if (!this.IsConnected()) {
            return -1;
        }
        if (this.mGatt == null) {
            return -1;
        }
        if (this.mWriteCharacteristic == null) {
            return -1;
        }
        int nBytesWritten = 0;
        try {
            this.mCharacteristicWriteResult = 0;
            if (!this.mWriteCharacteristic.setValue(pack)) {
                throw new Exception("mWriteCharacteristic.setValue Failed");
            }
            if (!this.mGatt.writeCharacteristic(this.mWriteCharacteristic)) {
                throw new Exception("mGatt.writeCharacteristic Failed");
            }
            long beginTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - beginTime < (long)timeout) {
                if (!this.IsConnected()) {
                    throw new Exception("Not Connected");
                }
                if (!this.IsOpened()) {
                    throw new Exception("Not Opened");
                }
                if (this.mCharacteristicWriteResult == 0) {
                    Thread.sleep(1L);
                    continue;
                }
                break;
            }
        }
        catch (Throwable tr) {
            Log.e((String)TAG, (String)tr.toString());
        }
        nBytesWritten = this.mCharacteristicWriteResult > 0 ? pack.length : 0;
        return nBytesWritten;
    }

    @Override
    public int Write(byte[] buffer, int offset, int count) {
        int nBytesWritten;
        if (!this.IsOpened()) {
            return -1;
        }
        if (!this.IsConnected()) {
            return -1;
        }
        try {
            int nSended;
            for (nBytesWritten = 0; nBytesWritten < count; nBytesWritten += nSended) {
                int nPacketSize = Math.min(20, count - nBytesWritten);
                byte[] data = new byte[nPacketSize];
                System.arraycopy(buffer, offset + nBytesWritten, data, 0, nPacketSize);
                nSended = this.WritePackWithResponse(data, 10000);
                if (nSended >= 0) continue;
                throw new Exception("Write Failed");
            }
        }
        catch (Throwable tr) {
            Log.e((String)TAG, (String)tr.toString());
            nBytesWritten = -1;
        }
        return nBytesWritten;
    }

    @Override
    protected int BaseRead(byte[] buffer, int offset, int count, int timeout) {
        int nBytesReaded;
        if (!this.IsOpened()) {
            return -1;
        }
        if (!this.IsConnected()) {
            return -1;
        }
        try {
            long beginTime = System.currentTimeMillis();
            for (nBytesReaded = 0; System.currentTimeMillis() - beginTime < (long)timeout && nBytesReaded != count && this.rxBuffer.size() > 0; ++nBytesReaded) {
                buffer[offset + nBytesReaded] = this.rxBuffer.get(0);
                this.rxBuffer.remove(0);
            }
        }
        catch (Throwable tr) {
            Log.e((String)TAG, (String)tr.toString());
        }
        return nBytesReaded;
    }

    public void SetCallBack(IOCallBack callBack) {
        try {
            this.cb = callBack;
        }
        catch (Throwable tr) {
            Log.e((String)TAG, (String)tr.toString());
        }
    }
}

