/*
 * Decompiled with CFR 0.152.
 */
package com.arcsoft.imageutil;

import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import com.arcsoft.imageutil.ArcSoftImageFormat;
import com.arcsoft.imageutil.ArcSoftMirrorOrient;
import com.arcsoft.imageutil.ArcSoftRotateDegree;

public final class ArcSoftImageUtil {
    private static final int WIDTH_MULTIPLE = 4;
    private static final int HEIGHT_MULTIPLE = 4;
    private static final int VALUE_FOR_4_ALIGN = 3;

    public static Bitmap getAlignedBitmap(Bitmap bitmap, boolean crop) {
        if (bitmap == null) {
            return null;
        }
        if (bitmap.getConfig() != Bitmap.Config.ARGB_8888 && bitmap.getConfig() != Bitmap.Config.RGB_565) {
            return null;
        }
        if ((bitmap.getWidth() & 3) == 0 && (bitmap.getHeight() & 3) == 0) {
            return bitmap;
        }
        int newWidth = crop ? bitmap.getWidth() & 0xFFFFFFFC : bitmap.getWidth() + (4 - (bitmap.getWidth() & 3)) % 4;
        int newHeight = crop ? bitmap.getHeight() & 0xFFFFFFFC : bitmap.getHeight() + (4 - (bitmap.getHeight() & 3)) % 4;
        Bitmap newBmp = Bitmap.createBitmap((int)newWidth, (int)newHeight, (Bitmap.Config)bitmap.getConfig());
        ArcSoftImageUtil.nativeAlignBitmap(bitmap, newBmp);
        return newBmp;
    }

    public static byte[] createImageData(int width, int height, ArcSoftImageFormat arcSoftImageFormat) {
        return new byte[ArcSoftImageUtil.getDataLengthBySizeAndFormat(width, height, arcSoftImageFormat)];
    }

    private static int getDataLengthBySizeAndFormat(int width, int height, ArcSoftImageFormat arcSoftImageFormat) {
        if (arcSoftImageFormat == null) {
            throw new NullPointerException("arcSoftImageFormat not specified");
        }
        if ((width & 3) != 0 || (height & 3) != 0) {
            throw new IllegalArgumentException("invalid width or height, width and height must be a multiple of 4");
        }
        switch (arcSoftImageFormat) {
            case NV21: 
            case NV12: 
            case I420: 
            case YV12: {
                return width * height * 3 / 2;
            }
            case BGR24: {
                return width * height * 3;
            }
            case YUYV: {
                return width * height * 2;
            }
            case GRAY: {
                return width * height;
            }
        }
        throw new IllegalArgumentException("invalid arcSoftImageFormat '" + (Object)((Object)arcSoftImageFormat) + "'");
    }

    private static native String nativeGetVersion();

    private static native int nativeImageFormatTransform(byte[] var0, byte[] var1, int var2, int var3, int var4, int var5);

    private static native int nativeBitmapToImageData(Bitmap var0, byte[] var1, int var2);

    private static native int nativeImageDataToBitmap(byte[] var0, Bitmap var1, int var2);

    private static native void nativeAlignBitmap(Bitmap var0, Bitmap var1);

    private static native int nativeCropImage(byte[] var0, byte[] var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    private static native int nativeRotateImage(byte[] var0, byte[] var1, int var2, int var3, int var4, int var5);

    private static native int nativeMirrorImage(byte[] var0, byte[] var1, int var2, int var3, boolean var4, int var5);

    public static int bitmapToImageData(Bitmap bitmap, byte[] data, ArcSoftImageFormat arcSoftImageFormat) {
        if (arcSoftImageFormat == null || data == null || bitmap == null) {
            return 4;
        }
        if (data.length != ArcSoftImageUtil.getDataLengthBySizeAndFormat(bitmap.getWidth(), bitmap.getHeight(), arcSoftImageFormat)) {
            return 1;
        }
        return ArcSoftImageUtil.nativeBitmapToImageData(bitmap, data, arcSoftImageFormat.format);
    }

    public static int imageDataToBitmap(byte[] data, Bitmap bitmap, ArcSoftImageFormat arcSoftImageFormat) {
        if (arcSoftImageFormat == null || data == null || bitmap == null) {
            return 4;
        }
        if (data.length != ArcSoftImageUtil.getDataLengthBySizeAndFormat(bitmap.getWidth(), bitmap.getHeight(), arcSoftImageFormat)) {
            return 1;
        }
        return ArcSoftImageUtil.nativeImageDataToBitmap(data, bitmap, arcSoftImageFormat.format);
    }

    public static int cropImage(byte[] originImageData, byte[] cropImageData, int originWidth, int originHeight, Rect rect, ArcSoftImageFormat arcSoftImageFormat) {
        if (rect == null || arcSoftImageFormat == null) {
            return 4;
        }
        return ArcSoftImageUtil.nativeCropImage(originImageData, cropImageData, originWidth, originHeight, rect.left, rect.top, rect.right, rect.bottom, arcSoftImageFormat.format);
    }

    public static int cropImage(byte[] originImageData, byte[] cropImageData, int originWidth, int originHeight, int left, int top, int right, int bottom, ArcSoftImageFormat arcSoftImageFormat) {
        if (arcSoftImageFormat == null) {
            return 4;
        }
        return ArcSoftImageUtil.nativeCropImage(originImageData, cropImageData, originWidth, originHeight, left, top, right, bottom, arcSoftImageFormat.format);
    }

    public static int cropImage(byte[] originImageData, byte[] cropImageData, int originWidth, int originHeight, Point leftTop, Point rightBottom, ArcSoftImageFormat arcSoftImageFormat) {
        if (arcSoftImageFormat == null) {
            return 4;
        }
        return ArcSoftImageUtil.nativeCropImage(originImageData, cropImageData, originWidth, originHeight, leftTop.x, leftTop.y, rightBottom.x, rightBottom.y, arcSoftImageFormat.format);
    }

    public static int rotateImage(byte[] originImageData, byte[] rotateImageData, int originWidth, int originHeight, ArcSoftRotateDegree degree, ArcSoftImageFormat arcSoftImageFormat) {
        if (originImageData == null || rotateImageData == null || arcSoftImageFormat == null || degree == null) {
            return 4;
        }
        return ArcSoftImageUtil.nativeRotateImage(originImageData, rotateImageData, originWidth, originHeight, degree.degree, arcSoftImageFormat.format);
    }

    public static int mirrorImage(byte[] originImageData, byte[] mirrorImageData, int width, int height, ArcSoftMirrorOrient arcSoftMirrorOrient, ArcSoftImageFormat arcSoftImageFormat) {
        if (arcSoftMirrorOrient == null || arcSoftImageFormat == null) {
            return 4;
        }
        return ArcSoftImageUtil.nativeMirrorImage(originImageData, mirrorImageData, width, height, arcSoftMirrorOrient.horizontal, arcSoftImageFormat.format);
    }

    public static int transformImage(byte[] originImageData, byte[] targetImageData, int width, int height, ArcSoftImageFormat originFormat, ArcSoftImageFormat targetFormat) {
        if (originFormat == null || targetFormat == null || originImageData == null || targetImageData == null) {
            return 4;
        }
        if (originFormat == targetFormat) {
            if (originImageData.length != targetImageData.length || originImageData.length != ArcSoftImageUtil.getDataLengthBySizeAndFormat(width, height, originFormat)) {
                return 1;
            }
            if (originImageData == targetImageData) {
                return 5;
            }
            System.arraycopy(originImageData, 0, targetImageData, 0, originImageData.length);
            return 0;
        }
        return ArcSoftImageUtil.nativeImageFormatTransform(originImageData, targetImageData, width, height, originFormat.format, targetFormat.format);
    }

    public static String getVersion() {
        return ArcSoftImageUtil.nativeGetVersion();
    }

    static {
        System.loadLibrary("arcsoft_image_util");
    }
}

