package com.caysn.autoreplyprint.caprint;

import java.util.Locale;

/**
 * 描述打印机可打印区域的宽度，每毫米打印点数。
 * 对于标签打印机来说，还可得到最大支持的标签页面高度。
 */
public class CAPrinterResolution {

    private int width_mm = 0;
    private int height_mm = 0;
    private int dots_per_mm = 0;

    public CAPrinterResolution(int width_mm, int height_mm, int dots_per_mm) {
        this.width_mm = width_mm;
        this.height_mm = height_mm;
        this.dots_per_mm = dots_per_mm;
    }

    public int getWidthMM() {
        return width_mm;
    }

    public int getHeightMM() {
        return height_mm;
    }

    public int getDotsPerMM() {
        return dots_per_mm;
    }

    @Override
    public String toString() {
        return String.format(Locale.CHINA, "width_mm:%d height_mm:%d dots_per_mm:%d", width_mm, height_mm, dots_per_mm);
    }

}
