package com.caysn.autoreplyprint.caprint;

import com.caysn.autoreplyprint.AutoReplyPrint;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

/**
 * 打印机搜索类，用于搜索打印机设备。
 * 目前能搜索到USB打印机，蓝牙2.0打印机，TCP网络打印机。
 */
public class CAPrinterDiscover {

    private static final String TAG = "PrinterDiscover";

    boolean inDiscover = false;
    boolean cancelDiscover = false;

    // 开始搜索打印机，搜到的打印机会通过回调接口告知。
    public void startDiscover() {
        if (inDiscover)
            return;
        inDiscover = true;
        cancelDiscover = false;
        new Thread(new Runnable() {
            @Override
            public void run() {
                onPrinterDiscoverThreadStarted();
                while (!cancelDiscover) {
                    try {
                        enumUsbPrinter();
                        enumComPrinter();
                        enumNetPrinter();
                        enumBtPrinter();
                        Thread.sleep(100);
                    } catch (Throwable tr) {
                        tr.printStackTrace();
                    }
                }
                inDiscover = false;
                onPrinterDiscoverThreadFinished();
            }
        }).start();
    }

    // 停止搜索打印机
    public void stopDiscover() {
        cancelDiscover = true;
        cancelNetEnum.setValue(1);
        cancelBtEnum.setValue(1);
    }

    // 是否正在搜索打印机
    public boolean isDiscovering() {
        return inDiscover;
    }

    private void enumUsbPrinter() {
        String[] paths = AutoReplyPrint.CP_Port_EnumUsb_Helper.EnumUsb();
        if (paths != null) {
            for (String path : paths) {
                onPrinterDiscovered(new CAPrinterDevice("UsbDevice", CAPrinterDevice.PrinterDevicePortTypeUsb, path));
            }
        }
    }

    private void enumComPrinter() {
        String[] paths = AutoReplyPrint.CP_Port_EnumCom_Helper.EnumCom();
        if (paths != null) {
            for (String path : paths) {
                onPrinterDiscovered(new CAPrinterDevice("ComDevice", CAPrinterDevice.PrinterDevicePortTypeCom, path));
            }
        }
    }

    private boolean inNetEnum = false;
    private IntByReference cancelNetEnum = new IntByReference(0);

    private void enumNetPrinter() {
        if (inNetEnum)
            return;
        inNetEnum = true;
        cancelNetEnum.setValue(0);
        new Thread(new Runnable() {
            @Override
            public void run() {
                AutoReplyPrint.CP_OnNetPrinterDiscovered_Callback callback = new AutoReplyPrint.CP_OnNetPrinterDiscovered_Callback() {
                    @Override
                    public void CP_OnNetPrinterDiscovered(String local_ip, String disconvered_mac, final String disconvered_ip, final String discovered_name, Pointer private_data) {
                        onPrinterDiscovered(new CAPrinterDevice("" + discovered_name, CAPrinterDevice.PrinterDevicePortTypeTcp, disconvered_ip));
                    }
                };
                AutoReplyPrint.INSTANCE.CP_Port_EnumNetPrinter(12000, cancelNetEnum, callback, null);
                inNetEnum = false;
            }
        }).start();
    }

    private boolean inBtEnum = false;
    private IntByReference cancelBtEnum = new IntByReference(0);

    private void enumBtPrinter() {
        if (inBtEnum)
            return;
        inBtEnum = true;
        cancelBtEnum.setValue(0);
        new Thread(new Runnable() {
            @Override
            public void run() {
                AutoReplyPrint.CP_OnBluetoothDeviceDiscovered_Callback callback = new AutoReplyPrint.CP_OnBluetoothDeviceDiscovered_Callback() {
                    @Override
                    public void CP_OnBluetoothDeviceDiscovered(final String device_name, final String device_address, Pointer private_data) {
                        onPrinterDiscovered(new CAPrinterDevice("" + device_name, CAPrinterDevice.PrinterDevicePortTypeBtSpp, device_address));
                    }
                };
                AutoReplyPrint.INSTANCE.CP_Port_EnumBtDevice(12000, cancelBtEnum, callback, null);
                inBtEnum = false;
            }
        }).start();
    }

    //***** 搜索到打印机回调
    public interface OnPrinterDiscoveredListener {
        void onPrinterDiscovered(CAPrinterDevice printerDevice);
    }

    private OnPrinterDiscoveredListener onPrinterDiscoveredListener = null;

    // 设置搜到打印机回调接口
    public void setOnPrinterDiscoveredListener(OnPrinterDiscoveredListener onPrinterDiscoveredListener) {
        this.onPrinterDiscoveredListener = onPrinterDiscoveredListener;
    }

    private void onPrinterDiscovered(CAPrinterDevice printerDevice) {
        if (onPrinterDiscoveredListener != null) {
            onPrinterDiscoveredListener.onPrinterDiscovered(printerDevice);
        }
    }

    //***** 搜索线程开始和结束回调
    public interface OnPrinterDiscoverThreadListener {
        void onPrinterDiscoverThreadStarted();

        void onPrinterDiscoverThreadFinished();
    }

    private OnPrinterDiscoverThreadListener onPrinterDiscoverThreadListener = null;

    // 设置搜索线程开始和结束回调
    public void setOnPrinterDiscoverThreadListener(OnPrinterDiscoverThreadListener onPrinterDiscoverThreadListener) {
        this.onPrinterDiscoverThreadListener = onPrinterDiscoverThreadListener;
    }

    private void onPrinterDiscoverThreadStarted() {
        if (onPrinterDiscoverThreadListener != null) {
            onPrinterDiscoverThreadListener.onPrinterDiscoverThreadStarted();
        }
    }

    private void onPrinterDiscoverThreadFinished() {
        if (onPrinterDiscoverThreadListener != null) {
            onPrinterDiscoverThreadListener.onPrinterDiscoverThreadFinished();
        }
    }

}
