package com.caysn.autoreplyprint.caprint;

import java.util.Locale;

/**
 * 用于描述打印结果，并记录相关打印数据信息。
 * 返回的结果包括，是否打印成功，蓝牙发包情况，数据发送总量，数据发送耗时，数据发送速率。
 */
public class CAPrintResult {
    // 打印结果，是成功还是失败
    public boolean printResult = false;

    // 打印的图片高度，是多少毫米
    public double sourceImageHeight = 0;

    // 设置的打印速度，是多少毫米每秒
    public int settedPrintSpeed = 0;

    // 本次打印发送的数据量，是多少个字节数
    public int writeDataSize = 0;

    // 本次打印发送数据耗时，毫秒时间
    // 由于安卓蓝牙SPP数据发送函数，返回时，并不代表数据已发送
    // 可能只是把数据填入了缓冲区，所以这里面的数据发送耗时，没有参考价值
    // 同理，数据发送速率也是没有参考价值的
    public double writeTimeUsed = 0;

    // 本次打印发送数据的速率，kb/s
    public double writeDataSpeed = 0;

    @Override
    public String toString() {
        String print_result_string = (printResult ? "Print Success\r\n" : "Print Failed\r\n");
        String image_height_string = String.format(Locale.CHINA, "Image Height: %.1f mm\r\n", sourceImageHeight);
        String data_size_string = String.format(Locale.CHINA, "Data Size: %.1f kb\r\n", writeDataSize / 1024.0);
        String setted_print_speed_string = String.format(Locale.CHINA, "Setted Print Speed: %d mm/s\r\n", settedPrintSpeed);
        String data_transfer_time_string = String.format(Locale.CHINA, "Data Transfer Time: %.1f seconds\r\n", writeTimeUsed / 1000.0);
        String data_transfer_speed_string = String.format(Locale.CHINA, "Data Transfer Speed: %.1f kb/s\r\n", writeDataSpeed);
        return print_result_string + image_height_string + data_size_string + setted_print_speed_string + data_transfer_time_string + data_transfer_speed_string;
    }

}
