/*
 * Decompiled with CFR 0.152.
 */
package com.lvrenyang.io;

import android.graphics.Bitmap;
import android.util.Log;
import com.lvrenyang.io.ESCCmd;
import com.lvrenyang.io.IO;
import com.lvrenyang.io.ImageProcessing;

public class Pos {
    private static final String TAG = "Pos";
    private IO IO = new IO();
    private ESCCmd Cmd = new ESCCmd();

    public void Set(IO io) {
        if (null != io) {
            this.IO = io;
        }
    }

    public IO GetIO() {
        return this.IO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void POS_PrintPicture(Bitmap mBitmap, int nWidth, int nBinaryAlgorithm, int nCompressMethod) {
        if (!this.IO.IsOpened()) {
            return;
        }
        try {
            int dstw = (nWidth + 7) / 8 * 8;
            int dsth = mBitmap.getHeight() * dstw / mBitmap.getWidth();
            int[] dst = new int[dstw * dsth];
            mBitmap = ImageProcessing.resizeImage(mBitmap, dstw, dsth);
            mBitmap.getPixels(dst, 0, dstw, 0, 0, dstw, dsth);
            byte[] gray = ImageProcessing.GrayImage(dst);
            boolean[] dithered = new boolean[dstw * dsth];
            if (nBinaryAlgorithm == 0) {
                ImageProcessing.format_K_dither16x16(dstw, dsth, gray, dithered);
            } else {
                ImageProcessing.format_K_threshold(dstw, dsth, gray, dithered);
            }
            byte[] data = null;
            data = nCompressMethod == 0 ? ImageProcessing.eachLinePixToCmd(dithered, dstw, 0) : ImageProcessing.eachLinePixToCompressCmd(dithered, dstw);
            this.IO.Write(data, 0, data.length);
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void POS_S_TextOut(String pszString, int nOrgx, int nWidthTimes, int nHeightTimes, int nFontType, int nFontStyle) {
        if (!this.IO.IsOpened()) {
            return;
        }
        try {
            if (nOrgx > 65535 || nOrgx < 0 || nWidthTimes > 7 || nWidthTimes < 0 || nHeightTimes > 7 || nHeightTimes < 0 || nFontType < 0 || nFontType > 4 || pszString.length() == 0) {
                throw new Exception("invalid args");
            }
            this.Cmd.ESC_dollors_nL_nH[2] = (byte)(nOrgx % 256);
            this.Cmd.ESC_dollors_nL_nH[3] = (byte)(nOrgx / 256);
            byte[] intToWidth = new byte[]{0, 16, 32, 48, 64, 80, 96, 112};
            byte[] intToHeight = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
            this.Cmd.GS_exclamationmark_n[2] = (byte)(intToWidth[nWidthTimes] + intToHeight[nHeightTimes]);
            byte[] tmp_ESC_M_n = this.Cmd.ESC_M_n;
            if (nFontType == 0 || nFontType == 1) {
                tmp_ESC_M_n[2] = (byte)nFontType;
            } else {
                tmp_ESC_M_n = new byte[]{};
            }
            this.Cmd.GS_E_n[2] = (byte)(nFontStyle >> 3 & 1);
            this.Cmd.ESC_line_n[2] = (byte)(nFontStyle >> 7 & 3);
            this.Cmd.FS_line_n[2] = (byte)(nFontStyle >> 7 & 3);
            this.Cmd.ESC_lbracket_n[2] = (byte)(nFontStyle >> 9 & 1);
            this.Cmd.GS_B_n[2] = (byte)(nFontStyle >> 10 & 1);
            this.Cmd.ESC_V_n[2] = (byte)(nFontStyle >> 12 & 1);
            this.Cmd.ESC_9_n[2] = 1;
            byte[] pbString = pszString.getBytes();
            byte[] data = this.byteArraysToBytes(new byte[][]{this.Cmd.ESC_dollors_nL_nH, this.Cmd.GS_exclamationmark_n, tmp_ESC_M_n, this.Cmd.GS_E_n, this.Cmd.ESC_line_n, this.Cmd.FS_line_n, this.Cmd.ESC_lbracket_n, this.Cmd.GS_B_n, this.Cmd.ESC_V_n, this.Cmd.FS_AND, this.Cmd.ESC_9_n, pbString});
            this.IO.Write(data, 0, data.length);
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void POS_TextOut(String pszString, int nLan, int nOrgx, int nWidthTimes, int nHeightTimes, int nFontType, int nFontStyle) {
        if (!this.IO.IsOpened()) {
            return;
        }
        try {
            if (nOrgx > 65535 || nOrgx < 0 || nWidthTimes > 7 || nWidthTimes < 0 || nHeightTimes > 7 || nHeightTimes < 0 || nFontType < 0 || nFontType > 4 || pszString.length() == 0) {
                throw new Exception("invalid args");
            }
            this.Cmd.ESC_dollors_nL_nH[2] = (byte)(nOrgx % 256);
            this.Cmd.ESC_dollors_nL_nH[3] = (byte)(nOrgx / 256);
            byte[] intToWidth = new byte[]{0, 16, 32, 48, 64, 80, 96, 112};
            byte[] intToHeight = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
            this.Cmd.GS_exclamationmark_n[2] = (byte)(intToWidth[nWidthTimes] + intToHeight[nHeightTimes]);
            byte[] tmp_ESC_M_n = this.Cmd.ESC_M_n;
            if (nFontType == 0 || nFontType == 1) {
                tmp_ESC_M_n[2] = (byte)nFontType;
            } else {
                tmp_ESC_M_n = new byte[]{};
            }
            this.Cmd.GS_E_n[2] = (byte)(nFontStyle >> 3 & 1);
            this.Cmd.ESC_line_n[2] = (byte)(nFontStyle >> 7 & 3);
            this.Cmd.FS_line_n[2] = (byte)(nFontStyle >> 7 & 3);
            this.Cmd.ESC_lbracket_n[2] = (byte)(nFontStyle >> 9 & 1);
            this.Cmd.GS_B_n[2] = (byte)(nFontStyle >> 10 & 1);
            this.Cmd.ESC_V_n[2] = (byte)(nFontStyle >> 12 & 1);
            byte[] pbString = null;
            if (nLan == 0) {
                this.Cmd.ESC_9_n[2] = 0;
                pbString = pszString.getBytes("GBK");
            } else if (nLan == 3) {
                this.Cmd.ESC_9_n[2] = 3;
                pbString = pszString.getBytes("Big5");
            } else if (nLan == 4) {
                this.Cmd.ESC_9_n[2] = 4;
                pbString = pszString.getBytes("Shift_JIS");
            } else if (nLan == 5) {
                this.Cmd.ESC_9_n[2] = 5;
                pbString = pszString.getBytes("EUC-KR");
            } else {
                this.Cmd.ESC_9_n[2] = 1;
                pbString = pszString.getBytes();
            }
            byte[] data = this.byteArraysToBytes(new byte[][]{this.Cmd.ESC_dollors_nL_nH, this.Cmd.GS_exclamationmark_n, tmp_ESC_M_n, this.Cmd.GS_E_n, this.Cmd.ESC_line_n, this.Cmd.FS_line_n, this.Cmd.ESC_lbracket_n, this.Cmd.GS_B_n, this.Cmd.ESC_V_n, this.Cmd.FS_AND, this.Cmd.ESC_9_n, pbString});
            this.IO.Write(data, 0, data.length);
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }

    public void POS_FeedLine() {
        if (!this.IO.IsOpened()) {
            return;
        }
        try {
            byte[] data = this.byteArraysToBytes(new byte[][]{this.Cmd.CR, this.Cmd.LF});
            this.IO.Write(data, 0, data.length);
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }

    public void POS_S_Align(int align) {
        if (!this.IO.IsOpened()) {
            return;
        }
        try {
            if (align < 0 || align > 2) {
                throw new Exception("invalid args");
            }
            byte[] data = this.Cmd.ESC_a_n;
            data[2] = (byte)align;
            this.IO.Write(data, 0, data.length);
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }

    public void POS_SetLineHeight(int nHeight) {
        if (!this.IO.IsOpened()) {
            return;
        }
        try {
            if (nHeight < 0 || nHeight > 255) {
                throw new Exception("invalid args");
            }
            byte[] data = this.Cmd.ESC_3_n;
            data[2] = (byte)nHeight;
            this.IO.Write(data, 0, data.length);
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void POS_S_SetBarcode(String strCodedata, int nOrgx, int nType, int nWidthX, int nHeight, int nHriFontType, int nHriFontPosition) {
        if (!this.IO.IsOpened()) {
            return;
        }
        try {
            if (nOrgx < 0 || nOrgx > 65535 || nType < 65 || nType > 73 || nHeight < 1 || nHeight > 255) {
                throw new Exception("invalid args");
            }
            byte[] bCodeData = strCodedata.getBytes();
            this.Cmd.ESC_dollors_nL_nH[2] = (byte)(nOrgx % 256);
            this.Cmd.ESC_dollors_nL_nH[3] = (byte)(nOrgx / 256);
            this.Cmd.GS_w_n[2] = (byte)nWidthX;
            this.Cmd.GS_h_n[2] = (byte)nHeight;
            this.Cmd.GS_f_n[2] = (byte)(nHriFontType & 1);
            this.Cmd.GS_H_n[2] = (byte)(nHriFontPosition & 3);
            this.Cmd.GS_k_m_n_[2] = (byte)nType;
            this.Cmd.GS_k_m_n_[3] = (byte)bCodeData.length;
            byte[] data = this.byteArraysToBytes(new byte[][]{this.Cmd.ESC_dollors_nL_nH, this.Cmd.GS_w_n, this.Cmd.GS_h_n, this.Cmd.GS_f_n, this.Cmd.GS_H_n, this.Cmd.GS_k_m_n_, bCodeData});
            this.IO.Write(data, 0, data.length);
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void POS_S_SetQRcode(String strCodedata, int nWidthX, int nVersion, int nErrorCorrectionLevel) {
        if (!this.IO.IsOpened()) {
            return;
        }
        try {
            if (nWidthX < 1 || nWidthX > 16 || nErrorCorrectionLevel < 1 || nErrorCorrectionLevel > 4 || nVersion < 0 || nVersion > 16) {
                throw new Exception("invalid args");
            }
            byte[] bCodeData = strCodedata.getBytes();
            this.Cmd.GS_w_n[2] = (byte)nWidthX;
            this.Cmd.GS_k_m_v_r_nL_nH[3] = (byte)nVersion;
            this.Cmd.GS_k_m_v_r_nL_nH[4] = (byte)nErrorCorrectionLevel;
            this.Cmd.GS_k_m_v_r_nL_nH[5] = (byte)(bCodeData.length & 0xFF);
            this.Cmd.GS_k_m_v_r_nL_nH[6] = (byte)((bCodeData.length & 0xFF00) >> 8);
            byte[] data = this.byteArraysToBytes(new byte[][]{this.Cmd.GS_w_n, this.Cmd.GS_k_m_v_r_nL_nH, bCodeData});
            this.IO.Write(data, 0, data.length);
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void POS_DoubleQRCode(String QR1Data, int QR1Position, int QR1Ecc, int QR1Version, String QR2Data, int QR2Position, int QR2Ecc, int QR2Version, int ModuleSize) {
        if (!this.IO.IsOpened()) {
            return;
        }
        try {
            byte[] head = new byte[]{31, 81, 2, (byte)ModuleSize};
            byte[] qr1code = QR1Data.getBytes();
            int QR1Datalen = qr1code.length;
            byte[] qr1info = new byte[]{(byte)((QR1Position & 0xFF00) >> 8), (byte)(QR1Position & 0xFF), (byte)((QR1Datalen & 0xFF00) >> 8), (byte)(QR1Datalen & 0xFF), (byte)QR1Ecc, (byte)QR1Version};
            byte[] qr2code = QR2Data.getBytes();
            int QR2Datalen = qr2code.length;
            byte[] qr2info = new byte[]{(byte)((QR2Position & 0xFF00) >> 8), (byte)(QR2Position & 0xFF), (byte)((QR2Datalen & 0xFF00) >> 8), (byte)(QR2Datalen & 0xFF), (byte)QR2Ecc, (byte)QR2Version};
            byte[] data = this.byteArraysToBytes(new byte[][]{head, qr1info, qr1code, qr2info, qr2code});
            this.IO.Write(data, 0, data.length);
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void POS_EPSON_SetQRCode(String strCodedata, int nWidthX, int nErrorCorrectionLevel) {
        if (!this.IO.IsOpened()) {
            return;
        }
        try {
            if (nWidthX < 1 || nWidthX > 16 || nErrorCorrectionLevel < 1 || nErrorCorrectionLevel > 4) {
                throw new Exception("invalid args");
            }
            byte[] bCodeData = strCodedata.getBytes();
            this.Cmd.GS_leftbracket_k_pL_pH_cn_67_n[7] = (byte)nWidthX;
            this.Cmd.GS_leftbracket_k_pL_pH_cn_69_n[7] = (byte)(47 + nErrorCorrectionLevel);
            this.Cmd.GS_leftbracket_k_pL_pH_cn_80_m__d1dk[3] = (byte)(bCodeData.length + 3 & 0xFF);
            this.Cmd.GS_leftbracket_k_pL_pH_cn_80_m__d1dk[4] = (byte)((bCodeData.length + 3 & 0xFF00) >> 8);
            byte[] data = this.byteArraysToBytes(new byte[][]{this.Cmd.GS_leftbracket_k_pL_pH_cn_67_n, this.Cmd.GS_leftbracket_k_pL_pH_cn_69_n, this.Cmd.GS_leftbracket_k_pL_pH_cn_80_m__d1dk, bCodeData, this.Cmd.GS_leftbracket_k_pL_pH_cn_fn_m});
            this.IO.Write(data, 0, data.length);
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }

    public void POS_Reset() {
        if (!this.IO.IsOpened()) {
            return;
        }
        try {
            byte[] data = this.Cmd.ESC_ALT;
            this.IO.Write(data, 0, data.length);
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void POS_SetMotionUnit(int nHorizontalMU, int nVerticalMU) {
        if (!this.IO.IsOpened()) {
            return;
        }
        try {
            if (nHorizontalMU < 0 || nHorizontalMU > 255 || nVerticalMU < 0 || nVerticalMU > 255) {
                throw new Exception("invalid args");
            }
            byte[] data = this.Cmd.GS_P_x_y;
            data[2] = (byte)nHorizontalMU;
            data[3] = (byte)nVerticalMU;
            this.IO.Write(data, 0, data.length);
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void POS_SetCharSetAndCodePage(int nCharSet, int nCodePage) {
        if (!this.IO.IsOpened()) {
            return;
        }
        try {
            if (nCharSet < 0 || nCharSet > 15 || nCodePage < 0 || nCodePage > 19 || nCodePage > 10 && nCodePage < 16) {
                throw new Exception("invalid args");
            }
            this.Cmd.ESC_R_n[2] = (byte)nCharSet;
            this.Cmd.ESC_t_n[2] = (byte)nCodePage;
            byte[] data = this.byteArraysToBytes(new byte[][]{this.Cmd.ESC_R_n, this.Cmd.ESC_t_n});
            this.IO.Write(data, 0, data.length);
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }

    public void POS_SetRightSpacing(int nDistance) {
        if (!this.IO.IsOpened()) {
            return;
        }
        try {
            if (nDistance < 0 || nDistance > 255) {
                throw new Exception("invalid args");
            }
            this.Cmd.ESC_SP_n[2] = (byte)nDistance;
            byte[] data = this.Cmd.ESC_SP_n;
            this.IO.Write(data, 0, data.length);
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void POS_S_SetAreaWidth(int nWidth) {
        if (!this.IO.IsOpened()) {
            return;
        }
        try {
            if (nWidth < 0 || nWidth > 65535) {
                throw new Exception("invalid args");
            }
            byte nL = (byte)(nWidth % 256);
            byte nH = (byte)(nWidth / 256);
            this.Cmd.GS_W_nL_nH[2] = nL;
            this.Cmd.GS_W_nL_nH[3] = nH;
            byte[] data = this.Cmd.GS_W_nL_nH;
            this.IO.Write(data, 0, data.length);
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }

    public void POS_CutPaper() {
        if (!this.IO.IsOpened()) {
            return;
        }
        try {
            byte[] data = new byte[]{29, 86, 66, 0};
            this.IO.Write(data, 0, data.length);
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void POS_Beep(int nBeepCount, int nBeepMillis) {
        if (!this.IO.IsOpened()) {
            return;
        }
        try {
            byte[] data = new byte[]{27, 66, (byte)nBeepCount, (byte)nBeepMillis};
            this.IO.Write(data, 0, data.length);
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void POS_KickDrawer(int nDrawerIndex, int nPulseTime) {
        if (!this.IO.IsOpened()) {
            return;
        }
        try {
            byte[] data = new byte[]{27, 112, (byte)nDrawerIndex, (byte)nPulseTime, (byte)nPulseTime};
            this.IO.Write(data, 0, data.length);
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }

    public void POS_SetPrintSpeed(int nSpeed) {
        if (!this.IO.IsOpened()) {
            return;
        }
        try {
            byte[] data = new byte[]{31, 40, 115, 2, 0, (byte)((long)nSpeed & 0xFFL), (byte)(((long)nSpeed & 0xFF00L) >> 8)};
            this.IO.Write(data, 0, data.length);
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean POS_QueryStatus(byte[] status, int timeout, int MaxRetry) {
        if (!this.IO.IsOpened()) {
            return false;
        }
        boolean result = false;
        try {
            byte[] cmd = new byte[]{29, 114, 1};
            while (MaxRetry-- >= 0) {
                this.IO.SkipAvailable();
                if (this.IO.Write(cmd, 0, cmd.length) != cmd.length || this.IO.Read(status, 0, 1, timeout) != 1) continue;
                result = true;
            }
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean POS_RTQueryStatus(byte[] status, int type, int timeout, int MaxRetry) {
        if (!this.IO.IsOpened()) {
            return false;
        }
        boolean result = false;
        try {
            byte[] cmd = new byte[]{16, 4, (byte)type};
            while (MaxRetry-- >= 0) {
                this.IO.SkipAvailable();
                if (this.IO.Write(cmd, 0, cmd.length) != cmd.length || this.IO.Read(status, 0, 1, timeout) != 1) continue;
                result = true;
            }
        }
        catch (Exception exception) {}
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean POS_TicketSucceed(int dwSendIndex, int timeout) {
        if (!this.IO.IsOpened()) {
            return false;
        }
        boolean result = false;
        try {
            Log.i((String)TAG, (String)String.format("Get Ticket %d Result", dwSendIndex));
            byte[] recbuf = new byte[7];
            byte[] data = new byte[]{29, 40, 72, 6, 0, 48, 48, (byte)dwSendIndex, (byte)(dwSendIndex >> 8), (byte)(dwSendIndex >> 16), (byte)(dwSendIndex >> 24)};
            byte[] head = new byte[]{16, 4, 1, 16, 4, 1, 16, 4, 1, 16, 4, 1};
            byte[] cmd = new byte[head.length + data.length];
            int offset = 0;
            System.arraycopy(head, 0, cmd, offset, head.length);
            System.arraycopy(data, 0, cmd, offset += head.length, data.length);
            offset += data.length;
            this.IO.SkipAvailable();
            if (this.IO.Write(cmd, 0, cmd.length) == cmd.length) {
                int nBytesReaded;
                long beginTime = System.currentTimeMillis();
                while (this.IO.IsOpened() && System.currentTimeMillis() - beginTime <= (long)timeout && (nBytesReaded = this.IO.Read(recbuf, 0, 1, timeout)) >= 0) {
                    if (nBytesReaded != 1) continue;
                    if (recbuf[0] == 55) {
                        int dwRecvIndex;
                        if (this.IO.Read(recbuf, 1, 1, timeout) != 1 || recbuf[1] != 34 && recbuf[1] != 51 || this.IO.Read(recbuf, 2, 5, timeout) != 5 || dwSendIndex != (dwRecvIndex = recbuf[2] & 0xFF | (recbuf[3] & 0xFF) << 8 | (recbuf[4] & 0xFF) << 16 | (recbuf[5] & 0xFF) << 24)) continue;
                        if (recbuf[1] == 34) {
                            result = true;
                        }
                        Log.i((String)TAG, (String)String.format("Ticket Result: %02X %02X %02X %02X %02X %02X %02X", recbuf[0], recbuf[1], recbuf[2], recbuf[3], recbuf[4], recbuf[5], recbuf[6]));
                        break;
                    }
                    if ((recbuf[0] & 0x12) != 18) continue;
                    Log.i((String)TAG, (String)String.format("Printer RT Status: %02X ", recbuf[0]));
                    if ((recbuf[0] & 8) == 0) continue;
                    break;
                }
            }
            Log.i((String)TAG, (String)String.format("Ticket %d %s", dwSendIndex, result ? "Succeed" : "Failed"));
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        return result;
    }

    private byte[] byteArraysToBytes(byte[][] data) {
        int length = 0;
        for (int i = 0; i < data.length; ++i) {
            length += data[i].length;
        }
        byte[] send = new byte[length];
        int k = 0;
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                send[k++] = data[i][j];
            }
        }
        return send;
    }
}

