/*
 * Decompiled with CFR 0.152.
 */
package com.lvrenyang.io;

import android.graphics.Bitmap;
import com.lvrenyang.io.IO;
import com.lvrenyang.io.ImageProcessing;

public class Label {
    public IO IO = new IO();

    public void Set(IO io) {
        if (null != io) {
            this.IO = io;
        }
    }

    public IO GetIO() {
        return this.IO;
    }

    public void PageBegin(int startx, int starty, int width, int height, int rotate) {
        byte[] data = new byte[]{26, 91, 1, (byte)(startx & 0xFF), (byte)(startx >> 8 & 0xFF), (byte)(starty & 0xFF), (byte)(starty >> 8 & 0xFF), (byte)(width & 0xFF), (byte)(width >> 8 & 0xFF), (byte)(height & 0xFF), (byte)(height >> 8 & 0xFF), (byte)(rotate & 0xFF)};
        this.IO.Write(data, 0, data.length);
    }

    public void PageEnd() {
        byte[] data = new byte[]{26, 93, 0};
        this.IO.Write(data, 0, data.length);
    }

    public void PagePrint(int num) {
        byte[] data = new byte[]{26, 79, 1, 1};
        data[3] = (byte)(num & 0xFF);
        this.IO.Write(data, 0, data.length);
    }

    public void PageFeed() {
        byte[] data = new byte[]{26, 12, 0};
        this.IO.Write(data, 0, data.length);
    }

    public void DrawPlainText(int startx, int starty, int font, int style, byte[] str) {
        int datalen = 11 + str.length + 1;
        byte[] data = new byte[datalen];
        data[0] = 26;
        data[1] = 84;
        data[2] = 1;
        data[3] = (byte)(startx & 0xFF);
        data[4] = (byte)(startx >> 8 & 0xFF);
        data[5] = (byte)(starty & 0xFF);
        data[6] = (byte)(starty >> 8 & 0xFF);
        data[7] = (byte)(font & 0xFF);
        data[8] = (byte)(font >> 8 & 0xFF);
        data[9] = (byte)(style & 0xFF);
        data[10] = (byte)(style >> 8 & 0xFF);
        System.arraycopy(str, 0, data, 11, str.length);
        data[datalen - 1] = 0;
        this.IO.Write(data, 0, data.length);
    }

    public void DrawLine(int startx, int starty, int endx, int endy, int width, int color) {
        byte[] data = new byte[]{26, 92, 1, (byte)(startx & 0xFF), (byte)(startx >> 8 & 0xFF), (byte)(starty & 0xFF), (byte)(starty >> 8 & 0xFF), (byte)(endx & 0xFF), (byte)(endx >> 8 & 0xFF), (byte)(endy & 0xFF), (byte)(endy >> 8 & 0xFF), (byte)(width & 0xFF), (byte)(width >> 8 & 0xFF), (byte)(color & 0xFF)};
        this.IO.Write(data, 0, data.length);
    }

    public void DrawBox(int left, int top, int right, int bottom, int borderwidth, int bordercolor) {
        byte[] data = new byte[]{26, 38, 1, (byte)(left & 0xFF), (byte)(left >> 8 & 0xFF), (byte)(top & 0xFF), (byte)(top >> 8 & 0xFF), (byte)(right & 0xFF), (byte)(right >> 8 & 0xFF), (byte)(bottom & 0xFF), (byte)(bottom >> 8 & 0xFF), (byte)(borderwidth & 0xFF), (byte)(borderwidth >> 8 & 0xFF), (byte)(bordercolor & 0xFF)};
        this.IO.Write(data, 0, data.length);
    }

    public void DrawRectangel(int left, int top, int right, int bottom, int color) {
        byte[] data = new byte[]{26, 42, 0, (byte)(left & 0xFF), (byte)(left >> 8 & 0xFF), (byte)(top & 0xFF), (byte)(top >> 8 & 0xFF), (byte)(right & 0xFF), (byte)(right >> 8 & 0xFF), (byte)(bottom & 0xFF), (byte)(bottom >> 8 & 0xFF), (byte)(color & 0xFF)};
        this.IO.Write(data, 0, data.length);
    }

    public void DrawBarcode(int startx, int starty, int type, int height, int unitwidth, int rotate, byte[] str) {
        int datalen = 11 + str.length + 1;
        byte[] data = new byte[datalen];
        data[0] = 26;
        data[1] = 48;
        data[2] = 0;
        data[3] = (byte)(startx & 0xFF);
        data[4] = (byte)(startx >> 8 & 0xFF);
        data[5] = (byte)(starty & 0xFF);
        data[6] = (byte)(starty >> 8 & 0xFF);
        data[7] = (byte)(type & 0xFF);
        data[8] = (byte)(height & 0xFF);
        data[9] = (byte)(unitwidth & 0xFF);
        data[10] = (byte)(rotate & 0xFF);
        System.arraycopy(str, 0, data, 11, str.length);
        data[datalen - 1] = 0;
        this.IO.Write(data, 0, data.length);
    }

    public void DrawQRCode(int startx, int starty, int version, int ecc, int unitwidth, int rotate, byte[] str) {
        int datalen = 11 + str.length + 1;
        byte[] data = new byte[datalen];
        data[0] = 26;
        data[1] = 49;
        data[2] = 0;
        data[3] = (byte)(version & 0xFF);
        data[4] = (byte)(ecc & 0xFF);
        data[5] = (byte)(startx & 0xFF);
        data[6] = (byte)(startx >> 8 & 0xFF);
        data[7] = (byte)(starty & 0xFF);
        data[8] = (byte)(starty >> 8 & 0xFF);
        data[9] = (byte)(unitwidth & 0xFF);
        data[10] = (byte)(rotate & 0xFF);
        System.arraycopy(str, 0, data, 11, str.length);
        data[datalen - 1] = 0;
        this.IO.Write(data, 0, data.length);
    }

    public void DrawPDF417(int startx, int starty, int colnum, int lwratio, int ecc, int unitwidth, int rotate, byte[] str) {
        int datalen = 12 + str.length + 1;
        byte[] data = new byte[datalen];
        data[0] = 26;
        data[1] = 49;
        data[2] = 1;
        data[3] = (byte)(colnum & 0xFF);
        data[4] = (byte)(ecc & 0xFF);
        data[5] = (byte)(lwratio & 0xFF);
        data[6] = (byte)(startx & 0xFF);
        data[7] = (byte)(startx >> 8 & 0xFF);
        data[8] = (byte)(starty & 0xFF);
        data[9] = (byte)(starty >> 8 & 0xFF);
        data[10] = (byte)(unitwidth & 0xFF);
        data[11] = (byte)(rotate & 0xFF);
        System.arraycopy(str, 0, data, 12, str.length);
        data[datalen - 1] = 0;
        this.IO.Write(data, 0, data.length);
    }

    public void DrawBitmap(int startx, int starty, int width, int height, int style, byte[] pdata) {
        int datalen = 13 + width * height / 8;
        byte[] data = new byte[datalen];
        data[0] = 26;
        data[1] = 33;
        data[2] = 1;
        data[3] = (byte)(startx & 0xFF);
        data[4] = (byte)(startx >> 8 & 0xFF);
        data[5] = (byte)(starty & 0xFF);
        data[6] = (byte)(starty >> 8 & 0xFF);
        data[7] = (byte)(width & 0xFF);
        data[8] = (byte)(width >> 8 & 0xFF);
        data[9] = (byte)(height & 0xFF);
        data[10] = (byte)(height >> 8 & 0xFF);
        data[11] = (byte)(style & 0xFF);
        data[12] = (byte)(style >> 8 & 0xFF);
        System.arraycopy(pdata, 0, data, 13, pdata.length);
        this.IO.Write(data, 0, data.length);
    }

    public void DrawBitmap(int startx, int starty, int dstWidth, int dstHeight, int style, Bitmap mBitmap, int nBinaryAlgorithm) {
        int dstw = (dstWidth + 7) / 8 * 8;
        int dsth = dstHeight;
        int[] dst = new int[dstw * dsth];
        mBitmap = ImageProcessing.resizeImage(mBitmap, dstw, dsth);
        mBitmap.getPixels(dst, 0, dstw, 0, 0, dstw, dsth);
        byte[] gray = ImageProcessing.GrayImage(dst);
        boolean[] dithered = new boolean[dstw * dsth];
        if (nBinaryAlgorithm == 0) {
            ImageProcessing.format_K_dither16x16(dstw, dsth, gray, dithered);
        } else {
            ImageProcessing.format_K_threshold(dstw, dsth, gray, dithered);
        }
        byte[] data = ImageProcessing.Image1ToRasterData(dstw, dsth, dithered);
        this.DrawBitmap(startx, starty, dstw, dsth, style, data);
    }
}

