/*
 * Decompiled with CFR 0.152.
 */
package com.lvrenyang.io;

import com.lvrenyang.io.IODataReceivedCallBack;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;

public class IO {
    private final ReentrantLock rxLocker = new ReentrantLock();
    private Vector<Byte> rxBuffer = new Vector();
    private boolean bExitReadThread = false;
    private IODataReceivedCallBack cb = null;

    public boolean IsOpened() {
        return false;
    }

    public int Write(byte[] buffer, int offset, int count) {
        return -1;
    }

    public final int Read(byte[] buffer, int offset, int count, int timeout) {
        int nBytesReaded = 0;
        long time = System.currentTimeMillis();
        while (System.currentTimeMillis() - time < (long)timeout && nBytesReaded != count) {
            if (!this.IsOpened()) {
                nBytesReaded = -1;
                break;
            }
            if (this.rxBuffer.size() > 0) {
                this.rxLocker.lock();
                buffer[offset + nBytesReaded] = this.rxBuffer.get(0);
                this.rxBuffer.remove(0);
                ++nBytesReaded;
                this.rxLocker.unlock();
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return nBytesReaded;
    }

    public final void SkipAvailable() {
        this.rxLocker.lock();
        this.rxBuffer.clear();
        this.rxLocker.unlock();
    }

    public final void Close() {
        this.StopReadThread();
        this.BaseClose();
    }

    protected void BaseClose() {
    }

    protected int BaseRead(byte[] buffer, int offset, int count, int timeout) {
        return -1;
    }

    protected final void StartReadThread() {
        this.bExitReadThread = false;
        new Thread(new Runnable(){

            @Override
            public void run() {
                byte[] buffer = new byte[64];
                while (IO.this.IsOpened() && !IO.this.bExitReadThread) {
                    int readed = IO.this.BaseRead(buffer, 0, buffer.length, 1000);
                    if (readed > 0) {
                        IO.this.rxLocker.lock();
                        for (int i = 0; i < readed; ++i) {
                            IO.this.rxBuffer.add(buffer[i]);
                        }
                        IO.this.rxLocker.unlock();
                        if (IO.this.cb == null) continue;
                        byte[] data = new byte[readed];
                        System.arraycopy(buffer, 0, data, 0, readed);
                        IO.this.cb.OnReceived(data);
                        continue;
                    }
                    if (readed == 0) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    IO.this.Close();
                    break;
                }
            }
        }).start();
    }

    private final void StopReadThread() {
        this.bExitReadThread = true;
    }

    public final void SetReceivedCallback(IODataReceivedCallBack callBack) {
        this.cb = callBack;
    }
}

