/*
 * Decompiled with CFR 0.152.
 */
package io.fotoapparat.facedetector.processor;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import io.fotoapparat.facedetector.FaceDetector;
import io.fotoapparat.facedetector.Rectangle;
import io.fotoapparat.preview.Frame;
import io.fotoapparat.preview.FrameProcessor;
import java.util.List;

public class FaceDetectorProcessor
implements FrameProcessor {
    private static Handler MAIN_THREAD_HANDLER = new Handler(Looper.getMainLooper());
    private final FaceDetector faceDetector;
    private final OnFacesDetectedListener listener;

    private FaceDetectorProcessor(Builder builder) {
        this.faceDetector = FaceDetector.create(builder.context);
        this.listener = builder.listener;
    }

    public static Builder with(Context context) {
        return new Builder(context);
    }

    public void process(Frame frame) {
        final List<Rectangle> faces = this.faceDetector.detectFaces(frame.getImage(), frame.getSize().width, frame.getSize().height, frame.getRotation());
        MAIN_THREAD_HANDLER.post(new Runnable(){

            @Override
            public void run() {
                FaceDetectorProcessor.this.listener.onFacesDetected(faces);
            }
        });
    }

    public static class Builder {
        private final Context context;
        private OnFacesDetectedListener listener = OnFacesDetectedListener.NULL;

        private Builder(Context context) {
            this.context = context;
        }

        public Builder listener(OnFacesDetectedListener listener) {
            this.listener = listener != null ? listener : OnFacesDetectedListener.NULL;
            return this;
        }

        public FaceDetectorProcessor build() {
            return new FaceDetectorProcessor(this);
        }
    }

    public static interface OnFacesDetectedListener {
        public static final OnFacesDetectedListener NULL = new OnFacesDetectedListener(){

            @Override
            public void onFacesDetected(List<Rectangle> faces) {
            }
        };

        public void onFacesDetected(List<Rectangle> var1);
    }
}

