package com.caysn.autoreplyprint.cmprint;

/**
 * 描述打印机实时状态。
 * 主要是缺纸，错误等状态。
 */
public class CMPrinterRTStatus {

    private long rt_status = 0;

    public CMPrinterRTStatus(long rt_status) {
        this.rt_status = rt_status;
    }

    public long rtStatus() {
        return rt_status;
    }

    public boolean DRAWER_OPENED() {
        return (((rt_status >> 0) & 0x04) == 0x00);
    }

    public boolean OFFLINE() {
        return (((rt_status >> 0) & 0x08) == 0x08);
    }

    public boolean COVERUP() {
        return (((rt_status >> 8) & 0x04) == 0x04);
    }

    public boolean FEED_PRESSED() {
        return (((rt_status >> 8) & 0x08) == 0x08);
    }

    public boolean NOPAPER() {
        return (((rt_status >> 8) & 0x20) == 0x20) || (((rt_status >> 24) & 0x60) == 0x60);
    }

    public boolean ERROR_OCCURED() {
        return (((rt_status >> 8) & 0x40) == 0x40);
    }

    public boolean CUTTER_ERROR() {
        return (((rt_status >> 16) & 0x08) == 0x08);
    }

    public boolean UNRECOVERABLE_ERROR() {
        return (((rt_status >> 16) & 0x20) == 0x20);
    }

    public boolean DEGREE_OR_VOLTAGE_OVERRANGE() {
        return (((rt_status >> 16) & 0x40) == 0x40);
    }

    public boolean PAPER_NEAREND() {
        return (((rt_status >> 24) & 0x08) == 0x08);
    }

    public boolean PAPER_TAKEOUT() {
        return (((rt_status >> 24) & 0x04) == 0x04);
    }

    @Override
    public String toString() {
        String rt_status_string = String.format("RTStatus: %02x %02x %02x %02x ", rt_status & 0xff, (rt_status >> 8) & 0xff, (rt_status >> 16) & 0xff, (rt_status >> 24) & 0xff);
        if (CUTTER_ERROR())
            rt_status_string += "[CUTTER_ERROR]";
        if (DEGREE_OR_VOLTAGE_OVERRANGE())
            rt_status_string += "[DEGREE_OR_VOLTAGE_OVERRANGE]";
        if (COVERUP())
            rt_status_string += "[COVERUP]";
        if (NOPAPER())
            rt_status_string += "[NOPAPER]";
        if (PAPER_NEAREND())
            rt_status_string += "[PAPER_NEAREND]";
        return rt_status_string;
    }

}
