/*
 * Decompiled with CFR 0.152.
 */
package com.rc.view.flowlayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.text.TextUtilsCompat;
import com.rc.view.flowlayout.R;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class FlowLayout
extends ViewGroup {
    private static final String TAG = "FlowLayout";
    private static final int LEFT = -1;
    private static final int CENTER = 0;
    private static final int RIGHT = 1;
    protected List<List<View>> mAllViews = new ArrayList<List<View>>();
    protected List<Integer> mLineHeight = new ArrayList<Integer>();
    protected List<Integer> mLineWidth = new ArrayList<Integer>();
    private int mGravity;
    private List<View> lineViews = new ArrayList<View>();

    public FlowLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.TagFlowLayout);
        this.mGravity = ta.getInt(R.styleable.TagFlowLayout_tag_gravity, -1);
        int layoutDirection = TextUtilsCompat.getLayoutDirectionFromLocale((Locale)Locale.getDefault());
        if (layoutDirection == 1) {
            this.mGravity = this.mGravity == -1 ? 1 : -1;
        }
        ta.recycle();
    }

    public FlowLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FlowLayout(Context context) {
        this(context, null);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int sizeWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int modeWidth = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int sizeHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int modeHeight = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int width = 0;
        int height = 0;
        int lineWidth = 0;
        int lineHeight = 0;
        int cCount = this.getChildCount();
        for (int i = 0; i < cCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) {
                if (i != cCount - 1) continue;
                width = Math.max(lineWidth, width);
                height += lineHeight;
                continue;
            }
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int childWidth = child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
            int childHeight = child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
            if (lineWidth + childWidth > sizeWidth - this.getPaddingLeft() - this.getPaddingRight()) {
                width = Math.max(width, lineWidth);
                lineWidth = childWidth;
                height += lineHeight;
                lineHeight = childHeight;
            } else {
                lineWidth += childWidth;
                lineHeight = Math.max(lineHeight, childHeight);
            }
            if (i != cCount - 1) continue;
            width = Math.max(lineWidth, width);
            height += lineHeight;
        }
        this.setMeasuredDimension(modeWidth == 0x40000000 ? sizeWidth : width + this.getPaddingLeft() + this.getPaddingRight(), modeHeight == 0x40000000 ? sizeHeight : height + this.getPaddingTop() + this.getPaddingBottom());
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mAllViews.clear();
        this.mLineHeight.clear();
        this.mLineWidth.clear();
        this.lineViews.clear();
        int width = this.getWidth();
        int lineWidth = 0;
        int lineHeight = 0;
        int cCount = this.getChildCount();
        for (int i = 0; i < cCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            if (childWidth + lineWidth + lp.leftMargin + lp.rightMargin > width - this.getPaddingLeft() - this.getPaddingRight()) {
                this.mLineHeight.add(lineHeight);
                this.mAllViews.add(this.lineViews);
                this.mLineWidth.add(lineWidth);
                lineWidth = 0;
                lineHeight = childHeight + lp.topMargin + lp.bottomMargin;
                this.lineViews = new ArrayList<View>();
            }
            lineWidth += childWidth + lp.leftMargin + lp.rightMargin;
            lineHeight = Math.max(lineHeight, childHeight + lp.topMargin + lp.bottomMargin);
            this.lineViews.add(child);
        }
        this.mLineHeight.add(lineHeight);
        this.mLineWidth.add(lineWidth);
        this.mAllViews.add(this.lineViews);
        int left = this.getPaddingLeft();
        int top = this.getPaddingTop();
        int lineNum = this.mAllViews.size();
        for (int i = 0; i < lineNum; ++i) {
            this.lineViews = this.mAllViews.get(i);
            lineHeight = this.mLineHeight.get(i);
            int currentLineWidth = this.mLineWidth.get(i);
            switch (this.mGravity) {
                case -1: {
                    left = this.getPaddingLeft();
                    break;
                }
                case 0: {
                    left = (width - currentLineWidth) / 2 + this.getPaddingLeft();
                    break;
                }
                case 1: {
                    left = width - (currentLineWidth + this.getPaddingLeft()) - this.getPaddingRight();
                    Collections.reverse(this.lineViews);
                }
            }
            for (int j = 0; j < this.lineViews.size(); ++j) {
                View child = this.lineViews.get(j);
                if (child.getVisibility() == 8) continue;
                ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
                int lc = left + lp.leftMargin;
                int tc = top + lp.topMargin;
                int rc = lc + child.getMeasuredWidth();
                int bc = tc + child.getMeasuredHeight();
                child.layout(lc, tc, rc, bc);
                left += child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
            }
            top += lineHeight;
        }
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-2, -2);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new ViewGroup.MarginLayoutParams(p);
    }
}

