/*
 * Decompiled with CFR 0.152.
 */
package io.fotoapparat.facedetector.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.fotoapparat.facedetector.R;
import io.fotoapparat.facedetector.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class RectanglesView
extends View {
    private final List<Rect> rectangles = new ArrayList<Rect>();
    private final Paint strokePaint = new Paint();

    public RectanglesView(Context context) {
        super(context);
    }

    public RectanglesView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.applyAttributes(context, attrs);
    }

    public RectanglesView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.applyAttributes(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyAttributes(Context context, AttributeSet attrs) {
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.RectanglesView);
        try {
            this.strokePaint.setStyle(Paint.Style.STROKE);
            this.strokePaint.setColor(attributes.getColor(R.styleable.RectanglesView_rectanglesColor, -16776961));
            this.strokePaint.setStrokeWidth((float)attributes.getDimensionPixelSize(R.styleable.RectanglesView_rectanglesStrokeWidth, 1));
        }
        finally {
            attributes.recycle();
        }
    }

    public void setRectangles(@NonNull List<Rectangle> rectangles) {
        this.ensureMainThread();
        this.rectangles.clear();
        for (Rectangle rectangle : rectangles) {
            int left = (int)(rectangle.getX() * (float)this.getWidth());
            int top = (int)(rectangle.getY() * (float)this.getHeight());
            int right = left + (int)(rectangle.getWidth() * (float)this.getWidth());
            int bottom = top + (int)(rectangle.getHeight() * (float)this.getHeight());
            this.rectangles.add(new Rect(left, top, right, bottom));
        }
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (Rect rectangle : this.rectangles) {
            canvas.drawRect(rectangle, this.strokePaint);
        }
    }

    private void ensureMainThread() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            throw new IllegalThreadStateException("This method must be called from the main thread");
        }
    }
}

