/*
 * Decompiled with CFR 0.152.
 */
package io.fotoapparat.facedetector.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.fotoapparat.view.CameraView;

public class CameraOverlayLayout
extends FrameLayout {
    public CameraOverlayLayout(@NonNull Context context) {
        super(context);
    }

    public CameraOverlayLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CameraOverlayLayout(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        CameraView cameraView = this.findCameraView();
        View textureView = this.findTextureView((View)cameraView);
        int childrenCount = this.getChildCount();
        for (int i = 0; i < childrenCount; ++i) {
            View view = this.getChildAt(i);
            if (view == cameraView) {
                view.layout(left, top, right, bottom);
                continue;
            }
            view.layout(textureView.getLeft(), textureView.getTop(), textureView.getRight(), textureView.getBottom());
        }
    }

    private CameraView findCameraView() {
        int childrenCount = this.getChildCount();
        for (int i = 0; i < childrenCount; ++i) {
            View view = this.getChildAt(i);
            if (!(view instanceof CameraView)) continue;
            return (CameraView)view;
        }
        throw new IllegalStateException("Can't find CameraView");
    }

    private View findTextureView(View view) {
        View queryView = view;
        while (queryView instanceof ViewGroup) {
            if (!((queryView = ((ViewGroup)queryView).getChildAt(0)) instanceof TextureView)) continue;
            return queryView;
        }
        throw new IllegalStateException("Can't find TextureView");
    }
}

