package com.caysn.autoreplyprint;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;

public interface NZUDPBroadcast extends Library {

    // static interface method need jdk1.8. here we use inner class to avoid this porblem.
    class GetLibraryPath_Helper {
        // can replaced by absolute path
        public static String GetLibraryPath() {
            // force call JNI_OnLoad
            if (Platform.isAndroid())
                System.loadLibrary("autoreplyprint");
            return "autoreplyprint";
        }
    }

    public static final NZUDPBroadcast INSTANCE = (NZUDPBroadcast) Native.loadLibrary(NZUDPBroadcast.GetLibraryPath_Helper.GetLibraryPath(), NZUDPBroadcast.class);

    // 通过UDP广播包设置打印机IP，这个过程一般10秒内就完成了，不用考虑取消
    public boolean CP_UDPBroadcast_ConfigIP(
            String local_ip, short local_port, String dest_ip, short dest_port,
            String mac, int dhcp, String ip, String netmask, String gateway,
            int interval_timeout, int total_timeout);

    // 通过UDP广播包设置打印机网络名称，这个过程一般10秒内就完成了，不用考虑取消
    public boolean CP_UDPBroadcast_ConfigName(
            String local_ip, short local_port, String dest_ip, short dest_port,
            String mac, String name,
            int interval_timeout, int total_timeout);

    // 通过UDP广播包确认之前的配置参数，这个过程一般10秒内就完成了，不用考虑取消
    public boolean CP_UDPBroadcast_ConfirmConfiguration(
            String local_ip, short local_port, String dest_ip, short dest_port,
            String mac,
            int interval_timeout, int total_timeout);

}
