package com.caysn.autoreplyprint;

import android.graphics.Bitmap;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.ptr.IntByReference;

public interface NZImage extends Library {

    // static interface method need jdk1.8. here we use inner class to avoid this porblem.
    class GetLibraryPath_Helper {
        // can replaced by absolute path
        public static String GetLibraryPath() {
            // force call JNI_OnLoad
            if (Platform.isAndroid())
                System.loadLibrary("autoreplyprint");
            return "autoreplyprint";
        }
    }

    public static final NZImage INSTANCE = (NZImage) Native.loadLibrary(NZImage.GetLibraryPath_Helper.GetLibraryPath(), NZImage.class);

    public int CP_Image_GetCompressToJBIGDataLength(int[] img_data, int img_datalen_inbytes, int img_width, int img_height, int img_stride, int img_format, int binaryzation_method);

    public int CP_Image_GetCompressToJBIGDataBytes(int[] img_data, int img_datalen_inbytes, int img_width, int img_height, int img_stride, int img_format, int binaryzation_method, byte[] jbig_data, int jbig_datalen);

    public boolean CP_Image_DecodeImageSizeFromJBIGData(byte[] jbig_data, int jbig_datalen, IntByReference p_width, IntByReference p_height);

    public boolean CP_Image_DecodeRGBAImageFromJBIGData(byte[] jbig_data, int jbig_datalen, int color0, int color1, int[] p_img_data, IntByReference p_width, IntByReference p_height);

    public class NZImageHelper {
        public static byte[] CompressBitmapToJBIGData(Bitmap bitmap, int binaryzation_method) {
            byte[] result_data = null;
            try {
                if (bitmap.getConfig() == Bitmap.Config.ARGB_8888) {
                    int w = bitmap.getWidth();
                    int h = bitmap.getHeight();
                    int stride = w * 4;
                    int pixelCount = w * h;
                    int byteCount = stride * h;
                    int[] pixels = new int[pixelCount];
                    bitmap.getPixels(pixels, 0, w, 0, 0, w, h);
                    // 上面的到的Color用int表示是0xAARRGGBB
                    // 安卓始终是小端模式，所以上面得到的pixels按字节顺序来排，是 BB GG RR AA
                    int img_format = AutoReplyPrint.CP_ImagePixelsFormat_BYTEORDERED_BGRA32;
                    int jbig_datalen = NZImage.INSTANCE.CP_Image_GetCompressToJBIGDataLength(pixels, byteCount, w, h, stride, img_format, binaryzation_method);
                    if (jbig_datalen > 0) {
                        byte[] jbig_data = new byte[jbig_datalen];
                        if (NZImage.INSTANCE.CP_Image_GetCompressToJBIGDataBytes(pixels, byteCount, w, h, stride, img_format, binaryzation_method, jbig_data, jbig_datalen) == jbig_datalen) {
                            result_data = jbig_data;
                        }
                    }
                }
            } catch (Throwable tr) {
                tr.printStackTrace();
            }
            return result_data;
        }

        public static Bitmap DecodeBitmapFromJBIGData(byte[] jbig_data, int color0, int color1) {
            Bitmap bitmap = null;
            try {
                IntByReference bitmap_width = new IntByReference();
                IntByReference bitmap_height = new IntByReference();
                if (NZImage.INSTANCE.CP_Image_DecodeImageSizeFromJBIGData(jbig_data, jbig_data.length, bitmap_width, bitmap_height)) {
                    int[] bitmap_buffer = new int[bitmap_width.getValue() * bitmap_height.getValue()];
                    if (NZImage.INSTANCE.CP_Image_DecodeRGBAImageFromJBIGData(jbig_data, jbig_data.length, color0, color1, bitmap_buffer, bitmap_width, bitmap_height)) {
                        int width = bitmap_width.getValue();
                        int height = bitmap_height.getValue();
                        int[] pixels = bitmap_buffer;
                        bitmap = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
                        bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
                    }
                }
            } catch (Throwable tr) {
                tr.printStackTrace();
            }
            return bitmap;
        }
    }

}
