package com.caysn.autoreplyprint.cmprint;

import java.util.List;

/**
 * 描述搜索到的端口信息
 * <p>
 * com就搜到一个地址
 * usb就搜到一个名称和地址
 * net能搜到名称，ip，mac
 * 蓝牙能搜到名称和地址
 * <p>
 * 端口名称，端口地址，都是做参考用的
 */
public class CMPrinterDiscoveredPortInfo {

    public static final String CMPrinterDiscoveredPortTypeCom = "com";
    public static final String CMPrinterDiscoveredPortTypeUsb = "usb";
    public static final String CMPrinterDiscoveredPortTypeNet = "net";
    public static final String CMPrinterDiscoveredPortTypeBtSpp = "bt-spp";
    public static final String CMPrinterDiscoveredPortTypeBtBle = "bt-ble";

    public String port_name;
    public String port_address;
    public String port_type;

    public static class CMPrinterDiscoveredComPortInfo extends CMPrinterDiscoveredPortInfo {
        public String com_name;

        public CMPrinterDiscoveredComPortInfo(String com_name) {
            this.port_name = "COM";
            this.port_address = com_name;
            this.port_type = CMPrinterDiscoveredPortTypeCom;
            this.com_name = com_name;
        }
    }

    public static class CMPrinterDiscoveredUsbPortInfo extends CMPrinterDiscoveredPortInfo {
        public String usb_path;

        public CMPrinterDiscoveredUsbPortInfo(String usb_path) {
            this.port_name = "USB";
            this.port_address = usb_path;
            this.port_type = CMPrinterDiscoveredPortTypeUsb;
            this.usb_path = usb_path;
        }
    }

    public static class CMPrinterDiscoveredNetPortInfo extends CMPrinterDiscoveredPortInfo {
        public String local_ip;
        public String discovered_mac;
        public String discovered_ip;
        public String discovered_name;

        public CMPrinterDiscoveredNetPortInfo(String local_ip, String discovered_mac, String discovered_ip, String discovered_name) {
            this.port_name = discovered_name;
            this.port_address = discovered_ip;
            this.port_type = CMPrinterDiscoveredPortTypeNet;
            this.local_ip = local_ip;
            this.discovered_mac = discovered_mac;
            this.discovered_ip = discovered_ip;
            this.discovered_name = discovered_name;
        }
    }

    public static class CMPrinterDiscoveredBtSppPortInfo extends CMPrinterDiscoveredPortInfo {
        public String bluetooth_name;
        public String bluetooth_address;

        public CMPrinterDiscoveredBtSppPortInfo(String bluetooth_name, String bluetooth_address) {
            this.port_name = bluetooth_name;
            this.port_address = bluetooth_address;
            this.port_type = CMPrinterDiscoveredPortTypeBtSpp;
            this.bluetooth_name = bluetooth_name;
            this.bluetooth_address = bluetooth_address;
        }
    }

    public static class CMPrinterDiscoveredBtBlePortInfo extends CMPrinterDiscoveredPortInfo {
        public String bluetooth_name;
        public String bluetooth_address;

        public CMPrinterDiscoveredBtBlePortInfo(String bluetooth_name, String bluetooth_address) {
            this.port_name = bluetooth_name;
            this.port_address = bluetooth_address;
            this.port_type = CMPrinterDiscoveredPortTypeBtBle;
            this.bluetooth_name = bluetooth_name;
            this.bluetooth_address = bluetooth_address;
        }
    }

    // 判断搜到的两个端口，是不是同一个端口
    // 如果两个端口都不为空，且端口类型相同，继续往下判断，否则认为不是同一个端口
    // 串口仅判断串口名称是否一致
    // USB仅判断路径是否一致
    // 网口仅判断目标mac,ip,name是否一致，注意网口搜到的打印机，先搜到的具有最高优先级（因为速度最快）
    // 蓝牙仅判断蓝牙地址是否一致，注意蓝牙搜到的打印机，有可能名字为空
    // 后续搜到新的蓝牙打印机，要判断之前的名称是否为空，来决定是否使用最新搜到的端口显示
    public static boolean isSamePort(CMPrinterDiscoveredPortInfo p1, CMPrinterDiscoveredPortInfo p2) {
        if ((p1 != null) && (p2 != null) && (p1.port_type.compareTo(p2.port_type) == 0)) {
            if (p1.port_type.compareTo(CMPrinterDiscoveredPortTypeCom) == 0) {
                CMPrinterDiscoveredComPortInfo pi1 = (CMPrinterDiscoveredComPortInfo) p1;
                CMPrinterDiscoveredComPortInfo pi2 = (CMPrinterDiscoveredComPortInfo) p2;
                if (pi1.com_name.compareTo(pi2.com_name) == 0)
                    return true;
            } else if (p1.port_type.compareTo(CMPrinterDiscoveredPortTypeUsb) == 0) {
                CMPrinterDiscoveredUsbPortInfo pi1 = (CMPrinterDiscoveredUsbPortInfo) p1;
                CMPrinterDiscoveredUsbPortInfo pi2 = (CMPrinterDiscoveredUsbPortInfo) p2;
                if (pi1.usb_path.compareTo(pi2.usb_path) == 0)
                    return true;
            } else if (p1.port_type.compareTo(CMPrinterDiscoveredPortTypeNet) == 0) {
                CMPrinterDiscoveredNetPortInfo pi1 = (CMPrinterDiscoveredNetPortInfo) p1;
                CMPrinterDiscoveredNetPortInfo pi2 = (CMPrinterDiscoveredNetPortInfo) p2;
                if ((pi1.discovered_mac.compareTo(pi2.discovered_mac) == 0) &&
                        (pi1.discovered_ip.compareTo(pi2.discovered_ip) == 0) &&
                        (pi1.discovered_name.compareTo(pi2.discovered_name) == 0))
                    return true;
            } else if (p1.port_type.compareTo(CMPrinterDiscoveredPortTypeBtSpp) == 0) {
                CMPrinterDiscoveredBtSppPortInfo pi1 = (CMPrinterDiscoveredBtSppPortInfo) p1;
                CMPrinterDiscoveredBtSppPortInfo pi2 = (CMPrinterDiscoveredBtSppPortInfo) p2;
                if (pi1.bluetooth_address.compareTo(pi2.bluetooth_address) == 0)
                    return true;
            } else if (p1.port_type.compareTo(CMPrinterDiscoveredPortTypeBtBle) == 0) {
                CMPrinterDiscoveredBtBlePortInfo pi1 = (CMPrinterDiscoveredBtBlePortInfo) p1;
                CMPrinterDiscoveredBtBlePortInfo pi2 = (CMPrinterDiscoveredBtBlePortInfo) p2;
                if (pi1.bluetooth_address.compareTo(pi2.bluetooth_address) == 0)
                    return true;
            }
        }
        return false;
    }

    // 根据端口信息，来查找对应端口在列表中是否存在，如果存在，返回索引。
    // 对于串口和usb来说，只要名称一致，就是认为是同样的端口
    // 对于网口来说，必须是搜到的name，ip，mac都一致，才认为是同样的端口，从哪个本地ip上发现的不重要
    // 对于蓝牙来说，只要是搜到的蓝牙地址一样，就认为是同样的端口
    public static int indexOfPort(List<CMPrinterDiscoveredPortInfo> portInfoList, CMPrinterDiscoveredPortInfo portInfo) {
        for (int i = 0; i < portInfoList.size(); ++i) {
            CMPrinterDiscoveredPortInfo pi = portInfoList.get(i);
            if (isSamePort(pi, portInfo))
                return i;
        }
        return -1;
    }

}
