package com.caysn.autoreplyprint.caprint;

import android.util.Log;

import com.caysn.autoreplyprint.AutoReplyPrint;

import java.util.List;

/**
 * 描述打印机设备。
 * 有打印机名称，端口类型，端口地址等属性。
 */
public class CAPrinterDevice {

    private static final String TAG = "CAPrinterDevice";

    public static final String PrinterDevicePortTypeCom = "com";
    public static final String PrinterDevicePortTypeUsb = "usb";
    public static final String PrinterDevicePortTypeTcp = "tcp";
    public static final String PrinterDevicePortTypeBtSpp = "btspp";
    public static final String PrinterDevicePortTypeBtBle = "btble";

    public String printer_name;
    public String port_type;
    public String port_address;

    public int comBaudrate = 115200;
    public int comDataBits = AutoReplyPrint.CP_ComDataBits_8;
    public int comParity = AutoReplyPrint.CP_ComParity_NoParity;
    public int comStopBits = AutoReplyPrint.CP_ComStopBits_One;
    public int comFlowControl = AutoReplyPrint.CP_ComFlowControl_None;
    public int tcpPortNumber = 9100;
    protected int autoreplymode = 1;

    public CAPrinterDevice(String printer_name, String port_type, String port_address) {
        this.printer_name = printer_name;
        this.port_type = port_type;
        this.port_address = port_address;
    }

    public static String toUidString(CAPrinterDevice printerDevice) {
        String uidString = "" + printerDevice.printer_name + "|" + printerDevice.port_type + "|" + printerDevice.port_address;
        if (PrinterDevicePortTypeTcp.compareTo(printerDevice.port_type) == 0) {
            uidString += ":" + printerDevice.tcpPortNumber;
        } else if (PrinterDevicePortTypeCom.compareTo(printerDevice.port_type) == 0) {
            uidString += ":" + printerDevice.comBaudrate + "," + printerDevice.comDataBits + "," + printerDevice.comParity + "," + printerDevice.comStopBits + "," + printerDevice.comFlowControl;
        }
        return uidString;
    }

    public static CAPrinterDevice fromUidString(String uidString) {
        try {
            if ((uidString != null) && (uidString.trim().length() > 0)) {
                String[] strs = uidString.split("\\|");
                if ((strs != null) && (strs.length == 3)) {
                    String printer_name = strs[0];
                    String port_type = strs[1];
                    String port_address = strs[2];
                    CAPrinterDevice printerDevice = new CAPrinterDevice(printer_name, port_type, port_address);
                    if (PrinterDevicePortTypeTcp.compareTo(port_type) == 0) {
                        if (port_address.contains(":")) {
                            strs = port_address.split(":");
                            if ((strs != null) && (strs.length == 2)) {
                                printerDevice.port_address = strs[0];
                                printerDevice.tcpPortNumber = Integer.parseInt(strs[1]);
                            }
                        }
                    } else if (PrinterDevicePortTypeCom.compareTo(port_type) == 0) {
                        if (port_address.contains(":")) {
                            strs = port_address.split(":");
                            if ((strs != null) && (strs.length == 2)) {
                                printerDevice.port_address = strs[0];
                                strs = strs[1].split(",");
                                if ((strs != null) && (strs.length == 5)) {
                                    printerDevice.comBaudrate = Integer.parseInt(strs[0]);
                                    printerDevice.comDataBits = Integer.parseInt(strs[1]);
                                    printerDevice.comParity = Integer.parseInt(strs[2]);
                                    printerDevice.comStopBits = Integer.parseInt(strs[3]);
                                    printerDevice.comFlowControl = Integer.parseInt(strs[4]);
                                }
                            }
                        }
                    }
                    return printerDevice;
                }
            }
        } catch (Throwable tr) {
            tr.printStackTrace();
        }
        return null;
    }

    public static boolean isPortEqual(CAPrinterDevice p1, CAPrinterDevice p2) {
        if ((p1 != null) && (p2 != null) &&
                (p1.port_type.compareTo(p2.port_type) == 0) && (p1.port_address.compareTo(p2.port_address) == 0) &&
                (p1.comBaudrate == p2.comBaudrate) && (p1.comDataBits == p2.comDataBits) && (p1.comParity == p2.comParity) && (p1.comStopBits == p2.comStopBits) && (p1.comFlowControl == p2.comFlowControl) &&
                (p1.tcpPortNumber == p2.tcpPortNumber) &&
                (p1.autoreplymode == p2.autoreplymode))
            return true;
        else if ((p1 == null) && (p2 == null))
            return true;
        else
            return false;
    }

    public static boolean isPrinterEqual(CAPrinterDevice p1, CAPrinterDevice p2) {
        if (isPortEqual(p1, p2)) {
            if ((p1.printer_name == null) && (p2.printer_name == null))
                return true;
            else if ((p1.printer_name != null) && (p1.printer_name.compareTo(p2.printer_name) == 0))
                return true;
            else
                return false;
        } else {
            return false;
        }
    }

    public static int indexOfPrinterByPort(List<CAPrinterDevice> printerList, String port_type, String port_address) {
        for (int i = 0; i < printerList.size(); ++i) {
            CAPrinterDevice pi = printerList.get(i);
            if ((pi.port_type.compareTo(port_type) == 0) && (pi.port_address.compareTo(port_address) == 0))
                return i;
        }
        return -1;
    }

    private static void test() {
        //测试串口
        {
            CAPrinterDevice printerDevice;
            String uidString;

            printerDevice = new CAPrinterDevice("ComDevice", PrinterDevicePortTypeCom, "/dev/ttyUSB0");
            uidString = toUidString(printerDevice);
            Log.i(TAG, uidString);

            printerDevice.comBaudrate = 9600;
            printerDevice.comFlowControl = AutoReplyPrint.CP_ComFlowControl_RtsCts;
            uidString = toUidString(printerDevice);
            Log.i(TAG, uidString);

            printerDevice = fromUidString(uidString);
            uidString = toUidString(printerDevice);
            Log.i(TAG, uidString);

            printerDevice = fromUidString("ComDevice|com|/dev/ttyUSB0");
            uidString = toUidString(printerDevice);
            Log.i(TAG, uidString);
        }
        //测试网口
        {
            CAPrinterDevice printerDevice;
            String uidString;

            printerDevice = new CAPrinterDevice("Prn112233", PrinterDevicePortTypeTcp, "192.168.1.87");
            uidString = toUidString(printerDevice);
            Log.i(TAG, uidString);

            printerDevice.tcpPortNumber = 9000;
            uidString = toUidString(printerDevice);
            Log.i(TAG, uidString);

            printerDevice = fromUidString(uidString);
            uidString = toUidString(printerDevice);
            Log.i(TAG, uidString);

            printerDevice = fromUidString("Prn112233|tcp|192.168.1.87");
            uidString = toUidString(printerDevice);
            Log.i(TAG, uidString);
        }
    }

}
