package com.caysn.autoreplyprint;

import android.graphics.Bitmap;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

public interface NZProto extends Library {

    // static interface method need jdk1.8. here we use inner class to avoid this porblem.
    class GetLibraryPath_Helper {
        // can replaced by absolute path
        public static String GetLibraryPath() {
            // force call JNI_OnLoad
            if (Platform.isAndroid())
                System.loadLibrary("autoreplyprint");
            return "autoreplyprint";
        }
    }

    public static final NZProto INSTANCE = (NZProto) Native.loadLibrary(NZProto.GetLibraryPath_Helper.GetLibraryPath(), NZProto.class);

    public Pointer CP_Proto_OpenUdp(String local_ip, short local_port, String dest_ip, short dest_port);

    public boolean CP_Proto_SetWorkEnabled(Pointer handle, int enabled);

    public boolean CP_Proto_SendPackageAndRecvResponseWithRetry(
            Pointer handle,
            byte sendhead, short cmd, int para, int sendlen, byte[] psendbuf,
            int sendtimeout, int recvtimeout,
            int recvlen, byte[] precvbuf, IntByReference preceivedlen,
            int maxretry);

}
