/*
 * Decompiled with CFR 0.152.
 */
package com.lvrenyang.nzio;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.wifi.WifiManager;
import android.net.wifi.p2p.WifiP2pConfig;
import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.WifiP2pDeviceList;
import android.net.wifi.p2p.WifiP2pGroup;
import android.net.wifi.p2p.WifiP2pInfo;
import android.net.wifi.p2p.WifiP2pManager;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@TargetApi(value=14)
public class NZWiFiP2PDeviceManager {
    private static final String TAG = "NZWiFiP2PDeviceManager";
    private static Handler mHandler = null;
    private static WifiP2pManager mWifiP2pManager = null;
    private static WifiP2pManager.Channel mChannel = null;
    private static WifiManager mWifiManager = null;
    private static Lock mInitLocker = new ReentrantLock();
    private static WifiP2pInfo mWifiP2pInfo = null;
    private static int mWifiP2pInfoUpdatedCount = 0;
    private static WifiP2pGroup mWifiP2pGroup = null;
    private static int mWifiP2pGroupUpdatedCount = 0;
    private static Collection<WifiP2pDevice> mWifiP2pDeviceList = null;
    private static int mWifiP2pDeviceListUpdatedCount = 0;
    private static int mDiscoverPeersActionCallbackCount = 0;
    private static boolean mDiscoverPeersActionCallbackResult = false;
    private static int mConnectActionCallbackCount = 0;
    private static boolean mConnectActionCallbackResult = false;
    private static int mCancelConnectActionCallbackCount = 0;
    private static boolean mCancelConnectActionCallbackResult = false;
    private static int mRemoveGroupActionCallbackCount = 0;
    private static boolean mRemoveGroupActionCallbackResult = false;
    private static WifiP2pManager.ChannelListener mChannelListener = new WifiP2pManager.ChannelListener(){

        public void onChannelDisconnected() {
            Log.i((String)NZWiFiP2PDeviceManager.TAG, (String)"onChannelDisconnected");
        }
    };
    private static WifiP2pManager.ConnectionInfoListener mConnectionInfoListener = new WifiP2pManager.ConnectionInfoListener(){

        public void onConnectionInfoAvailable(WifiP2pInfo info) {
            mWifiP2pInfo = info;
            mWifiP2pInfoUpdatedCount++;
        }
    };
    private static WifiP2pManager.GroupInfoListener mGroupInfoListener = new WifiP2pManager.GroupInfoListener(){

        public void onGroupInfoAvailable(WifiP2pGroup group) {
            mWifiP2pGroup = group;
            mWifiP2pGroupUpdatedCount++;
        }
    };
    private static WifiP2pManager.PeerListListener mPeerListListener = new WifiP2pManager.PeerListListener(){

        public void onPeersAvailable(WifiP2pDeviceList peers) {
            Collection mDeviceList = peers.getDeviceList();
            mWifiP2pDeviceList = mDeviceList;
            mWifiP2pDeviceListUpdatedCount++;
        }
    };
    private static WifiP2pManager.ActionListener mDiscoverPeersActionListener = new WifiP2pManager.ActionListener(){

        public void onSuccess() {
            mDiscoverPeersActionCallbackResult = true;
            mDiscoverPeersActionCallbackCount++;
            Log.i((String)NZWiFiP2PDeviceManager.TAG, (String)"Start Discover Peers");
        }

        public void onFailure(int reasonCode) {
            mDiscoverPeersActionCallbackResult = false;
            mDiscoverPeersActionCallbackCount++;
            Log.i((String)NZWiFiP2PDeviceManager.TAG, (String)("Failed To Start Discover Peers reasonCode:" + reasonCode));
        }
    };
    private static WifiP2pManager.ActionListener mConnectActionListener = new WifiP2pManager.ActionListener(){

        public void onSuccess() {
            mConnectActionCallbackResult = true;
            mConnectActionCallbackCount++;
            Log.i((String)NZWiFiP2PDeviceManager.TAG, (String)"Start Connect");
        }

        public void onFailure(int reasonCode) {
            mConnectActionCallbackResult = false;
            mConnectActionCallbackCount++;
            Log.i((String)NZWiFiP2PDeviceManager.TAG, (String)("Failed To Start Connect reasonCode:" + reasonCode));
        }
    };
    private static WifiP2pManager.ActionListener mCancelConnectActionListener = new WifiP2pManager.ActionListener(){

        public void onSuccess() {
            mCancelConnectActionCallbackResult = true;
            mCancelConnectActionCallbackCount++;
            Log.i((String)NZWiFiP2PDeviceManager.TAG, (String)"Start Cancel Connect");
        }

        public void onFailure(int reasonCode) {
            mCancelConnectActionCallbackResult = false;
            mCancelConnectActionCallbackCount++;
            Log.i((String)NZWiFiP2PDeviceManager.TAG, (String)("Failed To Start Cancel Connect reasonCode:" + reasonCode));
        }
    };
    private static WifiP2pManager.ActionListener mRemoveGroupActionListener = new WifiP2pManager.ActionListener(){

        public void onSuccess() {
            mRemoveGroupActionCallbackResult = true;
            mRemoveGroupActionCallbackCount++;
            Log.i((String)NZWiFiP2PDeviceManager.TAG, (String)"Start Disconnect");
        }

        public void onFailure(int reasonCode) {
            mRemoveGroupActionCallbackResult = false;
            mRemoveGroupActionCallbackCount++;
            Log.i((String)NZWiFiP2PDeviceManager.TAG, (String)("Failed To Start Disconnect reasonCode:" + reasonCode));
        }
    };

    private static boolean CreateHandler() {
        try {
            if (mHandler != null) {
                throw new Exception("handle alerady exist");
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Looper.prepare();
                    mHandler = new Handler();
                    Looper.loop();
                }
            }).start();
            long beginTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - beginTime < 10000L && mHandler == null) {
                Thread.sleep(1L);
            }
        }
        catch (Throwable tr) {
            tr.printStackTrace();
        }
        return NZWiFiP2PDeviceManager.IsHandlerValid();
    }

    private static void DestoryHandler() {
        if (mHandler != null) {
            try {
                mHandler.getLooper().quit();
            }
            catch (Throwable tr) {
                tr.printStackTrace();
            }
            mHandler = null;
        }
    }

    private static boolean IsHandlerValid() {
        return mHandler != null;
    }

    private static boolean CreateManager(Context ctx) {
        try {
            mWifiManager = (WifiManager)ctx.getApplicationContext().getSystemService("wifi");
            mWifiP2pManager = (WifiP2pManager)ctx.getApplicationContext().getSystemService("wifip2p");
            mChannel = mWifiP2pManager.initialize(ctx.getApplicationContext(), mHandler.getLooper(), mChannelListener);
            Log.i((String)TAG, (String)("Init Success. mWifiManager:" + mWifiManager + " mWifiP2pManager:" + mWifiP2pManager + " mChannel:" + mChannel));
        }
        catch (Throwable tr) {
            tr.printStackTrace();
        }
        return NZWiFiP2PDeviceManager.IsManagerValid();
    }

    private static void DestoryManager() {
        try {
            mWifiManager = null;
            mWifiP2pManager = null;
            mChannel = null;
        }
        catch (Throwable tr) {
            tr.printStackTrace();
        }
    }

    private static boolean IsManagerValid() {
        return mWifiManager != null && mWifiP2pManager != null && mChannel != null;
    }

    public static boolean InitHandlerAndManager(Context ctx) {
        mInitLocker.lock();
        if (!NZWiFiP2PDeviceManager.IsHandlerValid()) {
            NZWiFiP2PDeviceManager.CreateHandler();
        }
        if (!NZWiFiP2PDeviceManager.IsManagerValid()) {
            NZWiFiP2PDeviceManager.CreateManager(ctx);
        }
        mInitLocker.unlock();
        return NZWiFiP2PDeviceManager.IsHandlerValid() && NZWiFiP2PDeviceManager.IsManagerValid();
    }

    public static void UninitHandlerAndManager() {
        mInitLocker.lock();
        NZWiFiP2PDeviceManager.DestoryManager();
        NZWiFiP2PDeviceManager.DestoryHandler();
        mInitLocker.unlock();
    }

    private static boolean IsWiFiEnabled() {
        try {
            int wifiState = mWifiManager.getWifiState();
            if (wifiState == 3) {
                return true;
            }
        }
        catch (Throwable tr) {
            tr.printStackTrace();
        }
        return false;
    }

    private static boolean IsWiFiEnabling() {
        try {
            int wifiState = mWifiManager.getWifiState();
            if (wifiState == 2) {
                return true;
            }
        }
        catch (Throwable tr) {
            tr.printStackTrace();
        }
        return false;
    }

    private static boolean EnableWiFi() {
        try {
            if (!NZWiFiP2PDeviceManager.IsWiFiEnabled() && !NZWiFiP2PDeviceManager.IsWiFiEnabling() && mWifiManager.setWifiEnabled(true)) {
                long beginTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - beginTime < 20000L && (NZWiFiP2PDeviceManager.IsWiFiEnabled() || NZWiFiP2PDeviceManager.IsWiFiEnabling()) && !NZWiFiP2PDeviceManager.IsWiFiEnabled()) {
                    Thread.sleep(1L);
                }
            }
        }
        catch (Throwable tr) {
            tr.printStackTrace();
        }
        return NZWiFiP2PDeviceManager.IsWiFiEnabled();
    }

    private static WifiP2pInfo WifiP2pManager_RequestConnectionInfo() {
        WifiP2pInfo info;
        block6: {
            info = null;
            try {
                if (!NZWiFiP2PDeviceManager.IsHandlerValid() || !NZWiFiP2PDeviceManager.IsManagerValid() || !NZWiFiP2PDeviceManager.IsWiFiEnabled()) break block6;
                int lastUpdatedCount = mWifiP2pInfoUpdatedCount;
                mWifiP2pManager.requestConnectionInfo(mChannel, mConnectionInfoListener);
                long beginTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - beginTime < 10000L) {
                    if (mWifiP2pInfoUpdatedCount > lastUpdatedCount) {
                        info = mWifiP2pInfo;
                    } else if (NZWiFiP2PDeviceManager.IsHandlerValid() && NZWiFiP2PDeviceManager.IsManagerValid() && NZWiFiP2PDeviceManager.IsWiFiEnabled()) {
                        Thread.sleep(1L);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable tr) {
                tr.printStackTrace();
            }
        }
        return info;
    }

    private static boolean IsConnectionConnected() {
        boolean connected = false;
        try {
            WifiP2pInfo info = NZWiFiP2PDeviceManager.WifiP2pManager_RequestConnectionInfo();
            if (info != null && info.groupFormed && info.groupOwnerAddress != null) {
                connected = true;
            }
        }
        catch (Throwable tr) {
            tr.printStackTrace();
        }
        return connected;
    }

    private static boolean WaitConnectionConnected(int timeout) {
        boolean connected;
        block6: {
            connected = false;
            try {
                if (!NZWiFiP2PDeviceManager.IsHandlerValid() || !NZWiFiP2PDeviceManager.IsManagerValid() || !NZWiFiP2PDeviceManager.IsWiFiEnabled()) break block6;
                long beginTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - beginTime < (long)timeout) {
                    if (NZWiFiP2PDeviceManager.IsConnectionConnected()) {
                        connected = true;
                    } else if (NZWiFiP2PDeviceManager.IsHandlerValid() && NZWiFiP2PDeviceManager.IsManagerValid() && NZWiFiP2PDeviceManager.IsWiFiEnabled()) {
                        Thread.sleep(1L);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable tr) {
                tr.printStackTrace();
            }
        }
        return connected;
    }

    private static boolean WaitConnectionDisconnected(int timeout) {
        if (NZWiFiP2PDeviceManager.IsConnectionConnected()) {
            try {
                long beginTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - beginTime < (long)timeout && NZWiFiP2PDeviceManager.IsConnectionConnected() && NZWiFiP2PDeviceManager.IsHandlerValid() && NZWiFiP2PDeviceManager.IsManagerValid() && NZWiFiP2PDeviceManager.IsWiFiEnabled()) {
                    Thread.sleep(1L);
                }
            }
            catch (Throwable tr) {
                tr.printStackTrace();
            }
        }
        return !NZWiFiP2PDeviceManager.IsConnectionConnected();
    }

    private static boolean WifiP2pManager_Connect(String address) {
        boolean result;
        block7: {
            result = false;
            try {
                if (!NZWiFiP2PDeviceManager.IsHandlerValid() || !NZWiFiP2PDeviceManager.IsManagerValid() || !NZWiFiP2PDeviceManager.IsWiFiEnabled()) break block7;
                WifiP2pConfig mConfig = new WifiP2pConfig();
                mConfig.deviceAddress = address;
                int lastCallbackCount = mConnectActionCallbackCount;
                mWifiP2pManager.connect(mChannel, mConfig, mConnectActionListener);
                long beginTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - beginTime < 10000L) {
                    if (mConnectActionCallbackCount > lastCallbackCount) {
                        result = mConnectActionCallbackResult;
                    } else if (NZWiFiP2PDeviceManager.IsHandlerValid() && NZWiFiP2PDeviceManager.IsManagerValid() && NZWiFiP2PDeviceManager.IsWiFiEnabled()) {
                        Thread.sleep(1L);
                        continue;
                    }
                    break;
                }
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
            }
            catch (Throwable tr) {
                tr.printStackTrace();
            }
        }
        return result;
    }

    private static boolean WifiP2pManager_CancelConnect() {
        boolean result;
        block7: {
            result = false;
            try {
                if (!NZWiFiP2PDeviceManager.IsHandlerValid() || !NZWiFiP2PDeviceManager.IsManagerValid() || !NZWiFiP2PDeviceManager.IsWiFiEnabled()) break block7;
                int lastCallbackCount = mCancelConnectActionCallbackCount;
                mWifiP2pManager.cancelConnect(mChannel, mCancelConnectActionListener);
                long beginTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - beginTime < 10000L) {
                    if (mCancelConnectActionCallbackCount > lastCallbackCount) {
                        result = mCancelConnectActionCallbackResult;
                    } else if (NZWiFiP2PDeviceManager.IsHandlerValid() && NZWiFiP2PDeviceManager.IsManagerValid() && NZWiFiP2PDeviceManager.IsWiFiEnabled()) {
                        Thread.sleep(1L);
                        continue;
                    }
                    break;
                }
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
            }
            catch (Throwable tr) {
                tr.printStackTrace();
            }
        }
        return result;
    }

    private static boolean WifiP2pManager_Disconnect() {
        boolean result;
        block7: {
            result = false;
            try {
                if (!NZWiFiP2PDeviceManager.IsHandlerValid() || !NZWiFiP2PDeviceManager.IsManagerValid() || !NZWiFiP2PDeviceManager.IsWiFiEnabled()) break block7;
                int lastCallbackCount = mRemoveGroupActionCallbackCount;
                mWifiP2pManager.removeGroup(mChannel, mRemoveGroupActionListener);
                long beginTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - beginTime < 10000L) {
                    if (mRemoveGroupActionCallbackCount > lastCallbackCount) {
                        result = mRemoveGroupActionCallbackResult;
                    } else if (NZWiFiP2PDeviceManager.IsHandlerValid() && NZWiFiP2PDeviceManager.IsManagerValid() && NZWiFiP2PDeviceManager.IsWiFiEnabled()) {
                        Thread.sleep(1L);
                        continue;
                    }
                    break;
                }
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
            }
            catch (Throwable tr) {
                tr.printStackTrace();
            }
        }
        return result;
    }

    private static Collection<WifiP2pDevice> WifiP2pManager_RequestPeers() {
        Collection<WifiP2pDevice> mDeviceList;
        block7: {
            mDeviceList = null;
            try {
                if (!NZWiFiP2PDeviceManager.IsHandlerValid() || !NZWiFiP2PDeviceManager.IsManagerValid() || !NZWiFiP2PDeviceManager.IsWiFiEnabled()) break block7;
                int lastUpdatedCount = mWifiP2pDeviceListUpdatedCount;
                mWifiP2pManager.requestPeers(mChannel, mPeerListListener);
                long beginTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - beginTime < 10000L) {
                    if (mWifiP2pDeviceListUpdatedCount > lastUpdatedCount) {
                        mDeviceList = mWifiP2pDeviceList;
                    } else if (NZWiFiP2PDeviceManager.IsHandlerValid() && NZWiFiP2PDeviceManager.IsManagerValid() && NZWiFiP2PDeviceManager.IsWiFiEnabled()) {
                        Thread.sleep(1L);
                        continue;
                    }
                    break;
                }
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
            }
            catch (Throwable tr) {
                tr.printStackTrace();
            }
        }
        return mDeviceList;
    }

    private static boolean IsPeerRequested(String address) {
        boolean requested;
        block3: {
            requested = false;
            try {
                Collection<WifiP2pDevice> mDeviceList = NZWiFiP2PDeviceManager.WifiP2pManager_RequestPeers();
                if (mDeviceList == null) break block3;
                for (WifiP2pDevice device : mDeviceList) {
                    if (address == null || address.isEmpty() || !address.equals(device.deviceAddress)) continue;
                    requested = true;
                    break;
                }
            }
            catch (Throwable tr) {
                tr.printStackTrace();
            }
        }
        return requested;
    }

    private static boolean WaitPeerRequested(String address, int timeout) {
        boolean requested;
        block6: {
            requested = false;
            try {
                if (!NZWiFiP2PDeviceManager.IsHandlerValid() || !NZWiFiP2PDeviceManager.IsManagerValid() || !NZWiFiP2PDeviceManager.IsWiFiEnabled()) break block6;
                long beginTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - beginTime < (long)timeout) {
                    if (NZWiFiP2PDeviceManager.IsPeerRequested(address)) {
                        requested = true;
                    } else if (NZWiFiP2PDeviceManager.IsHandlerValid() && NZWiFiP2PDeviceManager.IsManagerValid() && NZWiFiP2PDeviceManager.IsWiFiEnabled()) {
                        Thread.sleep(1L);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable tr) {
                tr.printStackTrace();
            }
        }
        return requested;
    }

    private static boolean WifiP2pManager_DiscoverPeers() {
        boolean result;
        block7: {
            result = false;
            try {
                if (!NZWiFiP2PDeviceManager.IsHandlerValid() || !NZWiFiP2PDeviceManager.IsManagerValid() || !NZWiFiP2PDeviceManager.IsWiFiEnabled()) break block7;
                int lastCallbackCount = mDiscoverPeersActionCallbackCount;
                mWifiP2pManager.discoverPeers(mChannel, mDiscoverPeersActionListener);
                long beginTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - beginTime < 10000L) {
                    if (mDiscoverPeersActionCallbackCount > lastCallbackCount) {
                        result = mDiscoverPeersActionCallbackResult;
                    } else if (NZWiFiP2PDeviceManager.IsHandlerValid() && NZWiFiP2PDeviceManager.IsManagerValid() && NZWiFiP2PDeviceManager.IsWiFiEnabled()) {
                        Thread.sleep(1L);
                        continue;
                    }
                    break;
                }
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
            }
            catch (Throwable tr) {
                tr.printStackTrace();
            }
        }
        return result;
    }

    private static WifiP2pGroup WifiP2pManager_RequestGroupInfo() {
        WifiP2pGroup group;
        block7: {
            group = null;
            try {
                if (!NZWiFiP2PDeviceManager.IsHandlerValid() || !NZWiFiP2PDeviceManager.IsManagerValid() || !NZWiFiP2PDeviceManager.IsWiFiEnabled()) break block7;
                int lastUpdatedCount = mWifiP2pGroupUpdatedCount;
                mWifiP2pManager.requestGroupInfo(mChannel, mGroupInfoListener);
                long beginTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - beginTime < 10000L) {
                    if (mWifiP2pGroupUpdatedCount > lastUpdatedCount) {
                        group = mWifiP2pGroup;
                    } else if (NZWiFiP2PDeviceManager.IsHandlerValid() && NZWiFiP2PDeviceManager.IsManagerValid() && NZWiFiP2PDeviceManager.IsWiFiEnabled()) {
                        Thread.sleep(1L);
                        continue;
                    }
                    break;
                }
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
            }
            catch (Throwable tr) {
                tr.printStackTrace();
            }
        }
        return group;
    }

    private static boolean IsGroupOwnerDevice(String address) {
        boolean isowner = false;
        try {
            WifiP2pDevice device;
            WifiP2pGroup group = NZWiFiP2PDeviceManager.WifiP2pManager_RequestGroupInfo();
            if (group != null && (device = group.getOwner()) != null && address != null && !address.isEmpty() && address.equals(device.deviceAddress)) {
                isowner = true;
            }
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (Throwable tr) {
            tr.printStackTrace();
        }
        return isowner;
    }

    private static boolean IsGroupClientDevice(String address) {
        boolean isclient;
        block3: {
            isclient = false;
            try {
                Collection mDeviceList;
                WifiP2pGroup group = NZWiFiP2PDeviceManager.WifiP2pManager_RequestGroupInfo();
                if (group == null || (mDeviceList = group.getClientList()) == null) break block3;
                for (WifiP2pDevice device : mDeviceList) {
                    if (address == null || address.isEmpty() || !address.equals(device.deviceAddress)) continue;
                    isclient = true;
                    break;
                }
            }
            catch (Throwable tr) {
                tr.printStackTrace();
            }
        }
        return isclient;
    }

    public static boolean ConnectDevice(String address, int timeout) {
        boolean result = false;
        try {
            if (!NZWiFiP2PDeviceManager.IsHandlerValid()) {
                throw new Exception("Invalid Handler");
            }
            if (!NZWiFiP2PDeviceManager.IsManagerValid()) {
                throw new Exception("Invalid Manager");
            }
            if (!NZWiFiP2PDeviceManager.IsWiFiEnabled()) {
                NZWiFiP2PDeviceManager.EnableWiFi();
            }
            if (!NZWiFiP2PDeviceManager.IsWiFiEnabled()) {
                throw new Exception("WiFi Not Enabled");
            }
            if (NZWiFiP2PDeviceManager.IsConnectionConnected()) {
                throw new Exception("Connection Already Connected");
            }
            if (!NZWiFiP2PDeviceManager.IsPeerRequested(address)) {
                NZWiFiP2PDeviceManager.WifiP2pManager_DiscoverPeers();
                if (!NZWiFiP2PDeviceManager.WaitPeerRequested(address, timeout)) {
                    throw new Exception("Unable To Request Peer " + address);
                }
            }
            if (!NZWiFiP2PDeviceManager.WifiP2pManager_Connect(address)) {
                throw new Exception("Failed To Connect " + address);
            }
            if (!NZWiFiP2PDeviceManager.WaitConnectionConnected(timeout)) {
                throw new Exception("Connect Timeout " + address);
            }
            result = NZWiFiP2PDeviceManager.IsConnectionConnected();
            if (result) {
                Log.i((String)TAG, (String)("Connected To " + address));
            } else {
                Log.i((String)TAG, (String)("Unable To Connect " + address));
            }
            NZWiFiP2PDeviceManager.WifiP2pManager_RequestGroupInfo();
        }
        catch (Throwable tr) {
            tr.printStackTrace();
        }
        return result;
    }

    public static boolean ConnectDeviceV2(String address, int timeout) {
        if (NZWiFiP2PDeviceManager.IsDeviceConnected()) {
            if (NZWiFiP2PDeviceManager.IsGroupOwnerDevice(address)) {
                Log.i((String)TAG, (String)("Alerady Be Group Owner Device " + address));
                return true;
            }
            if (NZWiFiP2PDeviceManager.IsGroupClientDevice(address)) {
                Log.i((String)TAG, (String)("Alerady Be Group Client Device " + address));
                return true;
            }
            Log.i((String)TAG, (String)"Alerady Connected To Other Device. Disconnect First.");
            NZWiFiP2PDeviceManager.DisconnectDevice();
        }
        return NZWiFiP2PDeviceManager.ConnectDevice(address, timeout);
    }

    public static String ConnectDeviceV3(String address, int timeout, Context ctx) {
        NZWiFiP2PDeviceManager.InitHandlerAndManager(ctx);
        NZWiFiP2PDeviceManager.ConnectDeviceV2(address, timeout);
        return NZWiFiP2PDeviceManager.GetGroupOwnerHostAddress();
    }

    public static void DisconnectDevice() {
        try {
            NZWiFiP2PDeviceManager.WifiP2pManager_CancelConnect();
            NZWiFiP2PDeviceManager.WifiP2pManager_Disconnect();
            NZWiFiP2PDeviceManager.WaitConnectionDisconnected(2000);
            Log.i((String)TAG, (String)"Disconnected");
        }
        catch (Throwable tr) {
            tr.printStackTrace();
        }
    }

    public static boolean IsDeviceConnected() {
        return NZWiFiP2PDeviceManager.IsConnectionConnected();
    }

    public static String GetGroupOwnerHostAddress() {
        String hostAddress = null;
        try {
            WifiP2pInfo info = NZWiFiP2PDeviceManager.WifiP2pManager_RequestConnectionInfo();
            if (info != null && info.groupFormed && info.groupOwnerAddress != null) {
                hostAddress = info.groupOwnerAddress.getHostAddress();
            }
        }
        catch (Throwable tr) {
            tr.printStackTrace();
        }
        return hostAddress;
    }
}

