/*
 * Decompiled with CFR 0.152.
 */
package com.lvrenyang.nzio;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.util.Log;
import com.lvrenyang.nzio.NZNative;

@TargetApi(value=18)
public class NZBleDeviceEnumerator {
    private static final String TAG = "NZBleDeviceEnumerator";
    private long function_ptr = 0L;
    private long private_data = 0L;
    private BluetoothAdapter.LeScanCallback callback = new BluetoothAdapter.LeScanCallback(){

        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            String device_name = device.getName();
            String device_address = device.getAddress();
            Log.i((String)NZBleDeviceEnumerator.TAG, (String)("onLeScan " + device_name + " " + device_address));
            if (NZBleDeviceEnumerator.this.function_ptr != 0L) {
                NZNative.OnBluetoothDeviceScan(NZBleDeviceEnumerator.this.function_ptr, NZBleDeviceEnumerator.this.private_data, "" + device_name, "" + device_address);
            }
        }
    };

    public boolean StartScan(long function_ptr, long private_data) {
        this.function_ptr = function_ptr;
        this.private_data = private_data;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (null != adapter) {
            if (!adapter.isEnabled() && adapter.enable()) {
                long beginTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - beginTime < 10000L && !adapter.isEnabled()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (adapter.isEnabled()) {
                return adapter.startLeScan(this.callback);
            }
        }
        return false;
    }

    public void StopScan() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (null != adapter && adapter.isEnabled()) {
            adapter.stopLeScan(this.callback);
        }
    }
}

