/*
 * Decompiled with CFR 0.152.
 */
package com.lvrenyang.io;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Looper;
import android.util.Log;
import android.widget.Toast;
import com.lvrenyang.io.IO;
import com.lvrenyang.io.IOCallBack;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

@TargetApi(value=12)
public class USBPrinting
extends IO {
    private static final String TAG = "USBPrinting";
    private UsbEndpoint mUsbEndpointOut = null;
    private UsbEndpoint mUsbEndpointIn = null;
    private UsbDeviceConnection mUsbDeviceConnection = null;
    private AtomicBoolean isOpened = new AtomicBoolean(false);
    private AtomicBoolean isReadyRW = new AtomicBoolean(false);
    private IOCallBack cb = null;
    private Vector<Byte> rxBuffer = new Vector();
    private AtomicLong nIdleTime = new AtomicLong(0L);
    private final ReentrantLock mOpenLocker = new ReentrantLock();
    private final ReentrantLock mCloseLocker = new ReentrantLock();
    private String name;
    private String address;
    private BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
            if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
                if (device == null) {
                    return;
                }
                if (!device.getDeviceName().equalsIgnoreCase(USBPrinting.this.address)) {
                    return;
                }
                USBPrinting.this.Close();
            }
        }
    };
    private IntentFilter filter = new IntentFilter();
    private Context context;

    private void RegisterReceiver() {
        if (!this.filter.hasAction("android.hardware.usb.action.USB_DEVICE_DETACHED")) {
            this.filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        }
        this.context.registerReceiver(this.receiver, this.filter);
        Log.i((String)TAG, (String)"RegisterReceiver");
    }

    private void UnregisterReceiver() {
        this.context.unregisterReceiver(this.receiver);
        Log.i((String)TAG, (String)"UnregisterReceiver");
    }

    private void ShowToast(final Context context, final String content) {
        new Thread(){

            @Override
            public void run() {
                Log.i((String)"log", (String)"run");
                Looper.prepare();
                Toast.makeText((Context)context, (CharSequence)content, (int)1).show();
                Looper.loop();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Open(UsbManager manager, UsbDevice device, Context mContext) {
        try {
            this.mOpenLocker.lock();
            if (this.isOpened.get()) {
                throw new Exception("Already open");
            }
            if (null == mContext) {
                throw new Exception("Null Pointer mContext");
            }
            this.context = mContext;
            if (null == device) {
                throw new Exception("Null Pointer device");
            }
            this.address = device.getDeviceName();
            this.name = "VID" + device.getVendorId() + "PID" + device.getProductId();
            this.isReadyRW.set(false);
            try {
                if (!manager.hasPermission(device)) {
                    throw new Exception("No Permission");
                }
                UsbInterface usbInterface = null;
                UsbEndpoint usbEndpointOut = null;
                UsbEndpoint usbEndpointIn = null;
                for (int k = 0; k < device.getInterfaceCount(); ++k) {
                    usbInterface = device.getInterface(k);
                    if (usbInterface == null || device.getInterfaceCount() > 1 && (usbInterface.getInterfaceClass() != 7 || usbInterface.getInterfaceSubclass() != 1)) continue;
                    usbEndpointOut = null;
                    usbEndpointIn = null;
                    for (int j = 0; j < usbInterface.getEndpointCount(); ++j) {
                        UsbEndpoint endpoint = usbInterface.getEndpoint(j);
                        if (endpoint.getDirection() == 0 && endpoint.getType() == 2) {
                            usbEndpointOut = endpoint;
                        } else if (endpoint.getDirection() == 128 && endpoint.getType() == 2) {
                            usbEndpointIn = endpoint;
                        }
                        if (null != usbEndpointOut && null != usbEndpointIn) break;
                    }
                    if (null != usbEndpointOut && null != usbEndpointIn) break;
                }
                if (null == usbInterface || null == usbEndpointOut || null == usbEndpointIn) {
                    throw new Exception("No Endpoint");
                }
                UsbDeviceConnection usbDeviceConnection = manager.openDevice(device);
                if (null == usbDeviceConnection) {
                    throw new Exception("Open Device Failed");
                }
                if (!usbDeviceConnection.claimInterface(usbInterface, true)) {
                    usbDeviceConnection.close();
                    throw new Exception("ClaimInterface Failed");
                }
                this.mUsbEndpointOut = usbEndpointOut;
                this.mUsbEndpointIn = usbEndpointIn;
                this.mUsbDeviceConnection = usbDeviceConnection;
                this.isReadyRW.set(true);
            }
            catch (Exception ex) {
                Log.i((String)TAG, (String)ex.toString());
                this.ShowToast(mContext, ex.toString());
            }
            if (this.isReadyRW.get()) {
                Log.v((String)TAG, (String)"Connected to USB Device");
                this.rxBuffer.clear();
                this.RegisterReceiver();
            }
            this.isOpened.set(this.isReadyRW.get());
            if (this.isOpened.get()) {
                this.StartReadThread();
            }
            if (null != this.cb) {
                if (this.isOpened.get()) {
                    this.cb.OnOpen();
                } else {
                    this.cb.OnOpenFailed();
                }
            }
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
            this.ShowToast(mContext, ex.toString());
        }
        finally {
            this.mOpenLocker.unlock();
        }
        return this.isOpened.get();
    }

    @Override
    public void BaseClose() {
        this.mCloseLocker.lock();
        try {
            try {
                if (null != this.mUsbDeviceConnection) {
                    this.mUsbDeviceConnection.close();
                }
            }
            catch (Exception ex) {
                Log.i((String)TAG, (String)ex.toString());
            }
            if (!this.isReadyRW.get()) {
                throw new Exception();
            }
            this.mUsbEndpointOut = null;
            this.mUsbEndpointIn = null;
            this.mUsbDeviceConnection = null;
            this.UnregisterReceiver();
            this.isReadyRW.set(false);
            if (!this.isOpened.get()) {
                throw new Exception();
            }
            this.isOpened.set(false);
            if (null != this.cb) {
                this.cb.OnClose();
            }
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        finally {
            this.mCloseLocker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int Write(byte[] buffer, int offset, int count) {
        int nBytesWritten;
        if (!this.isReadyRW.get()) {
            return -1;
        }
        try {
            int nSended;
            this.nIdleTime.set(0L);
            for (nBytesWritten = 0; nBytesWritten < count; nBytesWritten += nSended) {
                if (!this.isReadyRW.get()) {
                    throw new Exception("Not Ready For Read Write");
                }
                int nPackageSize = Math.min(this.mUsbEndpointOut.getMaxPacketSize(), count - nBytesWritten);
                byte[] data = new byte[nPackageSize];
                System.arraycopy(buffer, offset + nBytesWritten, data, 0, data.length);
                nSended = this.mUsbDeviceConnection.bulkTransfer(this.mUsbEndpointOut, data, data.length, Integer.MAX_VALUE);
                if (nSended >= 0) continue;
                throw new Exception("Write Failed");
            }
            this.nIdleTime.set(System.currentTimeMillis());
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)ex.toString());
            this.Close();
            nBytesWritten = -1;
        }
        return nBytesWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int BaseRead(byte[] buffer, int offset, int count, int timeout) {
        if (!this.isReadyRW.get()) {
            return -1;
        }
        int nBytesReaded = 0;
        try {
            this.nIdleTime.set(0L);
            long time = System.currentTimeMillis();
            while (System.currentTimeMillis() - time < (long)timeout) {
                if (!this.isReadyRW.get()) {
                    throw new Exception("Not Ready For Read Write");
                }
                if (nBytesReaded == count) break;
                if (this.rxBuffer.size() > 0) {
                    buffer[offset + nBytesReaded] = this.rxBuffer.get(0);
                    this.rxBuffer.remove(0);
                    ++nBytesReaded;
                    continue;
                }
                int nPackageSize = this.mUsbEndpointIn.getMaxPacketSize();
                byte[] receive = new byte[nPackageSize];
                int nReceived = this.mUsbDeviceConnection.bulkTransfer(this.mUsbEndpointIn, receive, receive.length, 100);
                if (nReceived <= 0) continue;
                for (int i = 0; i < nReceived; ++i) {
                    this.rxBuffer.add(receive[i]);
                }
            }
            this.nIdleTime.set(System.currentTimeMillis());
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)ex.toString());
            this.Close();
            nBytesReaded = -1;
        }
        return nBytesReaded;
    }

    @Override
    public boolean IsOpened() {
        return this.isOpened.get();
    }

    public void SetCallBack(IOCallBack callBack) {
        try {
            this.cb = callBack;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }
}

