/*
 * Decompiled with CFR 0.152.
 */
package com.lvrenyang.io;

import android.util.Log;
import com.lvrenyang.io.UDPDiscoveryCallBack;
import com.lvrenyang.io.UDPPrinting;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantLock;

public class UDPDiscovery {
    private static final String TAG = "UDPDiscovery";
    private final ReentrantLock locker = new ReentrantLock();
    private UDPDiscoveryCallBack ndcb = null;

    public void SetNetworkDiscoveryCallBack(UDPDiscoveryCallBack callBack) {
        this.Lock();
        try {
            this.ndcb = callBack;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        finally {
            this.Unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DiscoveryIpMac(byte[] addr, int port, int timeout) {
        this.Lock();
        try {
            if (null != this.ndcb) {
                this.ndcb.onDiscoverStarted();
            }
            DatagramSocket mmClientSocket = null;
            try {
                mmClientSocket = new DatagramSocket(port, InetAddress.getByAddress(addr));
                mmClientSocket.setBroadcast(true);
                mmClientSocket.setReuseAddress(true);
                mmClientSocket.setSoTimeout(timeout);
                byte[] cmd = new byte[]{69, 80, 83, 79, 78, 80, 0, 0, 0, 0, 0, 0, 0, 0};
                DatagramPacket sendPacket = new DatagramPacket(cmd, cmd.length, InetAddress.getByName("255.255.255.255"), 3289);
                mmClientSocket.send(sendPacket);
                long time = System.currentTimeMillis();
                while (System.currentTimeMillis() - time < (long)timeout) {
                    byte[] data = new byte[1024];
                    DatagramPacket recvPacket = new DatagramPacket(data, data.length);
                    mmClientSocket.receive(recvPacket);
                    if (recvPacket.getLength() != 68) continue;
                    byte[] ipBytes = recvPacket.getAddress().getAddress();
                    String ip = String.format(Locale.CHINA, "%d.%d.%d.%d", (long)ipBytes[0] & 0xFFL, (long)ipBytes[1] & 0xFFL, (long)ipBytes[2] & 0xFFL, (long)ipBytes[3] & 0xFFL);
                    String mac = String.format(Locale.CHINA, "%02X-%02X-%02X-%02X-%02X-%02X", (long)data[54] & 0xFFL, (long)data[55] & 0xFFL, (long)data[56] & 0xFFL, (long)data[57] & 0xFFL, (long)data[58] & 0xFFL, (long)data[59] & 0xFFL);
                    Log.i((String)TAG, (String)("Discovered IP:" + ip + " MAC:" + mac));
                    if (null == this.ndcb) continue;
                    this.ndcb.onDiscoveredIpMac(mac, ip);
                }
            }
            catch (Exception ex) {
                Log.i((String)TAG, (String)ex.toString());
                try {
                    mmClientSocket.close();
                }
                catch (Exception closeException) {
                    Log.i((String)TAG, (String)closeException.toString());
                }
                finally {
                    mmClientSocket = null;
                }
            }
            if (null != this.ndcb) {
                this.ndcb.onDiscoverFinished();
            }
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        finally {
            this.Unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DiscoveryIpName(byte[] addr, int port, int timeout) {
        this.Lock();
        try {
            if (null != this.ndcb) {
                this.ndcb.onDiscoverStarted();
            }
            DatagramSocket mmClientSocket = null;
            try {
                mmClientSocket = new DatagramSocket(port, InetAddress.getByAddress(addr));
                mmClientSocket.setBroadcast(true);
                mmClientSocket.setReuseAddress(true);
                mmClientSocket.setSoTimeout(timeout);
                byte[] cmd = new byte[148];
                byte[] cmd_default = new byte[]{69, 80, 83, 79, 78, 81, 3, 0, 0, 0, 0, 0, 0, -122, 100, -21, -116, 42, 44, -84, 0};
                System.arraycopy(cmd_default, 0, cmd, 0, cmd_default.length);
                DatagramPacket sendPacket = new DatagramPacket(cmd, cmd.length, InetAddress.getByName("255.255.255.255"), 3289);
                mmClientSocket.send(sendPacket);
                long time = System.currentTimeMillis();
                while (System.currentTimeMillis() - time < (long)timeout) {
                    byte[] data = new byte[1024];
                    DatagramPacket recvPacket = new DatagramPacket(data, data.length);
                    mmClientSocket.receive(recvPacket);
                    if (recvPacket.getLength() != 147 || data[0] != 69 || data[1] != 80 || data[2] != 83 || data[3] != 79 || data[4] != 78 || data[5] != 113) continue;
                    int namelen = 0;
                    for (int i = 19; i < data.length; ++i) {
                        if (data[i] != 0) continue;
                        namelen = i - 19;
                        break;
                    }
                    String name = new String(data, 19, namelen);
                    byte[] ipBytes = recvPacket.getAddress().getAddress();
                    String ip = String.format(Locale.CHINA, "%d.%d.%d.%d", (long)ipBytes[0] & 0xFFL, (long)ipBytes[1] & 0xFFL, (long)ipBytes[2] & 0xFFL, (long)ipBytes[3] & 0xFFL);
                    Log.i((String)TAG, (String)("Discovered IP:" + ip + " Name:" + name));
                    if (null == this.ndcb) continue;
                    this.ndcb.onDiscoveredIpName(ip, name);
                }
            }
            catch (Exception ex) {
                Log.i((String)TAG, (String)ex.toString());
                try {
                    mmClientSocket.close();
                }
                catch (Exception closeException) {
                    Log.i((String)TAG, (String)closeException.toString());
                }
                finally {
                    mmClientSocket = null;
                }
            }
            if (null != this.ndcb) {
                this.ndcb.onDiscoverFinished();
            }
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        finally {
            this.Unlock();
        }
    }

    public void discoverPrinter(UDPPrinting udp, int timeout, int interval, int max_retry) {
        if (null != this.ndcb) {
            this.ndcb.onDiscoverStarted();
        }
        for (int retry = 0; retry < max_retry && udp.IsOpened(); ++retry) {
            byte[] cmd = new byte[]{69, 80, 83, 79, 78, 81, 3, 0, 0, 1, 0, 0, 0, 0};
            if (udp.Write(cmd, 0, cmd.length) != cmd.length) continue;
            long time = System.currentTimeMillis();
            while (System.currentTimeMillis() - time < (long)timeout && udp.IsOpened()) {
                DatagramPacket packet = udp.RecvPacketDirect(1024, interval);
                if (packet == null) continue;
                byte[] data = packet.getData();
                int length = packet.getLength();
                if (length != 184 || data[0] != 69 || data[1] != 80 || data[2] != 83 || data[3] != 79 || data[4] != 78 || data[5] != 113) continue;
                int namelen = 0;
                for (int i = 56; i < data.length; ++i) {
                    if (data[i] != 0) continue;
                    namelen = i - 56;
                    break;
                }
                String name = new String(data, 56, namelen);
                byte[] ipBytes = packet.getAddress().getAddress();
                String ip = String.format(Locale.CHINA, "%d.%d.%d.%d", (long)ipBytes[0] & 0xFFL, (long)ipBytes[1] & 0xFFL, (long)ipBytes[2] & 0xFFL, (long)ipBytes[3] & 0xFFL);
                String mac = String.format(Locale.CHINA, "%02X-%02X-%02X-%02X-%02X-%02X", (long)data[14] & 0xFFL, (long)data[15] & 0xFFL, (long)data[16] & 0xFFL, (long)data[17] & 0xFFL, (long)data[18] & 0xFFL, (long)data[19] & 0xFFL);
                Log.i((String)TAG, (String)("Discovered MAC:" + mac + " IP:" + ip + " Name:" + name));
                if (null == this.ndcb) continue;
                this.ndcb.onDiscoveredMacIpName(mac, ip, name);
            }
        }
        if (null != this.ndcb) {
            this.ndcb.onDiscoverFinished();
        }
    }

    public static String discoverPrinterIPByName(String local_ip, int local_port, String dest_ip, int dest_port, String name, int timeout, int interval, int max_retry) {
        String ip = null;
        UDPPrinting udp = new UDPPrinting();
        if (udp.Open(local_ip, local_port, dest_ip, dest_port)) {
            udp.SetBroadcast(true);
            udp.SetReuseAddress(true);
            for (int retry = 0; retry < max_retry && udp.IsOpened(); ++retry) {
                byte[] cmd = new byte[]{69, 80, 83, 79, 78, 81, 3, 0, 0, 1, 0, 0, 0, 0};
                if (udp.Write(cmd, 0, cmd.length) != cmd.length) continue;
                long time = System.currentTimeMillis();
                while (System.currentTimeMillis() - time < (long)timeout && udp.IsOpened()) {
                    DatagramPacket packet = udp.RecvPacketDirect(1024, interval);
                    if (packet == null) continue;
                    byte[] data = packet.getData();
                    int length = packet.getLength();
                    if (length != 184 || data[0] != 69 || data[1] != 80 || data[2] != 83 || data[3] != 79 || data[4] != 78 || data[5] != 113) continue;
                    int namelen = 0;
                    for (int i = 56; i < data.length; ++i) {
                        if (data[i] != 0) continue;
                        namelen = i - 56;
                        break;
                    }
                    if (!name.equals(new String(data, 56, namelen))) continue;
                    byte[] ipBytes = packet.getAddress().getAddress();
                    ip = String.format(Locale.CHINA, "%d.%d.%d.%d", (long)ipBytes[0] & 0xFFL, (long)ipBytes[1] & 0xFFL, (long)ipBytes[2] & 0xFFL, (long)ipBytes[3] & 0xFFL);
                    Log.i((String)TAG, (String)("Discovered " + name + " " + ip));
                    break;
                }
                if (ip != null) break;
            }
            udp.Close();
        }
        return ip;
    }

    protected synchronized void Lock() {
        this.locker.lock();
    }

    protected synchronized void Unlock() {
        this.locker.unlock();
    }
}

