/*
 * Decompiled with CFR 0.152.
 */
package com.lvrenyang.io;

import com.lvrenyang.io.ByteUtils;
import com.lvrenyang.io.UDPPrinting;

public class UDPBroadcastProto {
    public static boolean configName(UDPPrinting udp, byte[] mac, byte[] name, int timeout, int interval, int max_retry) {
        boolean ret = false;
        for (int retry = 0; retry < max_retry && udp.IsOpened(); ++retry) {
            byte[] cmd = new byte[148];
            cmd[0] = 69;
            cmd[1] = 80;
            cmd[2] = 83;
            cmd[3] = 79;
            cmd[4] = 78;
            cmd[5] = 83;
            cmd[6] = 3;
            cmd[13] = -122;
            int offset = 14;
            System.arraycopy(mac, 0, cmd, offset, 6);
            System.arraycopy(name, 0, cmd, offset += 6, Math.min(name.length, 127));
            if (udp.Write(cmd, 0, cmd.length) != cmd.length) continue;
            long time = System.currentTimeMillis();
            while (System.currentTimeMillis() - time < (long)timeout && udp.IsOpened()) {
                byte[] data = new byte[1024];
                int nBytesReaded = udp.RecvDirect(data, 0, data.length, timeout);
                if (nBytesReaded != 148) continue;
                cmd[5] = 115;
                if (!ByteUtils.bytesEquals(cmd, 0, data, 0, cmd.length)) continue;
                ret = true;
                break;
            }
            if (ret) break;
        }
        return ret;
    }

    public static boolean configIP(UDPPrinting udp, byte[] mac, boolean dhcp, byte[] ip, byte[] netmask, byte[] gateway, int timeout, int interval, int max_retry) {
        boolean ret = false;
        for (int retry = 0; retry < max_retry && udp.IsOpened(); ++retry) {
            byte[] bFixedIP = new byte[]{-128, 8};
            byte[] bDhcpIP = new byte[]{0, 12};
            byte[] cmd = new byte[]{69, 80, 83, 79, 78, 83, 0, 0, 0, 16, 0, 0, 0, 21, 1, 100, -21, -116, 42, 42, -84, 0, 12, -64, -88, 10, -48, -1, -1, -1, 0, 0, 0, 0, 0};
            int offset = 15;
            System.arraycopy(mac, 0, cmd, offset, 6);
            System.arraycopy(dhcp ? bDhcpIP : bFixedIP, 0, cmd, offset += 6, 2);
            System.arraycopy(ip, 0, cmd, offset += 2, 4);
            System.arraycopy(netmask, 0, cmd, offset += 4, 4);
            System.arraycopy(gateway, 0, cmd, offset += 4, 4);
            offset += 4;
            if (udp.Write(cmd, 0, cmd.length) != cmd.length) continue;
            long time = System.currentTimeMillis();
            while (System.currentTimeMillis() - time < (long)timeout && udp.IsOpened()) {
                byte[] data = new byte[1024];
                int nBytesReaded = udp.RecvDirect(data, 0, data.length, timeout);
                if (nBytesReaded != 37 || data[0] != 69 || data[1] != 80 || data[2] != 83 || data[3] != 79 || data[4] != 78 || data[5] != 115 || data[6] != 0 || data[7] != 0 || data[8] != 0 || data[9] != 16) continue;
                ret = true;
                break;
            }
            if (ret) break;
        }
        return ret;
    }

    public static boolean confirmConfiguration(UDPPrinting udp, byte[] mac, int timeout, int interval, int max_retry) {
        boolean ret = false;
        for (int retry = 0; retry < max_retry && udp.IsOpened(); ++retry) {
            byte[] cmd = new byte[]{69, 80, 83, 79, 78, 83, 0, 0, 1, 0, 0, 0, 0, 11, 100, -21, -116, 42, 42, -84, 1, 0, 18, 0, 0};
            int offset = 14;
            System.arraycopy(mac, 0, cmd, offset, 6);
            offset += 6;
            if (udp.Write(cmd, 0, cmd.length) != cmd.length) continue;
            long time = System.currentTimeMillis();
            while (System.currentTimeMillis() - time < (long)timeout && udp.IsOpened()) {
                byte[] data = new byte[1024];
                int nBytesReaded = udp.RecvDirect(data, 0, data.length, timeout);
                if (nBytesReaded != 25 || data[0] != 69 || data[1] != 80 || data[2] != 83 || data[3] != 79 || data[4] != 78 || data[5] != 115 || data[6] != 0 || data[7] != 0 || data[8] != 1 || data[9] != 0) continue;
                ret = true;
                break;
            }
            if (ret) break;
        }
        return ret;
    }
}

