/*
 * Decompiled with CFR 0.152.
 */
package com.lvrenyang.io;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import com.lvrenyang.io.IO;
import com.lvrenyang.io.IOCallBack;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

@TargetApi(value=5)
public class BTPrinting
extends IO {
    private static final String TAG = "BTPrinting";
    private static final UUID uuid = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private BluetoothServerSocket mmServerSocket = null;
    private BluetoothSocket mmClientSocket = null;
    private DataInputStream is = null;
    private DataOutputStream os = null;
    private AtomicBoolean isOpened = new AtomicBoolean(false);
    private AtomicBoolean isReadyRW = new AtomicBoolean(false);
    private IOCallBack cb = null;
    private Vector<Byte> rxBuffer = new Vector();
    private AtomicLong nIdleTime = new AtomicLong(0L);
    private final ReentrantLock mOpenLocker = new ReentrantLock();
    private final ReentrantLock mCloseLocker = new ReentrantLock();
    private String address;
    private BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            if ("android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED".equals(action) || "android.bluetooth.device.action.ACL_DISCONNECTED".equals(action)) {
                if (device == null) {
                    return;
                }
                if (!device.getAddress().equalsIgnoreCase(BTPrinting.this.address)) {
                    return;
                }
                BTPrinting.this.Close();
            }
        }
    };
    private IntentFilter filter = new IntentFilter();
    private Context context;

    private void RegisterReceiver() {
        if (!this.filter.hasAction("android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED")) {
            this.filter.addAction("android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED");
        }
        if (!this.filter.hasAction("android.bluetooth.device.action.ACL_DISCONNECTED")) {
            this.filter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
        }
        this.context.registerReceiver(this.receiver, this.filter);
        Log.i((String)TAG, (String)"RegisterReceiver");
    }

    private void UnregisterReceiver() {
        this.context.unregisterReceiver(this.receiver);
        Log.i((String)TAG, (String)"UnregisterReceiver");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Open(String BTAddress, Context mContext) {
        try {
            this.mOpenLocker.lock();
            if (this.isOpened.get()) {
                throw new Exception("Already open");
            }
            if (null == mContext) {
                throw new Exception("Null Pointer mContext");
            }
            this.context = mContext.getApplicationContext();
            if (null == BTAddress) {
                throw new Exception("Null Pointer BTAddress");
            }
            this.address = BTAddress;
            this.isReadyRW.set(false);
            BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            if (bluetoothAdapter == null) {
                throw new Exception("Null BluetoothAdapter");
            }
            bluetoothAdapter.cancelDiscovery();
            BluetoothDevice device = bluetoothAdapter.getRemoteDevice(BTAddress);
            long timeout = 10000L;
            long time = System.currentTimeMillis();
            while (System.currentTimeMillis() - time < timeout) {
                try {
                    this.mmClientSocket = device.createRfcommSocketToServiceRecord(uuid);
                    try {
                        this.mmClientSocket.connect();
                        this.os = new DataOutputStream(this.mmClientSocket.getOutputStream());
                        this.is = new DataInputStream(this.mmClientSocket.getInputStream());
                        this.isReadyRW.set(true);
                    }
                    catch (Exception connectException) {
                        Log.i((String)TAG, (String)connectException.toString());
                        try {
                            this.mmClientSocket.close();
                        }
                        catch (Exception closeException) {
                            Log.i((String)TAG, (String)closeException.toString());
                        }
                        finally {
                            this.mmClientSocket = null;
                            this.os = null;
                            this.is = null;
                        }
                        throw new Exception("Connect Failed");
                    }
                }
                catch (Exception ex) {
                    Log.i((String)TAG, (String)ex.toString());
                }
                if (!this.isReadyRW.get()) continue;
            }
            if (this.isReadyRW.get()) {
                Log.v((String)TAG, (String)("Connected to " + BTAddress));
                this.rxBuffer.clear();
                this.RegisterReceiver();
            }
            this.isOpened.set(this.isReadyRW.get());
            if (this.isOpened.get()) {
                this.StartReadThread();
            }
            if (null != this.cb) {
                if (this.isOpened.get()) {
                    this.cb.OnOpen();
                } else {
                    this.cb.OnOpenFailed();
                }
            }
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        finally {
            this.mOpenLocker.unlock();
        }
        return this.isOpened.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Listen(String BTAddress, int timeout, Context mContext) {
        try {
            this.mOpenLocker.lock();
            if (this.isOpened.get()) {
                throw new Exception("Already open");
            }
            if (null == mContext) {
                throw new Exception("Null Pointer mContext");
            }
            this.context = mContext;
            if (null == BTAddress) {
                throw new Exception("Null Pointer BTAddress");
            }
            this.address = BTAddress;
            this.isReadyRW.set(false);
            BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            if (bluetoothAdapter == null) {
                throw new Exception("Null BluetoothAdapter");
            }
            bluetoothAdapter.cancelDiscovery();
            this.mmServerSocket = bluetoothAdapter.listenUsingRfcommWithServiceRecord("rfcomm", uuid);
            try {
                this.mmClientSocket = this.mmServerSocket.accept(timeout);
            }
            catch (Exception acceptException) {
                Log.i((String)TAG, (String)acceptException.toString());
                try {
                    this.mmServerSocket.close();
                }
                catch (Exception closeException) {
                    Log.i((String)TAG, (String)closeException.toString());
                }
                finally {
                    this.mmServerSocket = null;
                }
                throw new Exception("Accept Failed");
            }
            try {
                this.os = new DataOutputStream(this.mmClientSocket.getOutputStream());
                this.is = new DataInputStream(this.mmClientSocket.getInputStream());
                this.isReadyRW.set(true);
            }
            catch (Exception streamException) {
                Log.i((String)TAG, (String)streamException.toString());
                try {
                    this.mmClientSocket.close();
                }
                catch (Exception closeException) {
                    Log.i((String)TAG, (String)closeException.toString());
                }
                finally {
                    this.mmClientSocket = null;
                    this.os = null;
                    this.is = null;
                }
                throw new Exception("Get Stream Failed");
            }
            if (this.isReadyRW.get()) {
                Log.v((String)TAG, (String)("Connected to " + BTAddress));
                this.rxBuffer.clear();
                this.RegisterReceiver();
            }
            this.isOpened.set(this.isReadyRW.get());
            if (this.isOpened.get()) {
                this.StartReadThread();
            }
            if (null != this.cb) {
                if (this.isOpened.get()) {
                    this.cb.OnOpen();
                } else {
                    this.cb.OnOpenFailed();
                }
            }
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        finally {
            this.mOpenLocker.unlock();
        }
        return this.isOpened.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void BaseClose() {
        this.mCloseLocker.lock();
        try {
            try {
                if (null != this.mmServerSocket) {
                    this.mmServerSocket.close();
                }
            }
            catch (Exception exception) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            try {
                if (null != this.mmClientSocket) {
                    this.mmClientSocket.close();
                }
            }
            catch (Exception exception) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            if (!this.isReadyRW.get()) {
                throw new Exception();
            }
            this.mmServerSocket = null;
            this.mmClientSocket = null;
            this.is = null;
            this.os = null;
            this.UnregisterReceiver();
            this.isReadyRW.set(false);
            if (!this.isOpened.get()) {
                throw new Exception();
            }
            this.isOpened.set(false);
            if (null != this.cb) {
                this.cb.OnClose();
            }
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        finally {
            this.mCloseLocker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int Write(byte[] buffer, int offset, int count) {
        if (!this.isReadyRW.get()) {
            return -1;
        }
        int nBytesWritten = 0;
        try {
            this.nIdleTime.set(0L);
            this.os.write(buffer, offset, count);
            this.os.flush();
            nBytesWritten = count;
            this.nIdleTime.set(System.currentTimeMillis());
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)ex.toString());
            this.Close();
            nBytesWritten = -1;
        }
        return nBytesWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int BaseRead(byte[] buffer, int offset, int count, int timeout) {
        if (!this.isReadyRW.get()) {
            return -1;
        }
        int nBytesReaded = 0;
        try {
            this.nIdleTime.set(0L);
            long time = System.currentTimeMillis();
            while (System.currentTimeMillis() - time < (long)timeout) {
                if (!this.isReadyRW.get()) {
                    throw new Exception("Not Ready For Read Write");
                }
                if (nBytesReaded == count) break;
                if (this.rxBuffer.size() > 0) {
                    buffer[offset + nBytesReaded] = this.rxBuffer.get(0);
                    this.rxBuffer.remove(0);
                    ++nBytesReaded;
                    continue;
                }
                int available = this.is.available();
                if (available > 0) {
                    byte[] receive = new byte[available];
                    int nReceived = this.is.read(receive);
                    if (nReceived <= 0) continue;
                    for (int i = 0; i < nReceived; ++i) {
                        this.rxBuffer.add(receive[i]);
                    }
                    continue;
                }
                if (available == 0) {
                    Thread.sleep(1L);
                    continue;
                }
                throw new Exception("available " + available);
            }
            this.nIdleTime.set(System.currentTimeMillis());
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)ex.toString());
            this.Close();
            nBytesReaded = -1;
        }
        return nBytesReaded;
    }

    @Override
    public boolean IsOpened() {
        return this.isOpened.get();
    }

    public void SetCallBack(IOCallBack callBack) {
        try {
            this.cb = callBack;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }
}

