package com.caysn.autoreplyprint.caprint;

import java.io.File;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;

/**
 * 用于记录调试信息到文件中
 */
public class CAPrintLogger {

    public static String logToDir = null;

    public static synchronized void debug(String format, Object... args) {
        try {
            if (logToDir != null) {
                Date now = new Date();
                String logToFile = logToDir + "/" + new SimpleDateFormat("yyyyMMdd").format(now) + ".txt";
                String str = new SimpleDateFormat("HH:mm:ss.SSS").format(now) + " " + new Formatter().format(format, args).toString() + "\r\n";
                AddToFile(str, logToFile);
            }
        } catch (Throwable tr) {
            tr.printStackTrace();
        }
    }

    private static void AddToFile(String text, String dumpfile) {
        if (null == dumpfile)
            return;
        if (null == text)
            return;
        if ("".equals(text))
            return;

        try {
            File file = new File(dumpfile);
            File dir = file.getParentFile();
            if (!dir.exists())
                dir.mkdirs();
            if (!file.exists()) {
                file.createNewFile();
            }
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            raf.seek(file.length());
            raf.write(text.getBytes());
            raf.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
