/*
 * Decompiled with CFR 0.152.
 */
package com.print.usbprint.util;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import android.widget.Toast;
import com.print.usbprint.command.Esc;
import com.print.usbprint.command.Label;
import com.print.usbprint.util.USBReadThread;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class USBUtil {
    private static USBUtil instance;
    private PendingIntent mPermissionIntent;
    private UsbManager usbManager;
    private Context context;
    private UsbInterface usbInterface;
    private UsbEndpoint usbEndpointIn;
    private UsbEndpoint usbEndpointOut;
    private UsbDeviceConnection usbConnection;
    private List<UsbDevice> usbDevices = new ArrayList<UsbDevice>();
    private Toast toast;
    private USBReadThread readThread;
    public static final String Paper = "need_paper";
    private static String normal;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static USBUtil getInstance() {
        if (instance != null) return instance;
        Class<USBUtil> clazz = USBUtil.class;
        synchronized (USBUtil.class) {
            if (instance != null) return instance;
            instance = new USBUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setUsbManager(UsbManager usbManager) {
        this.usbManager = usbManager;
    }

    public UsbManager getUsbManager() {
        return this.usbManager;
    }

    @SuppressLint(value={"WrongConstant"})
    public void init(Context context) {
        this.context = context;
        this.usbManager = (UsbManager)context.getSystemService("usb");
        this.setUsbManager(this.usbManager);
    }

    public void setDeviceList(List<UsbDevice> deviceList) {
        this.usbDevices = deviceList;
    }

    public List<UsbDevice> getDeviceList(Context context) {
        if (this.usbManager == null) {
            Log.i((String)"\u5237\u65b0\u8bbe\u5907\u65f6", (String)"\u672a\u83b7\u5f97\u8bbe\u5907\uff01");
            return null;
        }
        HashMap deviceList = this.usbManager.getDeviceList();
        for (UsbDevice device : deviceList.values()) {
            if (!this.usbDevices.contains(device)) {
                this.usbDevices.add(device);
            }
            Log.e((String)"USBUtil", (String)("getDeviceList: " + device.getDeviceName()));
        }
        return this.usbDevices;
    }

    @SuppressLint(value={"WrongConstant"})
    public UsbDevice getUsbDevice(int vendorId, int productId) {
        UsbDevice device;
        HashMap deviceList = this.usbManager.getDeviceList();
        Iterator deviceIterator = deviceList.values().iterator();
        do {
            if (deviceIterator.hasNext()) continue;
            Toast.makeText((Context)this.context, (CharSequence)"\u6ca1\u6709\u5bf9\u5e94\u7684\u8bbe\u5907", (int)0).show();
            return null;
        } while ((device = (UsbDevice)deviceIterator.next()).getVendorId() != vendorId || device.getProductId() != productId);
        Log.e((String)"USBUtil", (String)("getDeviceList: " + device.getDeviceName()));
        return device;
    }

    public boolean hasPermission(UsbDevice device) {
        return this.usbManager.hasPermission(device);
    }

    @SuppressLint(value={"WrongConstant", "ShowToast"})
    public void requestPermission(UsbDevice device) {
        if (device != null) {
            if (this.usbManager.hasPermission(device)) {
                this.showToast("\u5df2\u7ecf\u83b7\u53d6\u5230\u6743\u9650");
            } else if (this.mPermissionIntent != null) {
                this.usbManager.requestPermission(device, this.mPermissionIntent);
                this.showToast("\u8bf7\u6c42USB\u6743\u9650");
            } else {
                this.showToast("\u8bf7\u6ce8\u518cUSB\u5e7f\u64ad");
            }
        }
    }

    public void openUSB(UsbDevice device, Context context) {
        this.context = context;
        if (device == null) {
            this.showToast("\u83b7\u53d6\u7684usb\u8bbe\u5907\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u786e\u8ba4\uff01");
            return;
        }
        if (!this.hasPermission(device)) {
            this.showToast("\u65e0\u8be5\u8bbe\u5907\u7684\u6743\u9650");
            return;
        }
        int a = device.getInterfaceCount();
        Log.i((String)"Interface\u6570\u91cf\uff1a", (String)String.valueOf(a));
        if (a < 1) {
            this.showToast("\u8be5usb\u8bbe\u5907\u65e0\u53ef\u7528\u63a5\u53e3");
            return;
        }
        this.usbConnection = this.usbManager.openDevice(device);
        if (this.usbConnection == null) {
            this.showToast("\u65e0\u6cd5\u5efa\u7acb\u8fde\u63a5\uff0c\u8bf7\u68c0\u67e5Usb\u8fde\u63a5\u662f\u5426\u7a33\u5b9a");
            return;
        }
        for (int i = 0; i < device.getInterfaceCount(); ++i) {
            UsbInterface usbInterface = device.getInterface(i);
            if (usbInterface.getInterfaceClass() != 10 && usbInterface.getInterfaceClass() != 7 && usbInterface.getInterfaceClass() != 255) continue;
            this.usbInterface = usbInterface;
        }
        if (this.usbConnection.claimInterface(this.usbInterface, true)) {
            for (int j = 0; j < this.usbInterface.getEndpointCount(); ++j) {
                UsbEndpoint usbEndpoint = this.usbInterface.getEndpoint(j);
                if (usbEndpoint.getType() != 2) continue;
                if (usbEndpoint.getDirection() == 128) {
                    this.usbEndpointIn = usbEndpoint;
                    continue;
                }
                if (usbEndpoint.getDirection() != 0) continue;
                this.usbEndpointOut = usbEndpoint;
            }
        }
        if (this.usbEndpointIn != null && this.usbEndpointOut != null && this.usbConnection.claimInterface(this.usbInterface, true)) {
            this.startReading();
        }
    }

    public boolean IsOpen(UsbDevice device, Context context) {
        boolean open = false;
        this.openUSB(device, context);
        if (this.usbEndpointIn != null && this.usbEndpointOut != null) {
            open = true;
        }
        Log.i((String)"\u662f\u5426\u6253\u5f00", (String)String.valueOf(open));
        if (!open && this.usbConnection != null) {
            this.usbConnection.close();
        }
        return open;
    }

    public int sendMessage(byte[] bytes) {
        return this.usbConnection.bulkTransfer(this.usbEndpointOut, bytes, bytes.length, 500);
    }

    public void closeport(int timeout) {
        if (this.usbConnection != null) {
            try {
                Thread.sleep(timeout);
            }
            catch (InterruptedException var4) {
                var4.printStackTrace();
            }
            try {
                this.usbConnection.close();
                this.usbConnection.releaseInterface(this.usbInterface);
                this.usbConnection = null;
                this.usbEndpointIn = null;
                this.usbEndpointOut = null;
                this.usbManager = null;
                this.usbInterface = null;
                Log.d((String)"DemoKit", (String)"Device closed. ");
            }
            catch (Exception var3) {
                Log.e((String)"DemoKit", (String)("Exception: " + var3.getMessage()));
            }
        }
    }

    public void writeDataImmediately(Vector<Byte> data, int offset, int len) throws IOException {
        try {
            int result = 0;
            Vector<Byte> sendData = new Vector<Byte>();
            for (int i = 0; i < data.size(); ++i) {
                if (sendData.size() >= 1024) {
                    Log.e((String)"TAG", (String)("i = " + i + "\tsendData size -> " + sendData.size() + "\tdata size -> " + data.size()));
                    result += this.usbConnection.bulkTransfer(this.usbEndpointOut, this.convertVectorByteToBytes(sendData), sendData.size(), 1000);
                    sendData.clear();
                    Log.e((String)"TAG", (String)("sendData.clear() size -> " + sendData.size()));
                }
                sendData.add(data.get(i));
            }
            if (sendData.size() > 0) {
                Log.e((String)"TAG", (String)("sendData size -> " + sendData.size()));
                result += this.usbConnection.bulkTransfer(this.usbEndpointOut, this.convertVectorByteToBytes(sendData), sendData.size(), 1000);
            }
            if (result == data.size()) {
                Log.d((String)"TAG", (String)"send success");
            }
        }
        catch (Exception var7) {
            Log.d((String)"TAG", (String)("Exception occured while sending data immediately: " + var7.getMessage()));
        }
    }

    protected byte[] convertVectorByteToBytes(Vector<Byte> data) {
        byte[] sendData = new byte[data.size()];
        if (data.size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                sendData[i] = data.get(i);
            }
        }
        return sendData;
    }

    public void CommandEsc(Esc esc) throws IOException {
        Vector<Byte> data = esc.getCommand();
        USBUtil.getInstance().writeDataImmediately(data, 0, data.size());
    }

    public void CommandLabel(Label label) throws IOException {
        Vector<Byte> data = label.getCommand();
        USBUtil.getInstance().writeDataImmediately(data, 0, data.size());
    }

    private void showToast(String string) {
        if (this.toast != null) {
            this.toast.cancel();
        }
        if (this.context != null) {
            this.toast = Toast.makeText((Context)this.context, (CharSequence)string, (int)0);
            this.toast.show();
        }
    }

    private void startReading() {
        if (this.usbEndpointIn != null) {
            new Thread(new USBReadThread(this.usbEndpointIn, this.usbManager, this.usbConnection, this.context)).start();
        }
    }

    static {
        normal = "normal";
    }
}

