/*
 * Decompiled with CFR 0.152.
 */
package com.brightek.whdrawlabel;

import android.graphics.Bitmap;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.util.EnumMap;
import java.util.Hashtable;

public class CreateBarCode {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;

    public static Bitmap createQRCodeImage(BarcodeFormat type, String url, int width, int height) {
        int w = width;
        int h = height;
        Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        try {
            if (url == null || "".equals(url) || url.length() < 1) {
                return bitmap;
            }
            Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
            hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
            BitMatrix bitMatrix = new QRCodeWriter().encode(url, type, w, h, hints);
            int[] pixels = new int[w * h];
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    pixels[y * w + x] = bitMatrix.get(x, y) ? -16777216 : -1;
                }
            }
            bitmap.setPixels(pixels, 0, w, 0, 0, w, h);
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    public static Bitmap createQRCode(BarcodeFormat type, String str, int mWidth, int mHeight) {
        BitMatrix result;
        String contentsToEncode = str;
        if (contentsToEncode == null) {
            return null;
        }
        EnumMap<EncodeHintType, Object> hints = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
        hints.put(EncodeHintType.CHARACTER_SET, (Object)"UTF-8");
        hints.put(EncodeHintType.MARGIN, (Object)0);
        MultiFormatWriter writer = new MultiFormatWriter();
        try {
            result = writer.encode(contentsToEncode, type, mWidth, mHeight, hints);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        int width = result.getWidth();
        int height = result.getHeight();
        int[] pixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                pixels[offset + x] = result.get(x, y) ? -16777216 : -1;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return bitmap;
    }

    public static Bitmap createQRCodeGBK(BarcodeFormat type, String str, int mWidth, int mHeight) {
        BitMatrix result;
        String contentsToEncode = str;
        if (contentsToEncode == null) {
            return null;
        }
        EnumMap<EncodeHintType, Object> hints = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
        hints.put(EncodeHintType.CHARACTER_SET, (Object)"UTF-8");
        hints.put(EncodeHintType.MARGIN, (Object)0);
        MultiFormatWriter writer = new MultiFormatWriter();
        try {
            result = writer.encode(contentsToEncode, type, mWidth, mHeight, hints);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        int width = result.getWidth();
        int height = result.getHeight();
        int[] pixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                pixels[offset + x] = result.get(x, y) ? -16777216 : -1;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return bitmap;
    }
}

