/*
 * Decompiled with CFR 0.152.
 */
package com.print.usbprint.util;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.os.Environment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GpUtils {
    private static Pattern pattern = Pattern.compile("([a-zA-Z0-9!@#$^&*\\(\\)~\\{\\}:\",\\.<>/]+)");
    private static int[] p0 = new int[]{0, 128};
    private static int[] p1 = new int[]{0, 64};
    private static int[] p2 = new int[]{0, 32};
    private static int[] p3 = new int[]{0, 16};
    private static int[] p4 = new int[]{0, 8};
    private static int[] p5 = new int[]{0, 4};
    private static int[] p6 = new int[]{0, 2};
    private static int[][] Floyd16x16 = new int[][]{{0, 128, 32, 160, 8, 136, 40, 168, 2, 130, 34, 162, 10, 138, 42, 170}, {192, 64, 224, 96, 200, 72, 232, 104, 194, 66, 226, 98, 202, 74, 234, 106}, {48, 176, 16, 144, 56, 184, 24, 152, 50, 178, 18, 146, 58, 186, 26, 154}, {240, 112, 208, 80, 248, 120, 216, 88, 242, 114, 210, 82, 250, 122, 218, 90}, {12, 140, 44, 172, 4, 132, 36, 164, 14, 142, 46, 174, 6, 134, 38, 166}, {204, 76, 236, 108, 196, 68, 228, 100, 206, 78, 238, 110, 198, 70, 230, 102}, {60, 188, 28, 156, 52, 180, 20, 148, 62, 190, 30, 158, 54, 182, 22, 150}, {252, 124, 220, 92, 244, 116, 212, 84, 254, 126, 222, 94, 246, 118, 214, 86}, {3, 131, 35, 163, 11, 139, 43, 171, 1, 129, 33, 161, 9, 137, 41, 169}, {195, 67, 227, 99, 203, 75, 235, 107, 193, 65, 225, 97, 201, 73, 233, 105}, {51, 179, 19, 147, 59, 187, 27, 155, 49, 177, 17, 145, 57, 185, 25, 153}, {243, 115, 211, 83, 251, 123, 219, 91, 241, 113, 209, 81, 249, 121, 217, 89}, {15, 143, 47, 175, 7, 135, 39, 167, 13, 141, 45, 173, 5, 133, 37, 165}, {207, 79, 239, 111, 199, 71, 231, 103, 205, 77, 237, 109, 197, 69, 229, 101}, {63, 191, 31, 159, 55, 183, 23, 151, 61, 189, 29, 157, 53, 181, 21, 149}, {254, 127, 223, 95, 247, 119, 215, 87, 253, 125, 221, 93, 245, 117, 213, 85}};
    private static int[][] Floyd8x8 = new int[][]{{0, 32, 8, 40, 2, 34, 10, 42}, {48, 16, 56, 24, 50, 18, 58, 26}, {12, 44, 4, 36, 14, 46, 6, 38}, {60, 28, 52, 20, 62, 30, 54, 22}, {3, 35, 11, 43, 1, 33, 9, 41}, {51, 19, 59, 27, 49, 17, 57, 25}, {15, 47, 7, 39, 13, 45, 5, 37}, {63, 31, 55, 23, 61, 29, 53, 21}};
    public static final int PAPER_58_WIDTH = 32;
    public static final int PAPER_80_WIDTH = 48;
    private static int sPaperWidth = 48;
    private static Integer[] theSet0 = new Integer[]{1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609, 1610, 17442, 17443, 17445, 17447};
    private static Integer[][] FormatTable = new Integer[][]{{65152, 65152, 65152, 65152}, {65153, 65154, 65153, 65154}, {65155, 65156, 65155, 65156}, {65157, 65157, 65157, 65157}, {65149, 65149, 65149, 65149}, {65163, 65163, 65163, 65163}, {65165, 65166, 65165, 65166}, {65167, 65167, 65169, 65169}, {65171, 65171, 65171, 65171}, {65173, 65173, 65175, 65175}, {65177, 65177, 65179, 65179}, {65181, 65181, 65183, 65183}, {65185, 65185, 65187, 65187}, {65189, 65189, 65191, 65191}, {65193, 65193, 65193, 65193}, {65195, 65195, 65195, 65195}, {65197, 65197, 65197, 65197}, {65199, 65199, 65199, 65199}, {65201, 65201, 65203, 65203}, {65205, 65205, 65207, 65207}, {65209, 65209, 65211, 65211}, {65213, 65213, 65215, 65215}, {65217, 65217, 65217, 65217}, {65221, 65221, 65221, 65221}, {65225, 65226, 65227, 65228}, {65229, 65230, 65231, 65232}, {65233, 65233, 65235, 65235}, {65237, 65237, 65239, 65239}, {65241, 65241, 65243, 65243}, {65245, 65245, 65247, 65247}, {65249, 65249, 65251, 65251}, {65253, 65253, 65255, 65255}, {65257, 65257, 65259, 65259}, {65261, 65261, 65261, 65261}, {65263, 65264, 65263, 65264}, {65265, 65266, 65267, 65267}, {65269, 65270, 65269, 65270}, {65271, 65272, 65271, 65272}, {65273, 65274, 65273, 65274}, {65275, 65276, 65275, 65276}};
    static Integer[] theSet1 = new Integer[]{1574, 1576, 1578, 1579, 1580, 1581, 1582, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 1600, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1610};
    static Integer[] theSet2 = new Integer[]{1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579, 1580, 1581, 1582, 1583, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 1600, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609, 1610};
    public static final int ALGORITHM_DITHER_16x16 = 16;
    public static final int ALGORITHM_DITHER_8x8 = 8;
    public static final int ALGORITHM_TEXTMODE = 2;
    public static final int ALGORITHM_GRAYTEXTMODE = 1;
    public static final int[][] COLOR_PALETTE = new int[][]{new int[3], {255, 255, 255}};
    private static int method = 1;
    public static final int FLOYD_STEINBERG_DITHER = 1;
    public static final int ATKINSON_DITHER = 2;

    public static Bitmap resizeImage(Bitmap bitmap, int w, int h) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float scaleWidth = (float)w / (float)width;
        float scaleHeight = (float)h / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return resizedBitmap;
    }

    public static void saveMyBitmap(Bitmap mBitmap) {
        File f = new File(Environment.getExternalStorageDirectory().getPath(), "Btatotest.jpeg");
        try {
            f.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileOutputStream fOut = null;
        try {
            fOut = new FileOutputStream(f);
            mBitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fOut);
            fOut.flush();
            fOut.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Bitmap toGrayscale(Bitmap bmpOriginal) {
        int height = bmpOriginal.getHeight();
        int width = bmpOriginal.getWidth();
        Bitmap bmpGrayscale = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas c = new Canvas(bmpGrayscale);
        Paint paint = new Paint();
        ColorMatrix cm = new ColorMatrix();
        cm.setSaturation(0.0f);
        ColorMatrixColorFilter f = new ColorMatrixColorFilter(cm);
        paint.setColorFilter((ColorFilter)f);
        c.drawBitmap(bmpOriginal, 0.0f, 0.0f, paint);
        return bmpGrayscale;
    }

    static byte[] pixToEscRastBitImageCmd(byte[] src, int nWidth, int nMode) {
        int nHeight = src.length / nWidth;
        byte[] data = new byte[8 + src.length / 8];
        data[0] = 29;
        data[1] = 118;
        data[2] = 48;
        data[3] = (byte)(nMode & 1);
        data[4] = (byte)(nWidth / 8 % 256);
        data[5] = (byte)(nWidth / 8 / 256);
        data[6] = (byte)(nHeight % 256);
        data[7] = (byte)(nHeight / 256);
        int k = 0;
        for (int i = 8; i < data.length; ++i) {
            data[i] = (byte)(p0[src[k]] + p1[src[k + 1]] + p2[src[k + 2]] + p3[src[k + 3]] + p4[src[k + 4]] + p5[src[k + 5]] + p6[src[k + 6]] + src[k + 7]);
            k += 8;
        }
        return data;
    }

    public static byte[] pixToEscRastBitImageCmd(byte[] src) {
        byte[] data = new byte[src.length / 8];
        int k = 0;
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(p0[src[k]] + p1[src[k + 1]] + p2[src[k + 2]] + p3[src[k + 3]] + p4[src[k + 4]] + p5[src[k + 5]] + p6[src[k + 6]] + src[k + 7]);
            k += 8;
        }
        return data;
    }

    public static byte[] pixToEscNvBitImageCmd(byte[] src, int width, int height) {
        byte[] data = new byte[src.length / 8 + 4];
        data[0] = (byte)(width / 8 % 256);
        data[1] = (byte)(width / 8 / 256);
        data[2] = (byte)(height / 8 % 256);
        data[3] = (byte)(height / 8 / 256);
        for (int i = 0; i < width; ++i) {
            int k = 0;
            for (int j = 0; j < height / 8; ++j) {
                data[4 + j + i * height / 8] = (byte)(p0[src[i + k]] + p1[src[i + k + 1 * width]] + p2[src[i + k + 2 * width]] + p3[src[i + k + 3 * width]] + p4[src[i + k + 4 * width]] + p5[src[i + k + 5 * width]] + p6[src[i + k + 6 * width]] + src[i + k + 7 * width]);
                k += 8 * width;
            }
        }
        return data;
    }

    public static byte[] pixToLabelCmd(byte[] src) {
        byte[] data = new byte[src.length / 8];
        int j = 0;
        for (int k = 0; k < data.length; ++k) {
            byte temp = (byte)(p0[src[j]] + p1[src[j + 1]] + p2[src[j + 2]] + p3[src[j + 3]] + p4[src[j + 4]] + p5[src[j + 5]] + p6[src[j + 6]] + src[j + 7]);
            data[k] = ~temp;
            j += 8;
        }
        return data;
    }

    public static byte[] pixToTscCmd(int x, int y, int mode, byte[] src, int nWidth) {
        int height = src.length / nWidth;
        int width = nWidth / 8;
        String str = "BITMAP " + x + "," + y + "," + width + "," + height + "," + mode + ",";
        byte[] bitmap = null;
        try {
            bitmap = str.getBytes("GB2312");
        }
        catch (UnsupportedEncodingException var13) {
            var13.printStackTrace();
        }
        byte[] arrayOfByte = new byte[src.length / 8];
        int j = 0;
        for (int k = 0; k < arrayOfByte.length; ++k) {
            byte temp = (byte)(p0[src[j]] + p1[src[j + 1]] + p2[src[j + 2]] + p3[src[j + 3]] + p4[src[j + 4]] + p5[src[j + 5]] + p6[src[j + 6]] + src[j + 7]);
            arrayOfByte[k] = ~temp;
            j += 8;
        }
        byte[] data = new byte[bitmap.length + arrayOfByte.length];
        System.arraycopy(bitmap, 0, data, 0, bitmap.length);
        System.arraycopy(arrayOfByte, 0, data, bitmap.length, arrayOfByte.length);
        return data;
    }

    private static void format_K_dither16x16(int[] orgpixels, int xsize, int ysize, byte[] despixels) {
        int k = 0;
        for (int y = 0; y < ysize; ++y) {
            for (int x = 0; x < xsize; ++x) {
                despixels[k] = (orgpixels[k] & 0xFF) > Floyd16x16[x & 0xF][y & 0xF] ? (byte)0 : 1;
                ++k;
            }
        }
    }

    public static byte[] bitmapToBWPix(Bitmap mBitmap) {
        int[] pixels = new int[mBitmap.getWidth() * mBitmap.getHeight()];
        byte[] data = new byte[mBitmap.getWidth() * mBitmap.getHeight()];
        Bitmap grayBitmap = GpUtils.toGrayscale(mBitmap);
        grayBitmap.getPixels(pixels, 0, mBitmap.getWidth(), 0, 0, mBitmap.getWidth(), mBitmap.getHeight());
        GpUtils.format_K_dither16x16(pixels, grayBitmap.getWidth(), grayBitmap.getHeight(), data);
        return data;
    }

    private static void format_K_dither16x16_int(int[] orgpixels, int xsize, int ysize, int[] despixels) {
        int k = 0;
        for (int y = 0; y < ysize; ++y) {
            for (int x = 0; x < xsize; ++x) {
                despixels[k] = (orgpixels[k] & 0xFF) > Floyd16x16[x & 0xF][y & 0xF] ? -1 : -16777216;
                ++k;
            }
        }
    }

    private static void format_K_dither8x8_int(int[] orgpixels, int xsize, int ysize, int[] despixels) {
        int k = 0;
        for (int y = 0; y < ysize; ++y) {
            for (int x = 0; x < xsize; ++x) {
                despixels[k] = (orgpixels[k] & 0xFF) >> 2 > Floyd8x8[x & 7][y & 7] ? -1 : -16777216;
                ++k;
            }
        }
    }

    public static int[] bitmapToBWPix_int(Bitmap mBitmap, int algorithm) {
        int[] pixels = new int[]{};
        switch (algorithm) {
            case 2: {
                break;
            }
            case 8: {
                Bitmap grayBitmap = GpUtils.toGrayscale(mBitmap);
                pixels = new int[grayBitmap.getWidth() * grayBitmap.getHeight()];
                grayBitmap.getPixels(pixels, 0, grayBitmap.getWidth(), 0, 0, grayBitmap.getWidth(), grayBitmap.getHeight());
                GpUtils.format_K_dither8x8_int(pixels, grayBitmap.getWidth(), grayBitmap.getHeight(), pixels);
                break;
            }
            default: {
                Bitmap grayBitmap = GpUtils.toGrayscale(mBitmap);
                pixels = new int[grayBitmap.getWidth() * grayBitmap.getHeight()];
                grayBitmap.getPixels(pixels, 0, grayBitmap.getWidth(), 0, 0, grayBitmap.getWidth(), grayBitmap.getHeight());
                GpUtils.format_K_dither16x16_int(pixels, grayBitmap.getWidth(), grayBitmap.getHeight(), pixels);
            }
        }
        return pixels;
    }

    public static Bitmap toBinaryImage(Bitmap mBitmap, int nWidth, int algorithm) {
        int width = (nWidth + 7) / 8 * 8;
        int height = mBitmap.getHeight() * width / mBitmap.getWidth();
        Bitmap rszBitmap = GpUtils.resizeImage(mBitmap, width, height);
        int[] pixels = GpUtils.bitmapToBWPix_int(rszBitmap, algorithm);
        rszBitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return rszBitmap;
    }

    private static int getCloseColor(int tr, int tg, int tb) {
        int minDistanceSquared = 195076;
        int bestIndex = 0;
        for (int i = 0; i < COLOR_PALETTE.length; ++i) {
            int rdiff = tr - COLOR_PALETTE[i][0];
            int gdiff = tg - COLOR_PALETTE[i][1];
            int bdiff = tb - COLOR_PALETTE[i][2];
            int distanceSquared = rdiff * rdiff + gdiff * gdiff + bdiff * bdiff;
            if (distanceSquared >= minDistanceSquared) continue;
            minDistanceSquared = distanceSquared;
            bestIndex = i;
        }
        return bestIndex;
    }

    private static void setPixel(int[] input, int width, int height, int col, int row, int[] p) {
        if (col < 0 || col >= width) {
            col = 0;
        }
        if (row < 0 || row >= height) {
            row = 0;
        }
        int index = row * width + col;
        input[index] = 0xFF000000 | GpUtils.clamp(p[0]) << 16 | GpUtils.clamp(p[1]) << 8 | GpUtils.clamp(p[2]);
    }

    private static int[] getPixel(int[] input, int width, int height, int col, int row, float error, int[] ergb) {
        if (col < 0 || col >= width) {
            col = 0;
        }
        if (row < 0 || row >= height) {
            row = 0;
        }
        int index = row * width + col;
        int tr = input[index] >> 16 & 0xFF;
        int tg = input[index] >> 8 & 0xFF;
        int tb = input[index] & 0xFF;
        tr = (int)((float)tr + error * (float)ergb[0]);
        tg = (int)((float)tg + error * (float)ergb[1]);
        tb = (int)((float)tb + error * (float)ergb[2]);
        return new int[]{tr, tg, tb};
    }

    public static int clamp(int value) {
        return value > 255 ? 255 : (value < 0 ? 0 : value);
    }

    public static Bitmap filter(Bitmap nbm, int width, int height) {
        int[] inPixels = new int[width * height];
        nbm.getPixels(inPixels, 0, width, 0, 0, width, height);
        int[] outPixels = new int[inPixels.length];
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                int[] rgb6;
                int[] rgb5;
                int[] rgb4;
                float e1;
                int index = row * width + col;
                int r1 = inPixels[index] >> 16 & 0xFF;
                int g1 = inPixels[index] >> 8 & 0xFF;
                int b1 = inPixels[index] & 0xFF;
                int cIndex = GpUtils.getCloseColor(r1, g1, b1);
                outPixels[index] = 0xFF000000 | COLOR_PALETTE[cIndex][0] << 16 | COLOR_PALETTE[cIndex][1] << 8 | COLOR_PALETTE[cIndex][2];
                int[] ergb = new int[]{r1 - COLOR_PALETTE[cIndex][0], g1 - COLOR_PALETTE[cIndex][1], b1 - COLOR_PALETTE[cIndex][2]};
                if (method == 1) {
                    e1 = 0.4375f;
                    float e2 = 0.3125f;
                    float e3 = 0.1875f;
                    float e4 = 0.0625f;
                    rgb4 = GpUtils.getPixel(inPixels, width, height, col + 1, row, e1, ergb);
                    rgb5 = GpUtils.getPixel(inPixels, width, height, col, row + 1, e2, ergb);
                    rgb6 = GpUtils.getPixel(inPixels, width, height, col - 1, row + 1, e3, ergb);
                    GpUtils.setPixel(inPixels, width, height, col + 1, row, rgb4);
                    GpUtils.setPixel(inPixels, width, height, col, row + 1, rgb5);
                    GpUtils.setPixel(inPixels, width, height, col - 1, row + 1, rgb6);
                    GpUtils.setPixel(inPixels, width, height, col + 1, row + 1, rgb4);
                    continue;
                }
                if (method != 2) {
                    throw new IllegalArgumentException("Not Supported Dither Mothed!!");
                }
                e1 = 0.125f;
                int[] rgb1 = GpUtils.getPixel(inPixels, width, height, col + 1, row, e1, ergb);
                int[] rgb2 = GpUtils.getPixel(inPixels, width, height, col + 2, row, e1, ergb);
                int[] rgb3 = GpUtils.getPixel(inPixels, width, height, col - 1, row + 1, e1, ergb);
                rgb4 = GpUtils.getPixel(inPixels, width, height, col, row + 1, e1, ergb);
                rgb5 = GpUtils.getPixel(inPixels, width, height, col + 1, row + 1, e1, ergb);
                rgb6 = GpUtils.getPixel(inPixels, width, height, col, row + 2, e1, ergb);
                GpUtils.setPixel(inPixels, width, height, col + 1, row, rgb1);
                GpUtils.setPixel(inPixels, width, height, col + 2, row, rgb2);
                GpUtils.setPixel(inPixels, width, height, col - 1, row + 1, rgb3);
                GpUtils.setPixel(inPixels, width, height, col, row + 1, rgb4);
                GpUtils.setPixel(inPixels, width, height, col + 1, row + 1, rgb5);
                GpUtils.setPixel(inPixels, width, height, col, row + 2, rgb6);
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int[])outPixels, (int)0, (int)width, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        return bitmap;
    }

    public static byte[] printEscDraw(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        byte[] bitbuf = new byte[width / 8];
        byte[] imgbuf = new byte[width / 8 * height + 8];
        imgbuf[0] = 29;
        imgbuf[1] = 118;
        imgbuf[2] = 48;
        imgbuf[3] = 0;
        imgbuf[4] = (byte)(width / 8);
        imgbuf[5] = 0;
        imgbuf[6] = (byte)(height % 256);
        imgbuf[7] = (byte)(height / 256);
        int s = 7;
        for (int i = 0; i < height; ++i) {
            int k;
            for (k = 0; k < width / 8; ++k) {
                int c0 = bitmap.getPixel(k * 8, i);
                int p0 = c0 != -1 && c0 != 0 ? 1 : 0;
                int c1 = bitmap.getPixel(k * 8 + 1, i);
                int p1 = c1 == -1 ? 0 : 1;
                int c2 = bitmap.getPixel(k * 8 + 2, i);
                int p2 = c2 == -1 ? 0 : 1;
                int c3 = bitmap.getPixel(k * 8 + 3, i);
                int p3 = c3 == -1 ? 0 : 1;
                int c4 = bitmap.getPixel(k * 8 + 4, i);
                int p4 = c4 == -1 ? 0 : 1;
                int c5 = bitmap.getPixel(k * 8 + 5, i);
                int p5 = c5 == -1 ? 0 : 1;
                int c6 = bitmap.getPixel(k * 8 + 6, i);
                int p6 = c6 == -1 ? 0 : 1;
                int c7 = bitmap.getPixel(k * 8 + 7, i);
                int p7 = c7 == -1 ? 0 : 1;
                int value = p0 * 128 + p1 * 64 + p2 * 32 + p3 * 16 + p4 * 8 + p5 * 4 + p6 * 2 + p7;
                bitbuf[k] = (byte)value;
            }
            for (k = 0; k < width / 8; ++k) {
                imgbuf[++s] = bitbuf[k];
            }
        }
        return imgbuf;
    }

    public static byte[] printLabelDraw(Bitmap bitmap) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        int bitw = (w + 7) / 8 * 8;
        int bith = h;
        int pitch = bitw / 8;
        byte[] bits = new byte[bith * pitch];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int color = bitmap.getPixel(x, y);
                if ((color & 0xFF) >= 128) continue;
                int n = y * pitch + x / 8;
                bits[n] = (byte)(bits[n] | 128 >> x % 8);
            }
        }
        return bits;
    }

    public static byte[] printTscDraw(int x, int y, Bitmap bitmap) {
        int s;
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        byte[] bitbuf = new byte[width / 8];
        String str = "BITMAP " + x + "," + y + "," + width / 8 + "," + height + ",0,";
        byte[] strPrint = null;
        try {
            strPrint = str.getBytes("GB2312");
        }
        catch (UnsupportedEncodingException var30) {
            var30.printStackTrace();
        }
        byte[] imgbuf = new byte[width / 8 * height + strPrint.length + 8];
        for (s = 0; s < strPrint.length; ++s) {
            imgbuf[s] = strPrint[s];
        }
        s = strPrint.length - 1;
        for (int i = 0; i < height; ++i) {
            int k;
            for (k = 0; k < width / 8; ++k) {
                int c0 = bitmap.getPixel(k * 8, i);
                int p0 = c0 == -1 ? 1 : 0;
                int c1 = bitmap.getPixel(k * 8 + 1, i);
                int p1 = c1 == -1 ? 1 : 0;
                int c2 = bitmap.getPixel(k * 8 + 2, i);
                int p2 = c2 == -1 ? 1 : 0;
                int c3 = bitmap.getPixel(k * 8 + 3, i);
                int p3 = c3 == -1 ? 1 : 0;
                int c4 = bitmap.getPixel(k * 8 + 4, i);
                int p4 = c4 == -1 ? 1 : 0;
                int c5 = bitmap.getPixel(k * 8 + 5, i);
                int p5 = c5 == -1 ? 1 : 0;
                int c6 = bitmap.getPixel(k * 8 + 6, i);
                int p6 = c6 == -1 ? 1 : 0;
                int c7 = bitmap.getPixel(k * 8 + 7, i);
                int p7 = c7 == -1 ? 1 : 0;
                int value = p0 * 128 + p1 * 64 + p2 * 32 + p3 * 16 + p4 * 8 + p5 * 4 + p6 * 2 + p7;
                bitbuf[k] = (byte)value;
            }
            for (k = 0; k < width / 8; ++k) {
                imgbuf[++s] = bitbuf[k];
            }
        }
        return imgbuf;
    }

    public static String splitArabic(String input) {
        StringBuilder sb = new StringBuilder(256);
        String[] arabics = input.split("\\n");
        if (arabics.length == 1 && arabics[0].length() > sPaperWidth) {
            int lastArabic;
            int i = arabics[0].length() / sPaperWidth;
            int j = 0;
            for (lastArabic = 1; lastArabic <= i; ++lastArabic) {
                sb.append(arabics[0].substring(j, sPaperWidth * lastArabic));
                j += sPaperWidth;
            }
            if (sb.length() >= 0) {
                sb.append('\n');
            }
            lastArabic = arabics[0].length() % sPaperWidth;
            sb.append(arabics[0].substring(arabics[0].length() - lastArabic, arabics[0].length()));
            return GpUtils.splitArabic(sb.toString());
        }
        for (int i = 0; i < arabics.length; ++i) {
            int lastArabic = arabics[i].length();
            if (lastArabic > sPaperWidth) {
                sb.append(GpUtils.splitArabic(arabics[i]));
                continue;
            }
            sb.append(GpUtils.addSpaceAfterArabicString(arabics[i], sPaperWidth - lastArabic));
        }
        return sb.toString();
    }

    static String addSpaceAfterArabicString(String arabic, int number) {
        StringBuilder sb = new StringBuilder(65);
        sb.append(arabic);
        for (int i = 0; i < number; ++i) {
            sb.append(' ');
        }
        sb.append('\n');
        return sb.toString();
    }

    public static String reverseLetterAndNumber(String input) {
        StringBuilder sb = new StringBuilder(input);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            String matcherString = matcher.group();
            int matcherStart = matcher.start();
            int matcherEnd = matcher.end();
            sb.replace(matcherStart, matcherEnd, new StringBuilder(matcherString).reverse().toString());
        }
        return sb.toString();
    }

    public static byte[] string2Cp864(String arabicString) {
        Integer[] originUnicode = new Integer[arabicString.length()];
        Integer[] outputUnicode = new Integer[arabicString.length()];
        Integer[] outputChars = new Integer[originUnicode.length];
        GpUtils.copy(arabicString.toCharArray(), originUnicode, arabicString.length());
        ArrayList<Integer> list1 = new ArrayList<Integer>(Arrays.asList(originUnicode));
        List<Integer> list = GpUtils.Hyphen(list1);
        list = GpUtils.Deformation(list);
        Collections.reverse(list);
        list.toArray(outputUnicode);
        char[] chs = GpUtils.integer2Character(outputUnicode);
        byte[] cp864bytes = new byte[]{};
        try {
            cp864bytes = new String(chs).getBytes("cp864");
        }
        catch (UnsupportedEncodingException var9) {
            var9.printStackTrace();
        }
        return cp864bytes;
    }

    static char[] integer2Character(Integer[] integers) {
        char[] chs = new char[integers.length];
        for (int i = 0; i < integers.length; ++i) {
            if (integers[i] != null) continue;
            chs[i] = 32;
        }
        return chs;
    }

    static void copy(char[] array, Integer[] originUnicode, int length) {
        for (int i = 0; i < length; ++i) {
            originUnicode[i] = array[i];
        }
    }

    static List<Integer> Hyphen(List<Integer> list) {
        block6: for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != 1604) continue;
            switch (list.get(i + 1)) {
                case 1570: {
                    list.set(i, 17442);
                    list.remove(i + 1);
                    continue block6;
                }
                case 1571: {
                    list.set(i, 17443);
                    list.remove(i + 1);
                }
                default: {
                    continue block6;
                }
                case 1573: {
                    list.set(i, 17445);
                    list.remove(i + 1);
                    continue block6;
                }
                case 1575: {
                    list.set(i, 17447);
                    list.remove(i + 1);
                }
            }
        }
        return list;
    }

    static List<Integer> Deformation(List<Integer> inputlist) {
        int i;
        ArrayList<Integer> outputlist = new ArrayList<Integer>();
        HashMap<Integer, Integer[]> formHashTable = new HashMap<Integer, Integer[]>(40);
        for (i = 0; i < 40; ++i) {
            formHashTable.put(theSet0[i], FormatTable[i]);
        }
        for (i = 0; i < inputlist.size(); ++i) {
            if (GpUtils.compare(inputlist.get(i), 0)) {
                int flag;
                boolean inSet2;
                boolean inSet1;
                if (i == 0) {
                    inSet1 = false;
                    inSet2 = GpUtils.compare(inputlist.get(i + 1), 2);
                    flag = GpUtils.Flag(inSet1, inSet2);
                } else if (i == inputlist.size() - 1) {
                    inSet1 = GpUtils.compare(inputlist.get(i - 1), 1);
                    inSet2 = false;
                    flag = GpUtils.Flag(inSet1, inSet2);
                } else {
                    inSet1 = GpUtils.compare(inputlist.get(i - 1), 1);
                    inSet2 = GpUtils.compare(inputlist.get(i + 1), 2);
                    flag = GpUtils.Flag(inSet1, inSet2);
                }
                Integer[] a = (Integer[])formHashTable.get(inputlist.get(i));
                outputlist.add(a[flag]);
                continue;
            }
            outputlist.add(inputlist.get(i));
        }
        return outputlist;
    }

    static boolean compare(Integer input, int i) {
        ArrayList<Integer[]> list = new ArrayList<Integer[]>(3);
        list.add(theSet0);
        list.add(theSet1);
        list.add(theSet2);
        return GpUtils.findInArray((Integer[])list.get(i), input);
    }

    static boolean findInArray(Integer[] integer, int input) {
        for (int j = 0; j < integer.length; ++j) {
            if (integer[j] != input) continue;
            return true;
        }
        return false;
    }

    static int Flag(boolean set1, boolean set2) {
        if (set1 && set2) {
            return 3;
        }
        if (!set1 && set2) {
            return 2;
        }
        return set1 && !set2 ? 1 : 0;
    }

    public static void setPaperWidth(int paperWidth) {
        sPaperWidth = paperWidth;
    }

    public static byte[] ByteTo_byte(Vector<Byte> vector) {
        int len = vector.size();
        byte[] data = new byte[len];
        for (int i = 0; i < len; ++i) {
            data[i] = vector.get(i);
        }
        return data;
    }

    public int getMethod() {
        return method;
    }

    public static void setMethod(int method) {
        GpUtils.method = method;
    }

    public static byte px2Byte(int x, int y, Bitmap bit) {
        if (x < bit.getWidth() && y < bit.getHeight()) {
            int blue;
            int green;
            int pixel = bit.getPixel(x, y);
            int red = (pixel & 0xFF0000) >> 16;
            int gray = GpUtils.RGB2Gray(red, green = (pixel & 0xFF00) >> 8, blue = pixel & 0xFF);
            byte b = gray < 128 ? (byte)1 : 0;
            return b;
        }
        return 0;
    }

    private static int RGB2Gray(int r, int g, int b) {
        int gray = (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
        return gray;
    }
}

