/*
 * Decompiled with CFR 0.152.
 */
package com.print.usbprint.command;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import com.print.usbprint.util.BitmapUtil;
import com.print.usbprint.util.GpUtils;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class Esc {
    private static final String DEBUG_TAG = "EscCommand";
    Vector<Byte> Command = new Vector(4096, 1024);

    public void addArrayToCommand(byte[] array) {
        for (int i = 0; i < array.length; ++i) {
            this.Command.add(array[i]);
        }
    }

    public Vector<Byte> getCommand() {
        return this.Command;
    }

    public void printAdvance() {
        byte[] command = new byte[]{10};
        this.addArrayToCommand(command);
    }

    public void printUnderLine(int a) {
        byte[] command = new byte[]{27, 45, (byte)a};
        this.addArrayToCommand(command);
    }

    public void printHighLight(int a) {
        byte[] command = new byte[]{29, 66, (byte)a};
        this.addArrayToCommand(command);
    }

    public void relinespace() {
        byte[] command = new byte[]{27, 50};
        this.addArrayToCommand(command);
    }

    public void paperStore() {
        byte[] command = new byte[]{16, 4, 1};
        this.addArrayToCommand(command);
    }

    public void cutHalf() {
        byte[] command = new byte[]{27, 109};
        this.addArrayToCommand(command);
    }

    public void cutAll() {
        byte[] command = new byte[]{27, 105};
        this.addArrayToCommand(command);
    }

    public void printSelfTest() {
        byte[] command = new byte[]{18, 84};
        this.addArrayToCommand(command);
    }

    public void reset() {
        byte[] command = new byte[]{27, 64};
        this.addArrayToCommand(command);
    }

    public void formfeedX(int a) {
        byte[] command = new byte[]{27, 74, (byte)a};
        this.addArrayToCommand(command);
    }

    public void formfeedY(int a) {
        byte[] command = new byte[]{27, 100, (byte)a};
        this.addArrayToCommand(command);
    }

    public void lineSpace(int a) {
        byte[] command = new byte[]{27, 51, (byte)a};
        this.addArrayToCommand(command);
    }

    public void printBarCode(String a) {
        byte[] command = new byte[]{29, 107, 73, (byte)a.length()};
        this.addArrayToCommand(command);
        this.addStrToCommand(a, command[3]);
    }

    public void printBarCodeHeight(int a) {
        byte[] command = new byte[]{29, 104, (byte)a};
        this.addArrayToCommand(command);
    }

    public void printBarCodeWidth(int a) {
        byte[] command = new byte[]{29, 119, (byte)a};
        this.addArrayToCommand(command);
    }

    public void barCodeSite(int a) {
        byte[] command = new byte[]{29, 72, (byte)a};
        this.addArrayToCommand(command);
    }

    public void align(int a) {
        byte[] command = new byte[]{27, 97, (byte)a};
        this.addArrayToCommand(command);
    }

    public static String toFullBinaryString(int num) {
        char[] chs = new char[4];
        for (int i = 0; i < 4; ++i) {
            chs[3 - i] = (char)((num >> i & 1) + 48);
        }
        return String.valueOf(chs);
    }

    public void textFont(int a, int b) {
        String width = Esc.toFullBinaryString(a);
        String height = Esc.toFullBinaryString(b);
        String font = width + height;
        int f = Integer.parseInt(font, 2);
        byte[] command = new byte[]{29, 33, (byte)f};
        this.addArrayToCommand(command);
    }

    public void textType(int font, int repudiation, int inversion, int bold, int timesHigh, int timesWider, int underline) {
        String type = "0" + Integer.toBinaryString(underline) + Integer.toBinaryString(timesWider) + Integer.toBinaryString(timesHigh) + Integer.toBinaryString(bold) + Integer.toBinaryString(inversion) + Integer.toBinaryString(repudiation) + Integer.toBinaryString(font);
        int t = Integer.parseInt(type, 2);
        byte[] command = new byte[]{27, 33, (byte)t};
        this.addArrayToCommand(command);
    }

    public void printText(String a) {
        this.addStrToCommand(a);
    }

    public void printBitmapHorizontal(Bitmap a, int b, int c) {
        if (a != null) {
            int width = (b + 7) / 8 * 8;
            int height = a.getHeight() * width / a.getWidth();
            Bitmap grayBitmap = GpUtils.toGrayscale(a);
            Bitmap rszBitmap = GpUtils.resizeImage(grayBitmap, width, height);
            byte[] src = GpUtils.bitmapToBWPix(rszBitmap);
            byte[] command = new byte[8];
            height = src.length / width;
            command[0] = 29;
            command[1] = 118;
            command[2] = 48;
            command[3] = (byte)c;
            command[4] = (byte)(width / 8 % 256);
            command[5] = (byte)(width / 8 / 256);
            command[6] = (byte)(height % 256);
            command[7] = (byte)(height / 256);
            this.addArrayToCommand(command);
            byte[] codecontent = GpUtils.pixToEscRastBitImageCmd(src);
            for (int k = 0; k < codecontent.length; ++k) {
                this.Command.add(codecontent[k]);
            }
        } else {
            Log.d((String)"BMP", (String)"bmp.  null ");
        }
    }

    public void createQR(String a) {
        byte[] command = new byte[]{29, 40, 107, (byte)((a.getBytes().length + 3) % 256), (byte)((a.getBytes().length + 3) / 256), 49, 80, 48};
        this.addArrayToCommand(command);
        byte[] bs = null;
        if (!a.equals("")) {
            try {
                bs = a.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException var5) {
                var5.printStackTrace();
            }
            for (int i = 0; i < bs.length; ++i) {
                this.Command.add(bs[i]);
            }
        }
    }

    public void printQR() {
        byte[] command = new byte[]{29, 40, 107, 3, 0, 49, 81, 48};
        this.addArrayToCommand(command);
    }

    public void inquirePrintHeight() {
        byte[] command = new byte[]{31, 45, 71, 1, 0};
        this.addArrayToCommand(command);
    }

    public void AARPaper() {
        byte[] command = new byte[]{31, 45, 96, 1, 0};
        this.addArrayToCommand(command);
    }

    private void addStrToCommand(String str) {
        byte[] bs = null;
        if (!str.equals("")) {
            try {
                bs = str.getBytes("GB2312");
            }
            catch (UnsupportedEncodingException var4) {
                var4.printStackTrace();
            }
            for (int i = 0; i < bs.length; ++i) {
                this.Command.add(bs[i]);
            }
        }
    }

    private void addStrToCommand(String str, String charset) {
        byte[] bs = null;
        if (!str.equals("")) {
            try {
                bs = str.getBytes("GB2312");
            }
            catch (UnsupportedEncodingException var5) {
                var5.printStackTrace();
            }
            for (int i = 0; i < bs.length; ++i) {
                this.Command.add(bs[i]);
            }
        }
    }

    private void addStrToCommand(String str, int length) {
        byte[] bs = null;
        if (!str.equals("")) {
            try {
                bs = str.getBytes("GB2312");
            }
            catch (UnsupportedEncodingException var5) {
                var5.printStackTrace();
            }
            Log.d((String)DEBUG_TAG, (String)("bs.length" + bs.length));
            if (length > bs.length) {
                length = bs.length;
            }
            Log.d((String)DEBUG_TAG, (String)("length" + length));
            for (int i = 0; i < length; ++i) {
                this.Command.add(bs[i]);
            }
        }
    }

    public void switchESC() {
        byte[] bytes = new byte[]{31, 47, 11, 0, 1, 0, 0};
        this.addArrayToCommand(bytes);
    }

    public void factorySetting() {
        byte[] bytes = new byte[]{31, 45, 82, 0};
        this.addArrayToCommand(bytes);
    }

    public void rename(String string) {
        byte[] bs = null;
        if (!string.equals("")) {
            try {
                bs = string.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException var5) {
                var5.printStackTrace();
            }
            byte[] bytes = new byte[]{31, 45, 48, (byte)bs.length};
            this.addArrayToCommand(bytes);
            for (int i = 0; i < bs.length; ++i) {
                this.Command.add(bs[i]);
            }
        }
    }

    public void heatUp(int time) {
        int xL = this.GetL(time);
        int xH = this.GetH(time);
        byte[] bytes = new byte[]{31, 45, 49, 2, (byte)xL, (byte)xH};
        this.addArrayToCommand(bytes);
    }

    public void intervalHeatUp(int time) {
        int xL = this.GetL(time);
        int xH = this.GetH(time);
        byte[] bytes = new byte[]{31, 45, 50, 2, (byte)xL, (byte)xH};
        this.addArrayToCommand(bytes);
    }

    public void heatPoints(int points) {
        int xL = this.GetL(points);
        int xH = this.GetH(points);
        byte[] bytes = new byte[]{31, 45, 51, 2, (byte)xL, (byte)xH};
        this.addArrayToCommand(bytes);
    }

    public void fromFeed(int a, int b, int time) {
        int xL = this.GetL(time);
        int xH = this.GetH(time);
        byte[] bytes = new byte[]{31, 45, 53, 4, (byte)a, (byte)b, (byte)xL, (byte)xH};
        this.addArrayToCommand(bytes);
    }

    public void fromFeedLine(int line) {
        int xL = this.GetL(line);
        int xH = this.GetH(line);
        byte[] bytes = new byte[]{31, 45, 65, 2, (byte)xL, (byte)xH};
        this.addArrayToCommand(bytes);
    }

    public void cutter(int m, int n) {
        int xL = this.GetL(m);
        int xH = this.GetH(m);
        int yL = this.GetL(n);
        int yH = this.GetH(n);
        byte[] bytes = new byte[]{31, 45, 68, 4, (byte)xL, (byte)xH, (byte)yL, (byte)yH};
        this.addArrayToCommand(bytes);
    }

    public void initID(int PID, int VID) {
        int xL = this.GetL(PID);
        int xH = this.GetH(PID);
        int yL = this.GetL(VID);
        int yH = this.GetH(VID);
        byte[] bytes = new byte[]{31, 45, 100, 4, (byte)xL, (byte)xH, (byte)yL, (byte)yH};
        this.addArrayToCommand(bytes);
    }

    private int GetL(int a) {
        int b = a % 256;
        return b;
    }

    private int GetH(int a) {
        int b = a / 256;
        return b;
    }

    public void printTextBitmap(String string, Context context, int width, int mode) {
        Bitmap bitmap = BitmapUtil.StringToBitmap(context, string, width);
        this.printBitmapHorizontal(bitmap, width, mode);
    }

    public void QRSize(int a) {
        byte[] bytes = new byte[]{29, 40, 107, 3, 0, 49, 67, (byte)a};
        this.addArrayToCommand(bytes);
    }

    public void printBarCode(int m, String string) {
        byte[] Command = new byte[]{29, 107, (byte)m, (byte)string.length()};
        this.addArrayToCommand(Command);
        this.addStrToCommand(string, Command[3]);
    }

    public void clear() {
        this.Command.clear();
    }

    public void paper() {
        byte[] bytes = new byte[]{16, 4, 1};
        this.addArrayToCommand(bytes);
    }

    public void paperWillRunOut() {
        byte[] bytes = new byte[]{16, 5, 1};
        this.addArrayToCommand(bytes);
    }

    public void checkTemperatureState() {
        byte[] bytes = new byte[]{16, 6, 1};
        this.addArrayToCommand(bytes);
    }

    public void checkCutterState() {
        byte[] bytes = new byte[]{16, 7, 1};
        this.addArrayToCommand(bytes);
    }

    public void checkRubberRollerState() {
        byte[] bytes = new byte[]{16, 8, 1};
        this.addArrayToCommand(bytes);
    }

    public void checkPaperJamState() {
        byte[] bytes = new byte[]{16, 9, 1};
        this.addArrayToCommand(bytes);
    }

    public void getTemperatureValue() {
        byte[] bytes = new byte[]{16, 10, 1};
        this.addArrayToCommand(bytes);
    }

    public void getVoltageValue() {
        byte[] bytes = new byte[]{16, 11, 1};
        this.addArrayToCommand(bytes);
    }

    public void checkVoltageState() {
        byte[] bytes = new byte[]{16, 12, 1};
        this.addArrayToCommand(bytes);
    }

    public void checkBluetoothState() {
        byte[] bytes = new byte[]{16, 13, 1};
        this.addArrayToCommand(bytes);
    }

    public void getPrintedPaperCountOfTicket() {
        byte[] bytes = new byte[]{16, 15, 1};
        this.addArrayToCommand(bytes);
    }

    public void resetPaperStateOrCutter() {
        byte[] bytes = new byte[]{17, 4, 1};
        this.addArrayToCommand(bytes);
    }

    public void resetCutter() {
        byte[] bytes = new byte[]{17, 5, 1};
        this.addArrayToCommand(bytes);
    }
}

