/*
 * Decompiled with CFR 0.152.
 */
package io.fotoapparat.facedetector;

import android.content.Context;
import io.fotoapparat.facedetector.AssetsExtractor;
import io.fotoapparat.facedetector.FaceDetectorWrapper;
import io.fotoapparat.facedetector.Rectangle;
import java.util.List;

public class FaceDetector {
    private final AssetsExtractor assetsExtractor;
    private FaceDetectorWrapper faceDetectorWrapper = null;

    private FaceDetector(AssetsExtractor assetsExtractor) {
        this.assetsExtractor = assetsExtractor;
    }

    public static FaceDetector create(Context context) {
        return new FaceDetector(new AssetsExtractor(context, "faceDetectorCascade.xml"));
    }

    public List<Rectangle> detectFaces(byte[] nv21Image, int frameWidth, int frameHeight, int frameRotationDegrees) {
        this.ensureInitialized();
        return this.faceDetectorWrapper.detectFaces(nv21Image, frameWidth, frameHeight, frameRotationDegrees);
    }

    private void ensureInitialized() {
        if (this.faceDetectorWrapper == null) {
            this.faceDetectorWrapper = FaceDetectorWrapper.create(this.assetsExtractor.extractIfNeeded().getPath());
        }
    }

    static {
        System.loadLibrary("FaceDetector_android");
    }
}

