/*
 * Decompiled with CFR 0.152.
 */
package com.lztek.toolkit;

import android.content.Context;
import android.graphics.Bitmap;
import com.implus.api.ImplusApi;
import com.implus.api.NativeLib;
import com.lztek.toolkit.AddrInfo;
import com.lztek.toolkit.SerialPort;
import java.util.Date;

public final class Lztek {
    private final ImplusApi mImplusApi;

    Lztek(Context context) {
        this.mImplusApi = NativeLib.load((Context)context, null);
        if (this.mImplusApi == null) {
            throw new NullPointerException("Cannot load manager");
        }
    }

    public static Lztek create(Context context) {
        return new Lztek(context);
    }

    public String getApiVersion() {
        return this.mImplusApi.getApiVersion();
    }

    public String getSystemVersion() {
        return this.mImplusApi.getSystemVersion();
    }

    public String getKernelVersion() {
        return this.mImplusApi.getKernelVersion();
    }

    public boolean getEthEnable() {
        return this.mImplusApi.getEthEnable();
    }

    public void setEthEnable(boolean enable) {
        this.mImplusApi.setEthEnable(enable);
    }

    public String getEthMac() {
        return this.mImplusApi.getEthMac();
    }

    public AddrInfo getEthAddrInfo() {
        return Lztek.convertAddrInfo(this.mImplusApi.getEthAddrInfo());
    }

    public void setEthIpAddress(String ip, String netmask, String gateway, String dns) {
        this.mImplusApi.setEthIpAddress(ip, netmask, gateway, dns, null);
    }

    public void setEthDhcpMode() {
        this.mImplusApi.setEthDhcpMode();
    }

    public AddrInfo getMobileAddrInfo() {
        return Lztek.convertAddrInfo(this.mImplusApi.getMobileAddrInfo());
    }

    private static AddrInfo convertAddrInfo(com.implus.api.AddrInfo obj) {
        if (obj == null) {
            return null;
        }
        AddrInfo addrInfo = new AddrInfo();
        addrInfo.setIpMode(obj.getIpMode() == 0 ? 0 : (obj.getIpMode() == 1 ? 1 : obj.getIpMode()));
        addrInfo.setIpAddress(obj.getIpAddress());
        addrInfo.setNetmask(obj.getNetmask());
        addrInfo.setGateway(obj.getGateway());
        addrInfo.setDns(obj.getDns1());
        return addrInfo;
    }

    public String getInternalStoragePath() {
        return this.mImplusApi.getInternalStoragePath();
    }

    public String getStorageCardPath() {
        return this.mImplusApi.getStorageCardPath();
    }

    public String getUsbStoragePath() {
        return this.mImplusApi.getUsbStoragePath();
    }

    public long getSystemMemory() {
        return this.mImplusApi.getSystemMemory();
    }

    public void setLcdBackLight(boolean on) {
        this.mImplusApi.setLcdBackLight(on);
    }

    public void setSystemTime(long milliseconds1970) {
        this.mImplusApi.setSystemTime(milliseconds1970);
    }

    public void setSystemTime(Date dateTime) {
        this.mImplusApi.setSystemTime(dateTime.getTime());
    }

    public boolean gpioEnable(int port) {
        return this.mImplusApi.gpioEnable(port);
    }

    public void setGpioInputMode(int port) {
        this.mImplusApi.setGpioInputMode(port);
    }

    public void setGpioOutputMode(int port) {
        this.mImplusApi.setGpioOutputMode(port);
    }

    public int getGpioValue(int port) {
        return this.mImplusApi.getGpioValue(port);
    }

    public void setGpioValue(int port, int value) {
        this.mImplusApi.setGpioValue(port, value);
    }

    public SerialPort openSerialPort(String path, int baudrate, int dataBit, int parity, int stopBits, int dataFlow) {
        com.implus.api.SerialPort port = this.mImplusApi.openSerialPort(path, baudrate, dataBit, parity, stopBits, dataFlow);
        return port == null ? null : new SerialPort(port);
    }

    public SerialPort openSerialPort(String path, int baudrate) {
        return this.openSerialPort(path, baudrate, 8, 0, 1, 0);
    }

    public boolean watchDogEnable() {
        return this.mImplusApi.watchDogEnable();
    }

    public boolean watchDogDisable() {
        return this.mImplusApi.watchDogDisable();
    }

    public boolean watchDogFeed() {
        return this.mImplusApi.watchDogFeed();
    }

    public Bitmap screenCapture() {
        return this.mImplusApi.screenCapture();
    }

    public void screenCapture(String path) {
        this.mImplusApi.screenCapture(path);
    }

    public int getDisplayDensity() {
        return this.mImplusApi.getDisplayDensity();
    }

    public void setDisplayDensity(int density) {
        this.mImplusApi.setDisplayDensity(density);
    }

    public void showNavigationBar() {
        this.mImplusApi.showNavigationBar();
    }

    public void hideNavigationBar() {
        this.mImplusApi.hideNavigationBar();
    }

    public void navigationBarSlideShow(boolean enable) {
        this.mImplusApi.statusbarSlideShow(enable);
    }

    public void navigationBarMaxIdle(int seconds) {
        this.mImplusApi.statusbarMaxIdle(seconds);
    }

    public void installApplication(String apkPath) {
        this.mImplusApi.installApplication(apkPath);
    }

    public void uninstallApplication(String packageName) {
        this.mImplusApi.uninstallApplication(packageName, false);
    }

    public void updateSystem(String updateFilePath) {
        this.mImplusApi.updateSystem(updateFilePath);
    }

    public void hardShutdown() {
        this.mImplusApi.hardShutdown();
    }

    public void softReboot() {
        this.mImplusApi.softReboot();
    }

    public void hardReboot() {
        this.mImplusApi.hardReboot();
    }

    public void alarmPoweron(int onSeconds) {
        this.mImplusApi.alarmPoweron(onSeconds);
    }

    public void suExec(String command) {
        this.mImplusApi.suExec(command);
    }

    public int getHdmiinStatus() {
        return this.mImplusApi.getHdmiinStatus();
    }

    public int getHdmiinResolution() {
        return this.mImplusApi.getHdmiinResolution();
    }
}

