/*
 * Decompiled with CFR 0.152.
 */
package com.print.usbprint.command;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import com.print.usbprint.util.BitmapUtil;
import com.print.usbprint.util.GpUtils;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class Label {
    private byte[] end = new byte[]{0};
    Vector<Byte> Command = new Vector();

    public void addArrayToCommand(byte[] array) {
        for (int i = 0; i < array.length; ++i) {
            this.Command.add(array[i]);
        }
    }

    public Vector<Byte> getCommand() {
        return this.Command;
    }

    public void clear() {
        this.Command.clear();
    }

    public void addStrToCommand(String str, String encode) {
        byte[] bs = null;
        if (!str.equals("")) {
            try {
                bs = str.getBytes(encode);
            }
            catch (UnsupportedEncodingException var5) {
                var5.printStackTrace();
            }
            for (int i = 0; i < bs.length; ++i) {
                this.Command.add(bs[i]);
            }
        }
    }

    private int Transformation(int a) {
        String b = Integer.toHexString(a);
        Integer c = Integer.valueOf(b);
        return c;
    }

    private int GetL(int a) {
        int b = a % 256;
        return b;
    }

    private int GetH(int a) {
        int b = a / 256;
        return b;
    }

    private int conversion(int a) {
        int b = Integer.parseInt(String.valueOf(a), 16);
        return b;
    }

    public void reset() {
        byte[] reset = new byte[]{27, 64};
        this.addArrayToCommand(reset);
    }

    public void customPageStart(int pagewidth, int pageheight, int Rotate) {
        int widthxL = this.GetL(pagewidth);
        int widthxH = this.GetH(pagewidth);
        int heightxL = this.GetL(pageheight);
        int heightxH = this.GetH(pageheight);
        byte[] pagestart = new byte[]{26, 91, 1, 0, 0, 0, 0, (byte)widthxL, (byte)widthxH, (byte)heightxL, (byte)heightxH, (byte)Rotate};
        this.addArrayToCommand(pagestart);
    }

    public void defaultPageStart() {
        byte[] pagestart = new byte[]{26, 91, 0};
        this.addArrayToCommand(pagestart);
    }

    public void pageEnd() {
        byte[] pageend = new byte[]{26, 93, 0};
        this.addArrayToCommand(pageend);
    }

    public void customPrintPage(int number) {
        byte[] print = new byte[]{26, 79, 1, (byte)number};
        this.addArrayToCommand(print);
    }

    public void defaultPrintPage() {
        byte[] print = new byte[]{26, 79, 0};
        this.addArrayToCommand(print);
    }

    public void defaultPageOut() {
        byte[] pageout = new byte[]{26, 12, 0};
        this.addArrayToCommand(pageout);
    }

    public void customPageOut(int StopPosition, int Offset) {
        int offsetL = this.GetL(Offset);
        int offsetH = this.GetH(Offset);
        byte[] pageout = new byte[]{26, 12, 1, (byte)StopPosition, (byte)offsetL, (byte)offsetH};
        this.addArrayToCommand(pageout);
    }

    public void defaultPrintText(String string, int x, int y) {
        int xL = this.GetL(x);
        int xH = this.GetH(x);
        int yL = this.GetL(y);
        int yH = this.GetH(y);
        byte[] printtext = new byte[]{26, 84, 0, (byte)xL, (byte)xH, (byte)yL, (byte)yH};
        this.addArrayToCommand(printtext);
        this.addStrToCommand(string, "GBK");
        this.addArrayToCommand(this.end);
    }

    public void customPrintText(String string, int x, int y, int FontHeight, int bold, int underline, int include, int deleteline, int rotate, int widthtype, int heighttype) {
        int xL = this.GetL(x);
        int xH = this.GetH(x);
        int yL = this.GetL(y);
        int yH = this.GetH(y);
        int fontheightL = this.GetL(FontHeight);
        int fontheightH = this.GetH(FontHeight);
        String Bold = String.valueOf(bold);
        String UnderLine = String.valueOf(underline);
        String Include = String.valueOf(include);
        String DeleteLine = String.valueOf(deleteline);
        String Rotate = rotate == 1 ? "01" : (rotate == 2 ? "10" : (rotate == 3 ? "11" : "00"));
        String se = "00";
        String L = se + Rotate + DeleteLine + Include + UnderLine + Bold;
        String width = this.function(widthtype);
        String height = this.function(heighttype);
        if (width.length() < 4) {
            if (width.length() == 1) {
                width = "000" + width;
            } else if (width.length() == 2) {
                width = "00" + width;
            } else if (width.length() == 3) {
                width = "0" + width;
            }
        }
        if (height.length() < 4) {
            if (height.length() == 1) {
                height = "000" + height;
            } else if (height.length() == 2) {
                height = "00" + height;
            } else if (height.length() == 1) {
                height = "0" + height;
            }
        }
        String H = height + width;
        int fonttypeL = Integer.parseInt(L, 2);
        int fonttypeH = Integer.parseInt(H, 2);
        byte[] printtext = new byte[]{26, 84, 1, (byte)xL, (byte)xH, (byte)yL, (byte)yH, (byte)fontheightL, (byte)fontheightH, (byte)fonttypeL, (byte)fonttypeH};
        this.addArrayToCommand(printtext);
        this.addStrToCommand(string, "GBK");
        this.addArrayToCommand(this.end);
    }

    public void defaultPrintLine(int StartX, int StartY, int EndX, int EndY) {
        int StartXL = this.GetL(StartX);
        int StartXH = this.GetH(StartX);
        int StartYL = this.GetL(StartY);
        int StartYH = this.GetH(StartY);
        int EndXL = this.GetL(EndX);
        int EndXH = this.GetH(EndX);
        int EndYL = this.GetL(EndY);
        int EndYH = this.GetH(EndY);
        byte[] printline = new byte[]{26, 92, 0, (byte)StartXL, (byte)StartXH, (byte)StartYL, (byte)StartYH, (byte)EndXL, (byte)EndXH, (byte)EndYL, (byte)EndYH};
        this.addArrayToCommand(printline);
    }

    public void customPrintLine(int StartX, int StartY, int EndX, int EndY, int Width, int Color) {
        int StartXL = this.GetL(StartX);
        int StartXH = this.GetH(StartX);
        int StartYL = this.GetL(StartY);
        int StartYH = this.GetH(StartY);
        int EndXL = this.GetL(EndX);
        int EndXH = this.GetH(EndX);
        int EndYL = this.GetL(EndY);
        int EndYH = this.GetH(EndY);
        int WidthL = this.GetL(Width);
        int WidthH = this.GetH(Width);
        byte[] printline = new byte[]{26, 92, 1, (byte)StartXL, (byte)StartXH, (byte)StartYL, (byte)StartYH, (byte)EndXL, (byte)EndXH, (byte)EndYL, (byte)EndYH, (byte)WidthL, (byte)WidthH, (byte)Color};
        this.addArrayToCommand(printline);
    }

    public void defaultPrintRectangle(int Left, int Top, int Right, int Bottom) {
        int leftL = this.GetL(Left);
        int leftH = this.GetH(Left);
        int topL = this.GetL(Top);
        int topH = this.GetH(Top);
        int rightL = this.GetL(Right);
        int rightH = this.GetH(Right);
        int bottomL = this.GetL(Bottom);
        int bottomH = this.GetH(Bottom);
        byte[] printrectangle = new byte[]{26, 38, 0, (byte)leftL, (byte)leftH, (byte)topL, (byte)topH, (byte)rightL, (byte)rightH, (byte)bottomL, (byte)bottomH};
        this.addArrayToCommand(printrectangle);
    }

    public void customPrintRectangle(int Left, int Top, int Right, int Bottom, int Width, int Color) {
        int leftL = this.GetL(Left);
        int leftH = this.GetH(Left);
        int topL = this.GetL(Top);
        int topH = this.GetH(Top);
        int rightL = this.GetL(Right);
        int rightH = this.GetH(Right);
        int bottomL = this.GetL(Bottom);
        int bottomH = this.GetH(Bottom);
        int widthL = this.GetL(Width);
        int widthH = this.GetH(Width);
        byte[] printrectangle = new byte[]{26, 38, 1, (byte)leftL, (byte)leftH, (byte)topL, (byte)topH, (byte)rightL, (byte)rightH, (byte)bottomL, (byte)bottomH, (byte)widthL, (byte)widthH, (byte)Color};
        this.addArrayToCommand(printrectangle);
    }

    public void printRectangularBlock(int Left, int Top, int Right, int Bottom, int Color) {
        int leftL = this.GetL(Left);
        int leftH = this.GetH(Left);
        int topL = this.GetL(Top);
        int topH = this.GetH(Top);
        int rightL = this.GetL(Right);
        int rightH = this.GetH(Right);
        int bottomL = this.GetL(Bottom);
        int bottomH = this.GetH(Bottom);
        byte[] printrectangularblock = new byte[]{26, 38, 0, (byte)leftL, (byte)leftH, (byte)topL, (byte)topH, (byte)rightL, (byte)rightH, (byte)bottomL, (byte)bottomH, (byte)Color};
        this.addArrayToCommand(printrectangularblock);
    }

    public void printBarcode(String string, int x, int y, int BarcodeType, int BarcodeHeight, int UnitWidth, int Rotate) {
        int xL = this.GetL(x);
        int xH = this.GetH(x);
        int yL = this.GetL(y);
        int yH = this.GetH(y);
        byte[] printbarcode = new byte[]{26, 48, 0, (byte)xL, (byte)xH, (byte)yL, (byte)yH, (byte)BarcodeType, (byte)BarcodeHeight, (byte)UnitWidth, (byte)Rotate};
        this.addArrayToCommand(printbarcode);
        this.addStrToCommand(string, "GBK");
        this.addArrayToCommand(this.end);
    }

    public void printQRcode(String string, int version, int ECC, int x, int y, int UnitWidth, int Rotate) {
        int xL = this.GetL(x);
        int xH = this.GetH(x);
        int yL = this.GetL(y);
        int yH = this.GetH(y);
        byte[] printQRcode = new byte[]{26, 49, 0, (byte)version, (byte)ECC, (byte)xL, (byte)xH, (byte)yL, (byte)yH, (byte)UnitWidth, (byte)Rotate};
        this.addArrayToCommand(printQRcode);
        this.addStrToCommand(string, "UTF-8");
        this.addArrayToCommand(this.end);
    }

    public void printPDF417(String string, int ColorNum, int ECC, int LWRatio, int x, int y, int UnitWidth, int Rotate) {
        int xL = this.GetL(x);
        int xH = this.GetH(x);
        int yL = this.GetL(y);
        int yH = this.GetH(y);
        byte[] printPDF417 = new byte[]{26, 49, 1, (byte)ColorNum, (byte)ECC, (byte)LWRatio, (byte)xL, (byte)xH, (byte)yL, (byte)yH, (byte)UnitWidth, (byte)Rotate};
        this.addArrayToCommand(printPDF417);
        this.addStrToCommand(string, "UTF-8");
        this.addArrayToCommand(this.end);
    }

    public void defaultPrintBitmap(Bitmap bitmap, int x, int y, int Width, int Hegiht) {
        int xL = this.GetL(x);
        int xH = this.GetH(x);
        int yL = this.GetL(y);
        int yH = this.GetH(y);
        int widthL = this.GetL(Width);
        int widthH = this.GetH(Width);
        int heightL = this.GetL(Hegiht);
        int heightH = this.GetH(Hegiht);
        byte[] printbitmap = new byte[]{26, 33, 0, (byte)xL, (byte)xH, (byte)yL, (byte)yH, (byte)widthL, (byte)widthH, (byte)heightL, (byte)heightH};
        this.addArrayToCommand(printbitmap);
        Bitmap rszBitmap = GpUtils.resizeImage(bitmap, Width, Hegiht);
        byte[] bytes = GpUtils.printLabelDraw(rszBitmap);
        for (int i = 0; i < bytes.length; ++i) {
            this.Command.add(bytes[i]);
        }
        byte[] bs = new byte[]{0};
        this.addArrayToCommand(bs);
    }

    public void customPrintBitmap(Bitmap bitmap, int x, int y, int Width, int Hegiht, int include, int rotate, int widthtype, int heighttype) {
        int xL = this.GetL(x);
        int xH = this.GetH(x);
        int yL = this.GetL(y);
        int yH = this.GetH(y);
        int widthL = this.GetL(Width);
        int widthH = this.GetH(Width);
        int heightL = this.GetL(Hegiht);
        int heightH = this.GetH(Hegiht);
        String Include = String.valueOf(include);
        String Rotate = rotate == 1 ? "01" : (rotate == 2 ? "10" : (rotate == 3 ? "11" : "00"));
        String s1 = "00000";
        s1 = s1 + Rotate + Include;
        String width = this.function(widthtype);
        String height = this.function(heighttype);
        if (width.length() < 4) {
            if (width.length() == 1) {
                width = "000" + width;
            } else if (width.length() == 2) {
                width = "00" + width;
            } else if (width.length() == 3) {
                width = "0" + width;
            }
        }
        if (height.length() < 4) {
            if (height.length() == 1) {
                height = "000" + height;
            } else if (height.length() == 2) {
                height = "00" + height;
            } else if (height.length() == 1) {
                height = "0" + height;
            }
        }
        String s2 = height + width;
        int ShowType1 = Integer.parseInt(s1, 2);
        int ShowType2 = Integer.parseInt(s2, 2);
        byte[] printbitmap = new byte[]{26, 33, 1, (byte)xL, (byte)xH, (byte)yL, (byte)yH, (byte)widthL, (byte)widthH, (byte)heightL, (byte)heightH, (byte)ShowType1, (byte)ShowType2};
        this.addArrayToCommand(printbitmap);
        Bitmap rszBitmap = GpUtils.resizeImage(bitmap, Width, Hegiht);
        byte[] bytes = GpUtils.printLabelDraw(rszBitmap);
        for (int i = 0; i < bytes.length; ++i) {
            this.Command.add(bytes[i]);
        }
        byte[] bs = new byte[]{0};
        this.addArrayToCommand(bs);
    }

    public Bitmap getNewBitmap(Bitmap bitmap, int newWidth, int newHeight) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return newBitmap;
    }

    public String function(int n) {
        String result = Integer.toBinaryString(n);
        return result;
    }

    public void switchLabel() {
        byte[] bytes = new byte[]{31, 47, 11, 0, 1, 1, 1};
        this.addArrayToCommand(bytes);
    }

    public void factorySetting() {
        byte[] bytes = new byte[]{31, 45, 82, 0};
        this.addArrayToCommand(bytes);
    }

    public void rename(String string) {
        byte[] bs = null;
        if (!string.equals("")) {
            try {
                bs = string.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException var5) {
                var5.printStackTrace();
            }
            byte[] bytes = new byte[]{31, 45, 48, (byte)bs.length};
            this.addArrayToCommand(bytes);
            for (int i = 0; i < bs.length; ++i) {
                this.Command.add(bs[i]);
            }
        }
    }

    public void heatUp(int time) {
        int xL = this.GetL(time);
        int xH = this.GetH(time);
        byte[] bytes = new byte[]{31, 45, 49, 2, (byte)xL, (byte)xH};
        this.addArrayToCommand(bytes);
    }

    public void intervalHeatUp(int time) {
        int xL = this.GetL(time);
        int xH = this.GetH(time);
        byte[] bytes = new byte[]{31, 45, 50, 2, (byte)xL, (byte)xH};
        this.addArrayToCommand(bytes);
    }

    public void heatPoints(int points) {
        int xL = this.GetL(points);
        int xH = this.GetH(points);
        byte[] bytes = new byte[]{31, 45, 51, 2, (byte)xL, (byte)xH};
        this.addArrayToCommand(bytes);
    }

    public void fromFeed(int a, int b, int time) {
        int xL = this.GetL(time);
        int xH = this.GetH(time);
        byte[] bytes = new byte[]{31, 45, 53, 4, (byte)a, (byte)b, (byte)xL, (byte)xH};
        this.addArrayToCommand(bytes);
    }

    public void fromFeedLine(int line) {
        int xL = this.GetL(line);
        int xH = this.GetH(line);
        byte[] bytes = new byte[]{31, 45, 65, 2, (byte)xL, (byte)xH};
        this.addArrayToCommand(bytes);
    }

    public void cutter(int m, int n) {
        int xL = this.GetL(m);
        int xH = this.GetH(m);
        int yL = this.GetL(n);
        int yH = this.GetH(n);
        byte[] bytes = new byte[]{31, 45, 68, 4, (byte)xL, (byte)xH, (byte)yL, (byte)yH};
        this.addArrayToCommand(bytes);
    }

    public void initID(int PID, int VID) {
        int xL = this.GetL(PID);
        int xH = this.GetH(PID);
        int yL = this.GetL(VID);
        int yH = this.GetH(VID);
        byte[] bytes = new byte[]{31, 45, 100, 4, (byte)xL, (byte)xH, (byte)yL, (byte)yH};
        this.addArrayToCommand(bytes);
    }

    public void defaultPrintTextBitmap(Context context, int width, int height, String string, int x, int y) {
        Bitmap bitmap = BitmapUtil.StringToBitmap(context, string, width);
        this.defaultPrintBitmap(bitmap, x, y, width, height);
    }

    public void customPrintTextBitmap(Context context, int width, int height, String string, int x, int y, int include, int rotate, int widthtype, int heighttype) {
        Bitmap bitmap = BitmapUtil.StringToBitmap(context, string, width);
        this.customPrintBitmap(bitmap, x, y, width, height, include, rotate, widthtype, heighttype);
    }

    public void verify() {
        byte[] bytes = new byte[]{31, 99};
        this.addArrayToCommand(bytes);
    }

    public void cutAll() {
        byte[] bytes = new byte[]{27, 105};
        this.addArrayToCommand(bytes);
    }

    public void cutHalf() {
        byte[] bytes = new byte[]{27, 109};
        this.addArrayToCommand(bytes);
    }

    public void paper() {
        byte[] bytes = new byte[]{16, 4, 1};
        this.addArrayToCommand(bytes);
    }

    public void paperWillRunOut() {
        byte[] bytes = new byte[]{16, 5, 1};
        this.addArrayToCommand(bytes);
    }

    public void checkTemperatureState() {
        byte[] bytes = new byte[]{16, 6, 1};
        this.addArrayToCommand(bytes);
    }

    public void checkCutterState() {
        byte[] bytes = new byte[]{16, 7, 1};
        this.addArrayToCommand(bytes);
    }

    public void checkRubberRollerState() {
        byte[] bytes = new byte[]{16, 8, 1};
        this.addArrayToCommand(bytes);
    }

    public void checkPaperJamState() {
        byte[] bytes = new byte[]{16, 9, 1};
        this.addArrayToCommand(bytes);
    }

    public void getTemperatureValue() {
        byte[] bytes = new byte[]{16, 10, 1};
        this.addArrayToCommand(bytes);
    }

    public void getVoltageValue() {
        byte[] bytes = new byte[]{16, 11, 1};
        this.addArrayToCommand(bytes);
    }

    public void checkVoltageState() {
        byte[] bytes = new byte[]{16, 12, 1};
        this.addArrayToCommand(bytes);
    }

    public void checkBluetoothState() {
        byte[] bytes = new byte[]{16, 13, 1};
        this.addArrayToCommand(bytes);
    }

    public void getPrintedPaperCountOfLabel() {
        byte[] bytes = new byte[]{16, 14, 1};
        this.addArrayToCommand(bytes);
    }

    public void resetPaperStateOrCutter() {
        byte[] bytes = new byte[]{17, 4, 1};
        this.addArrayToCommand(bytes);
    }

    public void resetCutter() {
        byte[] bytes = new byte[]{17, 5, 1};
        this.addArrayToCommand(bytes);
    }
}

