/*
 * Decompiled with CFR 0.152.
 */
package com.print.usbprint.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.Base64;
import com.print.usbprint.util.StringBitmapParameter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public final class BitmapUtil {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 64;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int SIXBIT = 6;
    private static final int FOURBYTE = 4;
    private static final int SIGN = -128;
    private static final char PAD = '=';
    private static final boolean fDebug = false;
    private static final byte[] base64Alphabet;
    private static final char[] lookUpBase64Alphabet;
    private static final int WIDTH = 384;
    private static final float SMALL_TEXT = 23.0f;
    private static final float LARGE_TEXT = 35.0f;
    private static final int START_RIGHT = 384;
    private static final int START_LEFT = 0;
    private static final int START_CENTER = 192;
    public static final int IS_LARGE = 10;
    public static final int IS_SMALL = 11;
    public static final int IS_RIGHT = 100;
    public static final int IS_LEFT = 101;
    public static final int IS_CENTER = 102;
    private static float x;
    private static float y;

    protected static boolean isWhiteSpace(char octect) {
        return octect == ' ' || octect == '\r' || octect == '\n' || octect == '\t';
    }

    protected static boolean isPad(char octect) {
        return octect == '=';
    }

    protected static boolean isData(char octect) {
        return base64Alphabet[octect] != -1;
    }

    protected static boolean isBase64(char octect) {
        return BitmapUtil.isWhiteSpace(octect) || BitmapUtil.isPad(octect) || BitmapUtil.isData(octect);
    }

    public static String encode(byte[] binaryData) {
        byte val2;
        byte val1;
        byte k;
        byte l;
        byte b3;
        byte b2;
        byte b1;
        if (binaryData == null) {
            return null;
        }
        int lengthDataBits = binaryData.length * 8;
        if (lengthDataBits == 0) {
            return "";
        }
        int fewerThan24bits = lengthDataBits % 24;
        int numberTriplets = lengthDataBits / 24;
        int numberQuartet = fewerThan24bits != 0 ? numberTriplets + 1 : numberTriplets;
        int numberLines = (numberQuartet - 1) / 19 + 1;
        Object encodedData = null;
        int encodedIndex = 0;
        int dataIndex = 0;
        int i = 0;
        for (int line = 0; line < numberLines - 1; ++line) {
            for (int quartet = 0; quartet < 19; ++quartet) {
                b1 = binaryData[dataIndex++];
                b2 = binaryData[dataIndex++];
                b3 = binaryData[dataIndex++];
                l = (byte)(b2 & 0xF);
                k = (byte)(b1 & 3);
                val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
                byte val22 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
                byte val3 = (b3 & 0xFFFFFF80) == 0 ? (byte)(b3 >> 6) : (byte)(b3 >> 6 ^ 0xFC);
                encodedData[encodedIndex++] = lookUpBase64Alphabet[val1];
                encodedData[encodedIndex++] = lookUpBase64Alphabet[val22 | k << 4];
                encodedData[encodedIndex++] = lookUpBase64Alphabet[l << 2 | val3];
                encodedData[encodedIndex++] = lookUpBase64Alphabet[b3 & 0x3F];
                ++i;
            }
            encodedData[encodedIndex++] = 10;
        }
        while (i < numberTriplets) {
            b1 = binaryData[dataIndex++];
            b2 = binaryData[dataIndex++];
            b3 = binaryData[dataIndex++];
            l = (byte)(b2 & 0xF);
            k = (byte)(b1 & 3);
            byte var10000 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            val2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
            val1 = (b3 & 0xFFFFFF80) == 0 ? (byte)(b3 >> 6) : (byte)(b3 >> 6 ^ 0xFC);
            encodedData[encodedIndex++] = lookUpBase64Alphabet[val1];
            encodedData[encodedIndex++] = lookUpBase64Alphabet[val2 | k << 4];
            encodedData[encodedIndex++] = lookUpBase64Alphabet[l << 2 | val1];
            encodedData[encodedIndex++] = lookUpBase64Alphabet[b3 & 0x3F];
            ++i;
        }
        if (fewerThan24bits == 8) {
            b1 = binaryData[dataIndex];
            k = (byte)(b1 & 3);
            val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            encodedData[encodedIndex++] = lookUpBase64Alphabet[val1];
            encodedData[encodedIndex++] = lookUpBase64Alphabet[k << 4];
            encodedData[encodedIndex++] = 61;
            encodedData[encodedIndex++] = 61;
        } else if (fewerThan24bits == 16) {
            b1 = binaryData[dataIndex];
            b2 = binaryData[dataIndex + 1];
            l = (byte)(b2 & 0xF);
            k = (byte)(b1 & 3);
            val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            val2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
            encodedData[encodedIndex++] = lookUpBase64Alphabet[val1];
            encodedData[encodedIndex++] = lookUpBase64Alphabet[val2 | k << 4];
            encodedData[encodedIndex++] = lookUpBase64Alphabet[l << 2];
            encodedData[encodedIndex++] = 61;
        }
        encodedData[encodedIndex] = 10;
        return new String(encodedData);
    }

    public static byte[] decode(String encoded) {
        byte b4;
        byte b3;
        byte b2;
        byte b1;
        char d4;
        char d3;
        char d2;
        char d1;
        int i;
        if (encoded == null) {
            return null;
        }
        char[] base64Data = encoded.toCharArray();
        int len = BitmapUtil.removeWhiteSpace(base64Data);
        if (len % 4 != 0) {
            return null;
        }
        int numberQuadruple = len / 4;
        if (numberQuadruple == 0) {
            return new byte[0];
        }
        int encodedIndex = 0;
        int dataIndex = 0;
        byte[] decodedData = new byte[numberQuadruple * 3];
        for (i = 0; i < numberQuadruple - 1; ++i) {
            if (!(BitmapUtil.isData(d1 = base64Data[dataIndex++]) && BitmapUtil.isData(d2 = base64Data[dataIndex++]) && BitmapUtil.isData(d3 = base64Data[dataIndex++]) && BitmapUtil.isData(d4 = base64Data[dataIndex++]))) {
                return null;
            }
            b1 = base64Alphabet[d1];
            b2 = base64Alphabet[d2];
            b3 = base64Alphabet[d3];
            b4 = base64Alphabet[d4];
            decodedData[encodedIndex++] = (byte)(b1 << 2 | b2 >> 4);
            decodedData[encodedIndex++] = (byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF);
            decodedData[encodedIndex++] = (byte)(b3 << 6 | b4);
        }
        if (BitmapUtil.isData(d1 = base64Data[dataIndex++]) && BitmapUtil.isData(d2 = base64Data[dataIndex++])) {
            b1 = base64Alphabet[d1];
            b2 = base64Alphabet[d2];
            d3 = base64Data[dataIndex++];
            d4 = base64Data[dataIndex++];
            if (BitmapUtil.isData(d3) && BitmapUtil.isData(d4)) {
                b3 = base64Alphabet[d3];
                b4 = base64Alphabet[d4];
                decodedData[encodedIndex++] = (byte)(b1 << 2 | b2 >> 4);
                decodedData[encodedIndex++] = (byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF);
                decodedData[encodedIndex++] = (byte)(b3 << 6 | b4);
                return decodedData;
            }
            if (BitmapUtil.isPad(d3) && BitmapUtil.isPad(d4)) {
                if ((b2 & 0xF) != 0) {
                    return null;
                }
                byte[] tmp = new byte[i * 3 + 1];
                System.arraycopy(decodedData, 0, tmp, 0, i * 3);
                tmp[encodedIndex] = (byte)(b1 << 2 | b2 >> 4);
                return tmp;
            }
            if (!BitmapUtil.isPad(d3) && BitmapUtil.isPad(d4)) {
                b3 = base64Alphabet[d3];
                if ((b3 & 3) != 0) {
                    return null;
                }
                byte[] tmp = new byte[i * 3 + 2];
                System.arraycopy(decodedData, 0, tmp, 0, i * 3);
                tmp[encodedIndex++] = (byte)(b1 << 2 | b2 >> 4);
                tmp[encodedIndex] = (byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF);
                return tmp;
            }
            return null;
        }
        return null;
    }

    protected static int removeWhiteSpace(char[] data) {
        if (data == null) {
            return 0;
        }
        int newSize = 0;
        int len = data.length;
        for (int i = 0; i < len; ++i) {
            if (BitmapUtil.isWhiteSpace(data[i])) continue;
            data[newSize++] = data[i];
        }
        return newSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String bitmapToBase64(Bitmap bitmap) {
        String result = null;
        ByteArrayOutputStream baos = null;
        try {
            if (bitmap != null) {
                baos = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
                baos.flush();
                baos.close();
                byte[] bitmapBytes = baos.toByteArray();
                result = Base64.encodeToString((byte[])bitmapBytes, (int)0);
            }
        }
        catch (IOException var12) {
            var12.printStackTrace();
        }
        finally {
            try {
                if (baos != null) {
                    baos.flush();
                    baos.close();
                }
            }
            catch (IOException var11) {
                var11.printStackTrace();
            }
        }
        return result;
    }

    public static Bitmap base64ToBitmap(String base64Data) {
        byte[] bytes = Base64.decode((String)base64Data, (int)0);
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    public static Bitmap compressPic(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int newWidth = width >= 380 ? 380 : width;
        int newHeight = newWidth * height / width;
        Bitmap targetBmp = Bitmap.createBitmap((int)newWidth, (int)newHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas targetCanvas = new Canvas(targetBmp);
        targetCanvas.drawColor(-1);
        targetCanvas.drawBitmap(bitmap, new Rect(0, 0, width, height), new Rect(0, 0, newWidth, newHeight), (Paint)null);
        return targetBmp;
    }

    public static Bitmap StringListtoBitmap(Context context, ArrayList<StringBitmapParameter> AllString, int width) {
        if (AllString.size() <= 0) {
            return Bitmap.createBitmap((int)width, (int)(width / 4), (Bitmap.Config)Bitmap.Config.RGB_565);
        }
        ArrayList<StringBitmapParameter> mBreakString = new ArrayList<StringBitmapParameter>();
        Paint paint = new Paint();
        paint.setAntiAlias(false);
        paint.setTextSize(23.0f);
        Typeface typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/songti.TTF");
        Typeface font = Typeface.create((Typeface)typeface, (int)0);
        paint.setTypeface(font);
        for (StringBitmapParameter mParameter : AllString) {
            int lenght;
            int ALineLength = paint.breakText(mParameter.getText(), true, 384.0f, null);
            if (ALineLength < (lenght = mParameter.getText().length())) {
                int num = lenght / ALineLength;
                String ALineString = new String();
                String RemainString = new String();
                for (int j = 0; j < num; ++j) {
                    ALineString = mParameter.getText().substring(j * ALineLength, (j + 1) * ALineLength);
                    mBreakString.add(new StringBitmapParameter(ALineString, mParameter.getIsRightOrLeft(), mParameter.getIsSmallOrLarge()));
                }
                RemainString = mParameter.getText().substring(num * ALineLength, mParameter.getText().length());
                mBreakString.add(new StringBitmapParameter(RemainString, mParameter.getIsRightOrLeft(), mParameter.getIsSmallOrLarge()));
                continue;
            }
            mBreakString.add(mParameter);
        }
        Paint.FontMetrics fontMetrics = paint.getFontMetrics();
        int FontHeight = (int)Math.abs(fontMetrics.leading) + (int)Math.abs(fontMetrics.ascent) + (int)Math.abs(fontMetrics.descent);
        y = (int)Math.abs(fontMetrics.leading) + (int)Math.abs(fontMetrics.ascent);
        int bNum = 0;
        for (StringBitmapParameter mParameter : mBreakString) {
            String bStr = mParameter.getText();
            if (!(bStr.isEmpty() | bStr.contains("\n") | mParameter.getIsSmallOrLarge() == 10)) continue;
            ++bNum;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)384, (int)(FontHeight * (mBreakString.size() + bNum)), (Bitmap.Config)Bitmap.Config.RGB_565);
        for (int i = 0; i < bitmap.getWidth(); ++i) {
            for (int j = 0; j < bitmap.getHeight(); ++j) {
                bitmap.setPixel(i, j, -1);
            }
        }
        Canvas canvas = new Canvas(bitmap);
        for (StringBitmapParameter mParameter : mBreakString) {
            String str = mParameter.getText();
            if (mParameter.getIsSmallOrLarge() == 11) {
                paint.setTextSize(23.0f);
            } else if (mParameter.getIsSmallOrLarge() == 10) {
                paint.setTextSize(35.0f);
            }
            if (mParameter.getIsRightOrLeft() == 100) {
                x = 384.0f - paint.measureText(str);
            } else if (mParameter.getIsRightOrLeft() == 101) {
                x = 0.0f;
            } else if (mParameter.getIsRightOrLeft() == 102) {
                x = (384.0f - paint.measureText(str)) / 2.0f;
            }
            if (str.isEmpty() | str.contains("\n") | mParameter.getIsSmallOrLarge() == 10) {
                canvas.drawText(str, x, y + (float)(FontHeight / 2), paint);
                y += (float)FontHeight;
            } else {
                canvas.drawText(str, x, y, paint);
            }
            y += (float)FontHeight;
        }
        canvas.save();
        canvas.restore();
        return bitmap;
    }

    public static Bitmap addBitmapInHead(Bitmap first, Bitmap second) {
        int width = Math.max(first.getWidth(), second.getWidth());
        int startWidth = (width - first.getWidth()) / 2;
        int height = first.getHeight() + second.getHeight();
        Bitmap result = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        for (int i = 0; i < result.getWidth(); ++i) {
            for (int j = 0; j < result.getHeight(); ++j) {
                result.setPixel(i, j, -1);
            }
        }
        Canvas canvas = new Canvas(result);
        canvas.drawBitmap(first, (float)startWidth, 0.0f, null);
        canvas.drawBitmap(second, 0.0f, (float)first.getHeight(), null);
        return result;
    }

    public static Bitmap addBitmapInFoot(Bitmap bitmap, Bitmap image) {
        int width = Math.max(bitmap.getWidth(), image.getWidth());
        int startWidth = (width - image.getWidth()) / 2;
        int height = bitmap.getHeight() + image.getHeight();
        Bitmap result = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        for (int i = 0; i < result.getWidth(); ++i) {
            for (int j = 0; j < result.getHeight(); ++j) {
                result.setPixel(i, j, -1);
            }
        }
        Canvas canvas = new Canvas(result);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        canvas.drawBitmap(image, (float)startWidth, (float)bitmap.getHeight(), null);
        return result;
    }

    public static Bitmap StringToBitmap(Context context, String string, int width) {
        Bitmap bitmap = null;
        ArrayList<StringBitmapParameter> mParameters = new ArrayList<StringBitmapParameter>();
        mParameters.add(new StringBitmapParameter(string));
        bitmap = BitmapUtil.StringListtoBitmap(context, mParameters, width);
        return bitmap;
    }

    static {
        int i;
        base64Alphabet = new byte[255];
        lookUpBase64Alphabet = new char[64];
        for (i = 0; i < 255; ++i) {
            BitmapUtil.base64Alphabet[i] = -1;
        }
        for (i = 90; i >= 65; --i) {
            BitmapUtil.base64Alphabet[i] = (byte)(i - 65);
        }
        for (i = 122; i >= 97; --i) {
            BitmapUtil.base64Alphabet[i] = (byte)(i - 97 + 26);
        }
        for (i = 57; i >= 48; --i) {
            BitmapUtil.base64Alphabet[i] = (byte)(i - 48 + 52);
        }
        BitmapUtil.base64Alphabet[43] = 62;
        BitmapUtil.base64Alphabet[47] = 63;
        for (i = 0; i <= 25; ++i) {
            BitmapUtil.lookUpBase64Alphabet[i] = (char)(65 + i);
        }
        i = 26;
        int j = 0;
        while (i <= 51) {
            BitmapUtil.lookUpBase64Alphabet[i] = (char)(97 + j);
            ++i;
            ++j;
        }
        i = 52;
        j = 0;
        while (i <= 61) {
            BitmapUtil.lookUpBase64Alphabet[i] = (char)(48 + j);
            ++i;
            ++j;
        }
        BitmapUtil.lookUpBase64Alphabet[62] = 43;
        BitmapUtil.lookUpBase64Alphabet[63] = 47;
        x = 0.0f;
    }
}

