package com.caysn.autoreplyprint;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;

public interface NZPrivate extends Library {

    // static interface method need jdk1.8. here we use inner class to avoid this porblem.
    class GetLibraryPath_Helper {
        // can replaced by absolute path
        public static String GetLibraryPath() {
            // force call JNI_OnLoad
            if (Platform.isAndroid())
                System.loadLibrary("autoreplyprint");
            return "autoreplyprint";
        }
    }

    public static final NZPrivate INSTANCE = (NZPrivate) Native.loadLibrary(NZPrivate.GetLibraryPath_Helper.GetLibraryPath(), NZPrivate.class);

    public Pointer CP_Port_OpenMemoryBuffer(int buffer_size);

    public Pointer CP_Port_GetMemoryBufferDataPointer(Pointer handle);

    public int CP_Port_GetMemoryBufferDataLength(Pointer handle);

    public boolean CP_Port_ClearMemoryBufferData(Pointer handle);

    public class CP_Port_GetMemoryBufferData_Helper {
        public static byte[] GetMemoryBufferData(Pointer handle) {
            Pointer dataPointer = INSTANCE.CP_Port_GetMemoryBufferDataPointer(handle);
            int dataLength = INSTANCE.CP_Port_GetMemoryBufferDataLength(handle);
            if ((dataPointer != null) && (dataPointer != Pointer.NULL) && (dataLength > 0)) {
                return dataPointer.getByteArray(0, dataLength);
            }
            return null;
        }
    }

    public int CP_Pos_SetExitQueryCmd(Pointer handle, int exit_query_cmd);

    public void CP_Logger_SetDebugEnabled(boolean enabled);

    public void CP_Logger_SetLogToFile(String pszFile);

}
