package com.caysn.autoreplyprint;

import android.graphics.Bitmap;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.ptr.IntByReference;

public interface NZQrcode extends Library {

    // static interface method need jdk1.8. here we use inner class to avoid this porblem.
    class GetLibraryPath_Helper {
        // can replaced by absolute path
        public static String GetLibraryPath() {
            // force call JNI_OnLoad
            if (Platform.isAndroid())
                System.loadLibrary("autoreplyprint");
            return "autoreplyprint";
        }
    }

    public static final NZQrcode INSTANCE = (NZQrcode) Native.loadLibrary(NZQrcode.GetLibraryPath_Helper.GetLibraryPath(), NZQrcode.class);

    public int CP_Qrcode_GetQrcodeWidth(String qrcodeData, int qrcodeVersion, int qrcodeEccLevel);

    public boolean CP_Qrcode_GetQrcodeRGBAData(String qrcodeData, int qrcodeVersion, int qrcodeEccLevel, int backgroundColor, int qrcodeColor, int[] bitmap_buffer, int bitmap_buffer_bytesize, IntByReference bitmap_width, IntByReference bitmap_height);

    public class NZQrcodeHelper {
        public static Bitmap GetQrcodeBitmap(String qrcodeData, int qrcodeVersion, int qrcodeEccLevel, int backgroundColor, int qrcodeColor) {
            Bitmap bitmap = null;
            try {
                int qrcodeWidth = NZQrcode.INSTANCE.CP_Qrcode_GetQrcodeWidth(qrcodeData, qrcodeVersion, qrcodeEccLevel);
                if (qrcodeWidth > 0) {
                    int bitmap_buffer_bytesize = qrcodeWidth * qrcodeWidth * 4;
                    int[] bitmap_buffer = new int[qrcodeWidth * qrcodeWidth];
                    if (bitmap_buffer != null) {
                        IntByReference bitmap_width = new IntByReference();
                        IntByReference bitmap_height = new IntByReference();
                        if (NZQrcode.INSTANCE.CP_Qrcode_GetQrcodeRGBAData(qrcodeData, qrcodeVersion, qrcodeEccLevel, backgroundColor, qrcodeColor, bitmap_buffer, bitmap_buffer_bytesize, bitmap_width, bitmap_height)) {
                            int width = bitmap_width.getValue();
                            int height = bitmap_height.getValue();
                            int[] pixels = bitmap_buffer;
                            bitmap = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
                            bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
                        }
                    }
                }
            } catch (Throwable tr) {
                tr.printStackTrace();
            }
            return bitmap;
        }
    }

}
