/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.speech;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.iflytek.cloud.InitListener;
import com.iflytek.cloud.SpeechUtility;
import com.iflytek.cloud.b.a;
import com.iflytek.cloud.msc.util.log.DebugLog;
import com.iflytek.speech.ISpeechModule;
import com.iflytek.speech.UtilityConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;

abstract class SpeechModuleAidl<I extends IInterface>
implements ISpeechModule {
    protected Object mSynLock;
    protected I mService;
    protected Context mContext;
    private ServiceConnection mConnection;
    private InitListener mInitListener;
    private String mBindAction;
    private HashMap<String, String> mParams;
    private volatile boolean userDestroy;
    private Handler mUiHandler;

    public SpeechModuleAidl(Context context, InitListener initListener, String string) {
        Handler handler;
        HashMap hashMap;
        Object object;
        SpeechModuleAidl speechModuleAidl = this;
        Object object2 = object;
        object = new Object();
        speechModuleAidl.mSynLock = object2;
        speechModuleAidl.mContext = null;
        speechModuleAidl.mConnection = null;
        speechModuleAidl.mInitListener = null;
        speechModuleAidl.mBindAction = null;
        object2 = hashMap;
        hashMap = new HashMap();
        speechModuleAidl.mParams = object2;
        speechModuleAidl.userDestroy = false;
        object2 = handler;
        handler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message message) {
                if (SpeechModuleAidl.this.mInitListener == null) {
                    return;
                }
                SpeechModuleAidl.this.mInitListener.onInit(message.what);
            }
        };
        speechModuleAidl.mUiHandler = object2;
        speechModuleAidl.mContext = context;
        speechModuleAidl.mInitListener = initListener;
        speechModuleAidl.mBindAction = string;
        speechModuleAidl.bindService();
    }

    private void bindService() {
        ServiceConnection serviceConnection;
        SpeechModuleAidl speechModuleAidl = this;
        Context context = speechModuleAidl.mContext;
        if (!speechModuleAidl.isActionInstalled(context, speechModuleAidl.mBindAction)) {
            if (this.mInitListener != null) {
                Message.obtain((Handler)this.mUiHandler, (int)21001, (int)0, (int)0, null).sendToTarget();
            }
            return;
        }
        SpeechModuleAidl speechModuleAidl2 = this;
        context = speechModuleAidl2.getIntent();
        context.setAction(this.mBindAction);
        context.setPackage("com.iflytek.vflynote");
        ServiceConnection serviceConnection2 = serviceConnection;
        speechModuleAidl2.mConnection = new ServiceConnection(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onServiceConnected(ComponentName object, IBinder iBinder) {
                1 v0 = this;
                Object object2 = v0.SpeechModuleAidl.this.mSynLock;
                synchronized (object2) {
                    Log.d((String)v0.SpeechModuleAidl.this.getTag(), (String)"init success");
                    {
                        void var2_3;
                        v0.SpeechModuleAidl.this.mService = v0.SpeechModuleAidl.this.getService((IBinder)var2_3);
                        Log.d((String)v0.SpeechModuleAidl.this.getTag(), (String)("mService :" + SpeechModuleAidl.this.mService));
                    }
                    {
                        if (v0.SpeechModuleAidl.this.mInitListener != null) {
                            Message.obtain((Handler)SpeechModuleAidl.this.mUiHandler, (int)0, (int)0, (int)0, null).sendToTarget();
                        }
                        return;
                    }
                }
            }

            public void onServiceDisconnected(ComponentName componentName) {
                1 v0 = this;
                Log.d((String)v0.SpeechModuleAidl.this.getTag(), (String)"onServiceDisconnected");
                v0.SpeechModuleAidl.this.mService = null;
                if (!v0.SpeechModuleAidl.this.userDestroy) {
                    try {
                        SpeechModuleAidl.this.bindService();
                    }
                    catch (Exception exception) {
                        Log.e((String)SpeechModuleAidl.this.getTag(), (String)("rebindService error = " + exception.toString()));
                    }
                }
            }
        };
        try {
            speechModuleAidl2.mContext.bindService((Intent)context, serviceConnection2, 1);
        }
        catch (SecurityException securityException) {
            DebugLog.LogE(securityException);
        }
    }

    private I getService(IBinder iBinder) {
        SpeechModuleAidl speechModuleAidl = string;
        SpeechModuleAidl speechModuleAidl2 = speechModuleAidl;
        String string = ((Class)((ParameterizedType)speechModuleAidl.getClass().getGenericSuperclass()).getActualTypeArguments()[0]).getName();
        Log.d((String)speechModuleAidl2.getTag(), (String)("className = " + (String)string));
        Class<?> clazz = Class.forName((String)string + "$Stub");
        Class[] classArray = new Class[1];
        classArray[0] = IBinder.class;
        Method method = clazz.getDeclaredMethod("asInterface", classArray);
        try {
            return (I)((IInterface)method.invoke(null, iBinder));
        }
        catch (Exception exception) {
            DebugLog.LogE(exception);
        }
        catch (InvocationTargetException invocationTargetException) {
            DebugLog.LogE(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            DebugLog.LogE(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugLog.LogE(illegalArgumentException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            DebugLog.LogE(noSuchMethodException);
        }
        catch (SecurityException securityException) {
            DebugLog.LogE(securityException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            DebugLog.LogE(classNotFoundException);
        }
        return null;
    }

    @Override
    public boolean isAvailable() {
        return this.mService != null;
    }

    @Override
    public int setParameter(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 20012;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.mParams.remove(string);
            return 0;
        }
        this.mParams.put(string, string2);
        return 0;
    }

    @Override
    public String getParameter(String string) {
        return this.mParams.get(string);
    }

    @Override
    public Intent getIntent() {
        Intent intent;
        Intent intent2 = intent;
        intent = new Intent();
        if (!this.mParams.isEmpty()) {
            for (String string : this.mParams.keySet()) {
                intent2.putExtra(string, this.mParams.get(string));
            }
            HashMap<String, String> hashMap = new a(this.mParams.get("params"), null).c();
            if (hashMap != null && !hashMap.isEmpty()) {
                for (String string : hashMap.keySet()) {
                    intent2.putExtra(string, (String)hashMap.get(string));
                }
            }
        }
        Intent intent3 = intent2;
        intent2.putExtra("caller.appid", SpeechUtility.getUtility().getParameter("appid"));
        intent2.putExtra("caller.name", UtilityConfig.getCallerInfo(this.mContext, "caller.name"));
        intent2.putExtra("caller.pkg", UtilityConfig.getCallerInfo(this.mContext, "caller.pkg"));
        intent2.putExtra("caller.ver.name", UtilityConfig.getCallerInfo(this.mContext, "caller.ver.name"));
        intent3.putExtra("caller.ver.code", UtilityConfig.getCallerInfo(this.mContext, "caller.ver.code"));
        return intent3;
    }

    public boolean isActionInstalled(Context context, String string) {
        if (context != null && !TextUtils.isEmpty((CharSequence)string)) {
            return context.getPackageManager().resolveService(new Intent(string), 0) != null;
        }
        return false;
    }

    @Override
    public boolean destory() {
        block3: {
            ServiceConnection serviceConnection;
            SpeechModuleAidl speechModuleAidl = this;
            Log.d((String)speechModuleAidl.getTag(), (String)"destory");
            try {
                speechModuleAidl.userDestroy = true;
                serviceConnection = speechModuleAidl.mConnection;
                if (serviceConnection == null) break block3;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugLog.LogE(illegalArgumentException);
                return false;
            }
            this.mContext.unbindService(serviceConnection);
            this.mConnection = null;
        }
        return true;
    }

    protected final String getTag() {
        return this.getClass().toString();
    }
}

